/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.api;

import cfca.sadk.exception.CodeException;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKIException;
import cfca.util.Base64;
import cfca.util.HashUtil;
import cfca.util.cipher.lib.JCrypto;
import cfca.util.cipher.lib.Session;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BaseKit {
    private static Logger logger = LoggerFactory.getLogger(BaseKit.class);
    protected static Session session = null;
    private static final byte[] decodingTable;

    BaseKit() {
    }

    protected static void validParameters(String ... parameters) throws CodeException {
        if (parameters == null || parameters.length == 0) {
            logger.error("parameters is null");
            throw new CodeException("00", "param exception");
        }
        for (int i = 0; i < parameters.length; ++i) {
            String parameter = parameters[i];
            if (parameter != null && parameter.length() != 0) continue;
            int order = i + 1;
            logger.error("parameter is null");
            throw new CodeException("0" + order, "param exception");
        }
    }

    protected static String errorToJson(String classCode, String methodCode, String errorCode) {
        StringBuilder sb = new StringBuilder();
        sb.append("60");
        sb.append(classCode);
        sb.append(methodCode);
        sb.append(errorCode);
        JSONObject obj = new JSONObject();
        obj.put("Code", (Object)sb.toString());
        return obj.toJSONString();
    }

    protected static String errorToJson(String classCode, String methodCode, String errorCode, String ... codes) {
        StringBuilder sb = new StringBuilder();
        sb.append("60");
        sb.append(classCode);
        sb.append(methodCode);
        sb.append(errorCode);
        JSONObject obj = new JSONObject();
        obj.put("Code", (Object)sb.toString());
        for (int i = 0; i < codes.length; i += 2) {
            obj.put(codes[i], (Object)codes[i + 1]);
        }
        return obj.toJSONString();
    }

    protected static String successToJson(String ... codes) throws CodeException {
        if (codes == null || codes.length == 0 || codes.length % 2 != 0) {
            throw new CodeException("91", "bad json codes");
        }
        JSONObject obj = new JSONObject();
        for (int i = 0; i < codes.length; i += 2) {
            obj.put(codes[i], (Object)codes[i + 1]);
        }
        obj.put("Code", (Object)"90000000");
        return obj.toJSONString();
    }

    protected static String exceptionToJson(String classCode, String methodCode, Throwable e) {
        try {
            logger.error(classCode, e);
            if (e instanceof CodeException) {
                CodeException commonException = (CodeException)e;
                return BaseKit.errorToJson(classCode, methodCode, commonException.getCode());
            }
            if (e instanceof PKIException) {
                PKIException pkiException = (PKIException)e;
                if ("850606".equals(pkiException.getErrCode())) {
                    return BaseKit.errorToJson(classCode, methodCode, "12", "SadkCode", pkiException.getErrCode());
                }
                if ("850411".equals(pkiException.getErrCode())) {
                    return BaseKit.errorToJson(classCode, methodCode, "13", "SadkCode", pkiException.getErrCode());
                }
                return BaseKit.errorToJson(classCode, methodCode, "90", "SadkCode", pkiException.getErrCode());
            }
            return BaseKit.errorToJson(classCode, methodCode, "91");
        }
        catch (Exception e1) {
            logger.error("error in base exceptionToJson", (Throwable)e1);
            return BaseKit.errorToJson(classCode, methodCode, "10");
        }
    }

    protected static String base64Encode(byte[] data) throws CodeException {
        try {
            return new String(Base64.encode((byte[])data));
        }
        catch (Exception e) {
            logger.error("base64Encode exception", (Throwable)e);
            throw new CodeException("10", "base64Encode exception", e);
        }
    }

    protected static byte[] base64Decode(String data) throws CodeException {
        try {
            return Base64.decode((String)data);
        }
        catch (Exception e) {
            logger.error("base64Decode exception", (Throwable)e);
            throw new CodeException("11", "base64Decode exception", e);
        }
    }

    protected static void debugLog(String classCode, String methodCode, String jsonObject) throws CodeException {
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(classCode);
            sb.append("-");
            sb.append(methodCode);
            sb.append(":");
            sb.append(jsonObject);
            logger.debug(sb.toString());
        }
    }

    public static String getHash(byte[] data) throws Exception {
        Mechanism mechanism = new Mechanism("MD5");
        byte[] hash = HashUtil.rsaHashMessage((byte[])data, (Mechanism)mechanism);
        return BaseKit.base64Encode(hash);
    }

    public static boolean isBase64Encode(byte[] data) {
        boolean passed = true;
        if (data == null) {
            passed = false;
        } else {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] < 0) {
                    passed = false;
                    break;
                }
                if (decodingTable[data[i]] >= 0) continue;
                passed = false;
                break;
            }
        }
        return passed;
    }

    static final void initialiseDecodingTable() {
        int i;
        byte[] encoding = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        for (i = 0; i < decodingTable.length; ++i) {
            BaseKit.decodingTable[i] = -1;
        }
        for (i = 0; i < encoding.length; ++i) {
            BaseKit.decodingTable[encoding[i]] = (byte)i;
        }
        byte[] others = new byte[]{61, 32, 13, 10, 9};
        for (int i2 = 0; i2 < others.length; ++i2) {
            BaseKit.decodingTable[others[i2]] = (byte)i2;
        }
    }

    static {
        try {
            JCrypto crypto = JCrypto.getInstance();
            crypto.initialize("JSOFT_LIB", null);
            session = crypto.openSession("JSOFT_LIB");
        }
        catch (PKIException e) {
            logger.error("session init error", (Throwable)e);
        }
        decodingTable = new byte[128];
        BaseKit.initialiseDecodingTable();
    }
}

