/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.api;

import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.api.BaseKit;
import cfca.sm.algorithm.SM2Pfx;
import cfca.util.CertUtil;
import cfca.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

final class CertKit
extends BaseKit {
    private static Map<String, X509Cert> certificateMap = new HashMap<String, X509Cert>();

    CertKit() {
    }

    public static final X509Cert getCertFromPFX(String key, byte[] pfxData, String password) throws Exception {
        X509Cert x509Cert = certificateMap.get(key);
        if (x509Cert != null) {
            return x509Cert;
        }
        x509Cert = CertUtil.getCertFromPfx((byte[])pfxData, (String)password);
        if (certificateMap.size() < 1000) {
            certificateMap.put(key, x509Cert);
        }
        return x509Cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final X509Cert getCertFromSM2(String key, byte[] sm2Data) throws Exception {
        ASN1InputStream in = null;
        try {
            X509Cert x509Cert = certificateMap.get(key);
            if (x509Cert != null) {
                X509Cert x509Cert2 = x509Cert;
                return x509Cert2;
            }
            if (CertKit.isBase64Encode(sm2Data)) {
                sm2Data = CertKit.base64Decode(new String(sm2Data));
            }
            in = new ASN1InputStream((InputStream)new ByteArrayInputStream(sm2Data));
            SM2Pfx object = SM2Pfx.getInstance((Object)in.readObject());
            x509Cert = object.getPublicCert();
            if (certificateMap.size() < 1000) {
                certificateMap.put(key, x509Cert);
            }
            X509Cert x509Cert3 = x509Cert;
            return x509Cert3;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

