/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.api;

import cfca.sadk.api.BaseKit;
import cfca.sadk.api.CertKit;
import cfca.sadk.api.KeyKit;
import cfca.sadk.exception.CodeException;
import cfca.util.EnvelopeUtil;
import cfca.util.cipher.lib.Session;
import cfca.x509.certificate.X509Cert;
import java.security.PrivateKey;

public final class EnvelopeKit
extends BaseKit {
    private EnvelopeKit() {
    }

    public static final String envelopeMessage(String base64SourceData, String symmetricAlgorithm, String base64X509CertData) {
        try {
            EnvelopeKit.validParameters(base64SourceData, symmetricAlgorithm, base64X509CertData);
            symmetricAlgorithm = symmetricAlgorithm.trim();
            base64SourceData = base64SourceData.trim();
            base64X509CertData = base64X509CertData.trim();
            if (!("SM4/CBC/PKCS7Padding".equals(symmetricAlgorithm) || "DESede/CBC/PKCS7Padding".equals(symmetricAlgorithm) || "RC4".equals(symmetricAlgorithm))) {
                throw new CodeException("17", "not support symmetric algorithm" + symmetricAlgorithm);
            }
            byte[] sourceData = EnvelopeKit.base64Decode(base64SourceData);
            byte[] certBytes = EnvelopeKit.base64Decode(base64X509CertData);
            X509Cert x509Cert = new X509Cert(certBytes);
            byte[] base64Bytes = EnvelopeUtil.envelopeMessage((byte[])sourceData, (String)symmetricAlgorithm, (X509Cert[])new X509Cert[]{x509Cert}, (Session)session);
            String jsonObject = EnvelopeKit.successToJson("Base64EnvelopeMessage", new String(base64Bytes));
            EnvelopeKit.debugLog("02", "01", jsonObject);
            return jsonObject;
        }
        catch (Throwable e) {
            return EnvelopeKit.exceptionToJson("02", "01", e);
        }
    }

    public static final String openEvelopedMessage(String base64EnvelopeMessage, String symmetricAlgorithm, String base64P12Data, String p12Password) {
        try {
            EnvelopeKit.validParameters(base64EnvelopeMessage, symmetricAlgorithm, base64P12Data, p12Password);
            base64EnvelopeMessage = base64EnvelopeMessage.trim();
            symmetricAlgorithm = symmetricAlgorithm.trim();
            base64P12Data = base64P12Data.trim();
            p12Password = p12Password.trim();
            if (!("SM4/CBC/PKCS7Padding".equals(symmetricAlgorithm) || "DESede/CBC/PKCS7Padding".equals(symmetricAlgorithm) || "RC4".equals(symmetricAlgorithm))) {
                throw new CodeException("17", "not support symmetric algorithm" + symmetricAlgorithm);
            }
            byte[] p12Data = EnvelopeKit.base64Decode(base64P12Data);
            X509Cert x509Cert = null;
            PrivateKey privateKey = null;
            String key = EnvelopeKit.getHash(p12Data);
            if ("SM4/CBC/PKCS7Padding".equals(symmetricAlgorithm)) {
                x509Cert = CertKit.getCertFromSM2(key, p12Data);
                privateKey = KeyKit.getPrivateKeyFromSM2(key, p12Data, p12Password);
            } else {
                x509Cert = CertKit.getCertFromPFX(key, p12Data, p12Password);
                privateKey = KeyKit.getPrivateKeyFromPFX(key, p12Data, p12Password);
            }
            byte[] base64DevBytes = EnvelopeUtil.openEvelopedMessage((byte[])base64EnvelopeMessage.getBytes(), (PrivateKey)privateKey, (X509Cert)x509Cert, (Session)session);
            String jsonObject = EnvelopeKit.successToJson("Base64SourceString", EnvelopeKit.base64Encode(base64DevBytes));
            EnvelopeKit.debugLog("02", "02", jsonObject);
            return jsonObject;
        }
        catch (Throwable e) {
            return EnvelopeKit.exceptionToJson("02", "02", e);
        }
    }
}

