/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.api;

import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.api.BaseKit;
import cfca.sm.algorithm.SM2Pfx;
import cfca.util.Base64;
import cfca.util.KeyUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;

final class KeyKit
extends BaseKit {
    private static Map<String, PrivateKey> privateKeyMap = new HashMap<String, PrivateKey>();

    private KeyKit() {
    }

    public static final PrivateKey getPrivateKeyFromPFX(String key, byte[] pfxData, String password) throws Exception {
        PrivateKey privateKey = privateKeyMap.get(key);
        if (privateKey != null) {
            return privateKey;
        }
        privateKey = KeyUtil.getPrivateKeyFromPFX((byte[])pfxData, (String)password);
        if (privateKeyMap.size() < 1000) {
            privateKeyMap.put(key, privateKey);
        }
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PrivateKey getPrivateKeyFromSM2(String key, byte[] sm2Data, String password) throws Exception {
        ASN1InputStream in = null;
        try {
            PrivateKey privateKey = privateKeyMap.get(key);
            if (privateKey != null) {
                PrivateKey privateKey2 = privateKey;
                return privateKey2;
            }
            if (KeyKit.isBase64Encode(sm2Data)) {
                sm2Data = Base64.decode((byte[])sm2Data);
            }
            in = new ASN1InputStream((InputStream)new ByteArrayInputStream(sm2Data));
            SM2Pfx object = SM2Pfx.getInstance((Object)in.readObject());
            privateKey = object.getPrivateKey(password);
            if (privateKeyMap.size() < 1000) {
                privateKeyMap.put(key, privateKey);
            }
            PrivateKey privateKey3 = privateKey;
            return privateKey3;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

