/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.api;

import cfca.sadk.api.BaseKit;
import cfca.sadk.api.KeyKit;
import cfca.sadk.exception.CodeException;
import cfca.util.SignatureUtil2;
import cfca.x509.certificate.X509Cert;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class SignatureKit
extends BaseKit {
    private SignatureKit() {
    }

    public static final String P1SignMessage(String signAlg, String base64SourceData, String base64P12Data, String p12Password) {
        try {
            SignatureKit.validParameters(signAlg, base64SourceData, base64P12Data, p12Password);
            signAlg = signAlg.trim();
            base64SourceData = base64SourceData.trim();
            base64P12Data = base64P12Data.trim();
            p12Password = p12Password.trim();
            if (!("SHA1withRSAEncryption".equals(signAlg) || "SHA256withRSAEncryption".equals(signAlg) || "SHA512withRSA".equals(signAlg) || "SM3withSM2".equals(signAlg))) {
                throw new CodeException("16", "not support signature algorithm" + signAlg);
            }
            byte[] sourceData = SignatureKit.base64Decode(base64SourceData);
            byte[] p12Data = SignatureKit.base64Decode(base64P12Data);
            PrivateKey privateKey = null;
            privateKey = "SM3withSM2".equals(signAlg) ? KeyKit.getPrivateKeyFromSM2(SignatureKit.getHash(p12Data), p12Data, p12Password) : KeyKit.getPrivateKeyFromPFX(SignatureKit.getHash(p12Data), p12Data, p12Password);
            SignatureUtil2 signatureUtil2 = new SignatureUtil2();
            byte[] base64Bytes = signatureUtil2.p1SignMessage(signAlg, sourceData, privateKey, session);
            String jsonObject = SignatureKit.successToJson("Base64SignatureData", new String(base64Bytes));
            SignatureKit.debugLog("01", "01", jsonObject);
            return jsonObject;
        }
        catch (Throwable e) {
            return SignatureKit.exceptionToJson("01", "01", e);
        }
    }

    public static final String P1VerifyMessage(String signAlg, String base64SourceData, String base64X509CertData, String base64P1SignatureData) {
        try {
            byte[] x509CertData;
            X509Cert x509Cert;
            PublicKey publicKey;
            byte[] signatureData;
            SignatureKit.validParameters(signAlg, base64SourceData, base64X509CertData, base64P1SignatureData);
            signAlg = signAlg.trim();
            base64SourceData = base64SourceData.trim();
            base64X509CertData = base64X509CertData.trim();
            base64P1SignatureData = base64P1SignatureData.trim();
            if (!("SHA1withRSAEncryption".equals(signAlg) || "SHA256withRSAEncryption".equals(signAlg) || "SHA512withRSA".equals(signAlg) || "SM3withSM2".equals(signAlg))) {
                throw new CodeException("16", "not support signature algorithm" + signAlg);
            }
            SignatureUtil2 signatureUtil2 = new SignatureUtil2();
            byte[] sourceData = SignatureKit.base64Decode(base64SourceData);
            boolean result = signatureUtil2.p1VerifyMessage(signAlg, sourceData, signatureData = SignatureKit.base64Decode(base64P1SignatureData), publicKey = (x509Cert = new X509Cert(x509CertData = SignatureKit.base64Decode(base64X509CertData))).getPublicKey(), session);
            if (result) {
                String jsonObject = SignatureKit.successToJson("Result", "True");
                SignatureKit.debugLog("01", "02", jsonObject);
                return jsonObject;
            }
            String jsonObject = SignatureKit.successToJson("Result", "False");
            SignatureKit.debugLog("01", "02", jsonObject);
            return jsonObject;
        }
        catch (Throwable e) {
            return SignatureKit.exceptionToJson("01", "02", e);
        }
    }
}

