/*
 * Decompiled with CFR 0.152.
 */
package cfca.internal.tool;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.asn1.ASN1Object;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.DEROutputStream;
import cfca.sm2rsa.common.PKIException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ASN1Parser {
    private static final byte[] b64Code = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47, 61, 13, 10, 32};

    public static byte[] writeDERObj2Bytes(ASN1Encodable obj) throws PKIException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        try {
            dos.writeObject(obj);
            return bos.toByteArray();
        }
        catch (Exception ex) {
            throw new PKIException("850306", "\u83b7\u53d6DER\u5bf9\u8c61byte\u7f16\u7801\u5931\u8d25", ex);
        }
    }

    public static ASN1Object writeBytes2DERObj(byte[] data) throws PKIException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ASN1InputStream dis = new ASN1InputStream(bis);
        ASN1Primitive derObj = null;
        try {
            ASN1Primitive aSN1Primitive = derObj = dis.readObject();
            return aSN1Primitive;
        }
        catch (Exception ex) {
            throw new PKIException("850307", "\u4f7f\u7528byte\u6784\u9020DER\u5bf9\u8c61\u5931\u8d25", ex);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public static boolean isBase64Encode(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean include = false;
            for (int j = 0; j < b64Code.length; ++j) {
                if (data[i] != b64Code[j]) continue;
                include = true;
                break;
            }
            if (include) continue;
            return false;
        }
        return true;
    }

    public static byte[] convertBase64(byte[] data) {
        if (ASN1Parser.isBase64Encode(data)) {
            byte tmp;
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((tmp = (byte)bis.read()) != -1) {
                if (tmp == 10 || tmp == 13) continue;
                bos.write(tmp);
            }
            return bos.toByteArray();
        }
        return data;
    }
}

