/*
 * Decompiled with CFR 0.152.
 */
package cfca.internal.tool;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;

public class HashEncoderUtil {
    public static byte[] derEncoder(String signAlg, byte[] hash) throws PKIException {
        try {
            AlgorithmIdentifier digestAlgIdentifier = null;
            if (signAlg.equals("MD5") || signAlg.equals("MD5withRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, (ASN1Encodable)new DERNull());
            } else if (signAlg.equals("SHA1") || signAlg.equals("SHA1withRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, (ASN1Encodable)new DERNull());
            } else if (signAlg.equals("SHA256") || signAlg.equals("SHA256withRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256, (ASN1Encodable)new DERNull());
            } else if (signAlg.equals("SHA512") || signAlg.equals("SHA512withRSA")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512, (ASN1Encodable)new DERNull());
            } else {
                if (signAlg.equals("SM3") || signAlg.equals("SM3withSM2")) {
                    return hash;
                }
                throw new PKIException("850202", "\u6587\u6458\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + signAlg);
            }
            DigestInfo dInfo = new DigestInfo(digestAlgIdentifier, hash);
            return dInfo.getEncoded("DER");
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }
}

