/*
 * Decompiled with CFR 0.152.
 */
package cfca.internal.tool;

import cfca.internal.tool.ASN1Parser;
import cfca.internal.tool.Mechanism_Inside;
import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.asn1.ASN1Integer;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.DERInteger;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.DEROutputStream;
import cfca.org.bouncycastle.asn1.DERSequence;
import cfca.org.bouncycastle.asn1.DERSet;
import cfca.org.bouncycastle.asn1.pkcs.Attribute;
import cfca.org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import cfca.org.bouncycastle.asn1.pkcs.CertBag;
import cfca.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.org.bouncycastle.asn1.pkcs.EncryptedData;
import cfca.org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import cfca.org.bouncycastle.asn1.pkcs.MacData;
import cfca.org.bouncycastle.asn1.pkcs.PBEParameter;
import cfca.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import cfca.org.bouncycastle.asn1.pkcs.Pfx;
import cfca.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cfca.org.bouncycastle.asn1.pkcs.SafeBag;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.Certificate;
import cfca.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.org.bouncycastle.crypto.CipherParameters;
import cfca.org.bouncycastle.crypto.ExtendedDigest;
import cfca.org.bouncycastle.crypto.digests.MD2Digest;
import cfca.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.org.bouncycastle.crypto.engines.RC2Engine;
import cfca.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import cfca.org.bouncycastle.crypto.macs.HMac;
import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import cfca.org.bouncycastle.util.Arrays;
import cfca.rsa.envelope.RSASymmetricCryptoUtil;
import cfca.rsa.signature.SafeContents;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cfca.system.SecureRandoms;
import cfca.util.Base64;
import cfca.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Vector;

public class PKCS12 {
    private Pfx pfx = null;
    private CertBag[] certBags = null;
    private ASN1Encodable privateKeyInfo = null;
    private ContentInfo keyContent = null;
    private ContentInfo certContent = null;
    private byte[] password = null;
    private boolean decrypted = false;
    private static final int ITERATIONS = 2000;

    public void load(Pfx _pfx) {
        this.pfx = _pfx;
    }

    public void load(String fileName) throws PKIException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(fileName);
            byte[] data = new byte[fin.available()];
            fin.read(data);
            this.load(data);
        }
        catch (Exception ex) {
            throw new PKIException("850605", "\u8f7d\u5165P12\u5bf9\u8c61\u9519\u8bef", ex);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void load(InputStream ins) throws PKIException {
        ASN1InputStream ais = null;
        try {
            ais = new ASN1InputStream(ins);
            this.pfx = Pfx.getInstance(ais.readObject());
        }
        catch (Exception ex) {
            throw new PKIException("850605", "\u8f7d\u5165P12\u5bf9\u8c61\u9519\u8bef", ex);
        }
        finally {
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void load(byte[] data) throws PKIException {
        boolean isB64 = ASN1Parser.isBase64Encode(data);
        if (isB64) {
            data = ASN1Parser.convertBase64(data);
            data = Base64.decode(data);
        }
        ByteArrayInputStream bis = null;
        FilterInputStream ais = null;
        try {
            bis = new ByteArrayInputStream(data);
            ais = new ASN1InputStream(bis);
            this.pfx = Pfx.getInstance(((ASN1InputStream)ais).readObject());
        }
        catch (Exception ex) {
            throw new PKIException("850605", "\u8f7d\u5165P12\u5bf9\u8c61\u9519\u8bef", ex);
        }
        finally {
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (Exception e) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ASN1Sequence oct2Seq(ASN1OctetString oct) throws Exception {
        byte[] b = oct.getOctets();
        ByteArrayInputStream bis = null;
        FilterInputStream ais = null;
        try {
            bis = new ByteArrayInputStream(b);
            ais = new ASN1InputStream(bis);
            ASN1Sequence aSN1Sequence = (ASN1Sequence)((ASN1InputStream)ais).readObject();
            return aSN1Sequence;
        }
        finally {
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (Exception e) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void decrypt(char[] _password) throws PKIException {
        try {
            if (this.pfx == null) {
                throw new Exception("you must load Pfx first.");
            }
            this.password = PKCS12ParametersGenerator.PKCS12PasswordToBytes(_password);
            if (!this.verifyMac()) {
                throw new Exception("verifyMac faulture.");
            }
            ContentInfo authSafe = this.pfx.getAuthSafe();
            ASN1OctetString octetString = ASN1OctetString.getInstance(authSafe.getContent());
            ASN1Sequence sequence = this.oct2Seq(octetString);
            AuthenticatedSafe authenticatedSafe = AuthenticatedSafe.getInstance(sequence);
            ContentInfo[] contentInfo = authenticatedSafe.getContentInfo();
            for (int i = 0; i < contentInfo.length; ++i) {
                if (contentInfo[i].getContentType().equals(PKCSObjectIdentifiers.data)) {
                    this.keyContent = contentInfo[i];
                    continue;
                }
                if (!contentInfo[i].getContentType().equals(PKCSObjectIdentifiers.encryptedData)) continue;
                this.certContent = contentInfo[i];
            }
            this.handleKeyContent(this.keyContent);
            this.handleCertContent(this.certContent);
            this.decrypted = true;
        }
        catch (Exception ex) {
            throw new PKIException("850606", "\u89e3\u6790P12\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u89e3\u5bc6\u53e3\u4ee4", ex);
        }
    }

    private byte[] pbeDecrypt(String algName, PKCS12ParametersGenerator p12gen, byte[] en_data) throws Exception {
        CipherParameters param = null;
        Mechanism_Inside mechanism = null;
        ParametersWithIV ivParam = null;
        KeyParameter keyParam = null;
        if (algName.equals(PKCSObjectIdentifiers.pbeWithSHAAnd3DESCBC.getId())) {
            param = p12gen.generateDerivedParameters(192, 64);
            ivParam = (ParametersWithIV)param;
            byte[] iv = ivParam.getIV();
            keyParam = (KeyParameter)ivParam.getParameters();
            byte[] keyData = keyParam.getKey();
            CBCParam cbcParam = new CBCParam(iv);
            mechanism = new Mechanism_Inside("DESede/CBC/PKCS7Padding", cbcParam);
            return RSASymmetricCryptoUtil.decrypt(keyData, en_data, mechanism);
        }
        if (algName.equals(PKCSObjectIdentifiers.pbeWithSHAAnd2DESCBC.getId())) {
            param = p12gen.generateDerivedParameters(128, 64);
            ivParam = (ParametersWithIV)param;
            byte[] iv = ivParam.getIV();
            keyParam = (KeyParameter)ivParam.getParameters();
            byte[] keyData = keyParam.getKey();
            CBCParam cbcParam = new CBCParam(iv);
            mechanism = new Mechanism_Inside("DESede/CBC/PKCS7Padding", cbcParam);
            return RSASymmetricCryptoUtil.decrypt(keyData, en_data, mechanism);
        }
        if (algName.equals(PKCSObjectIdentifiers.pbeWithSHAAnd128RC2CBC.getId())) {
            param = p12gen.generateDerivedParameters(128, 64);
            return PKCS12.rc2doCipher(false, param, en_data);
        }
        if (algName.equals(PKCSObjectIdentifiers.pbeWithSHAAnd40RC2CBC.getId())) {
            param = p12gen.generateDerivedParameters(40, 64);
            return PKCS12.rc2doCipher(false, param, en_data);
        }
        throw new Exception("not support pkcs12pbe algorithm: " + algName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCertContent(ContentInfo certContent) throws Exception {
        EncryptedData encryptedData = EncryptedData.getInstance(certContent.getContent());
        AlgorithmIdentifier aid = encryptedData.getEncryptionAlgorithm();
        PKCS12PBEParams pm = PKCS12PBEParams.getInstance(aid.getParameters());
        byte[] salt = pm.getIV();
        int iterations = pm.getIterations().intValue();
        PKCS12ParametersGenerator p12gen = new PKCS12ParametersGenerator(new SHA1Digest());
        p12gen.init(this.password, salt, iterations);
        ASN1OctetString octetString = encryptedData.getContent();
        byte[] en_data = octetString.getOctets();
        byte[] de_data = this.pbeDecrypt(aid.getAlgorithm().getId(), p12gen, en_data);
        ByteArrayInputStream bis = new ByteArrayInputStream(de_data);
        ASN1InputStream ais = new ASN1InputStream(bis);
        try {
            SafeContents safeContents = SafeContents.getInstance((ASN1Sequence)ais.readObject());
            SafeBag[] safeBag = safeContents.getSafeBag();
            Vector<CertBag> v = new Vector<CertBag>();
            for (int i = 0; i < safeBag.length; ++i) {
                if (!safeBag[i].getBagId().equals(PKCSObjectIdentifiers.certBag)) continue;
                CertBag cb = CertBag.getInstance(safeBag[i].getBagValue());
                v.add(cb);
            }
            this.certBags = new CertBag[v.size()];
            v.toArray(this.certBags);
        }
        finally {
            if (ais != null) {
                ais.close();
            }
        }
    }

    private void handleKeyContent(ContentInfo keyContent) throws Exception {
        ASN1OctetString octetString = ASN1OctetString.getInstance(keyContent.getContent());
        ASN1Sequence sequence = this.oct2Seq(octetString);
        SafeContents safeContents = SafeContents.getInstance(sequence);
        SafeBag[] safeBag = safeContents.getSafeBag();
        SafeBag keyBag = safeBag[0];
        if (keyBag.getBagId().equals(PKCSObjectIdentifiers.keyBag)) {
            this.privateKeyInfo = new PrivateKeyInfo((ASN1Sequence)keyBag.getBagValue());
        } else if (keyBag.getBagId().equals(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
            EncryptedPrivateKeyInfo epki = EncryptedPrivateKeyInfo.getInstance(ASN1Parser.writeDERObj2Bytes(keyBag.getBagValue()));
            PBEParameter pbeParamSpec = PBEParameter.getInstance(epki.getEncryptionAlgorithm().getParameters());
            byte[] salt = pbeParamSpec.getSalt();
            int iterations = pbeParamSpec.getIterationCount().intValue();
            PKCS12ParametersGenerator p12gen = new PKCS12ParametersGenerator(new SHA1Digest());
            p12gen.init(this.password, salt, iterations);
            byte[] en_data = epki.getEncryptedData();
            byte[] de_data = this.pbeDecrypt(epki.getEncryptionAlgorithm().getAlgorithm().getId(), p12gen, en_data);
            ByteArrayInputStream bis = new ByteArrayInputStream(de_data);
            ASN1InputStream ais = new ASN1InputStream(bis);
            this.privateKeyInfo = (ASN1Sequence)ais.readObject();
            ais.close();
        } else {
            throw new Exception("handle keyBag error. bagId = " + keyBag.getBagId().getId());
        }
    }

    public static void generatePfxFile(X509Cert x509cert, PrivateKey priKey, String passWord, String fileName) throws PKIException {
        Pfx pfx = PKCS12.generatePfx(x509cert, priKey, passWord);
        FileOutputStream fos = null;
        ASN1OutputStream dos = null;
        try {
            fos = new FileOutputStream(fileName);
            dos = new DEROutputStream(fos);
            ((DEROutputStream)dos).writeObject(pfx);
        }
        catch (Exception e) {
            throw new PKIException("can not create pfx file: " + e.getMessage());
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static Pfx generatePfx(X509Cert x509cert, PrivateKey priKey, String passWord) throws PKIException {
        Certificate cert = x509cert.getCertStructure();
        byte[] password = PKCS12ParametersGenerator.PKCS12PasswordToBytes(passWord.toCharArray());
        try {
            ContentInfo certContent;
            EncryptedPrivateKeyInfo epki = PKCS12.generateEPKI(priKey, password);
            ASN1Integer dint = cert.getSerialNumber();
            byte[] sn = ASN1Parser.writeDERObj2Bytes(dint);
            DEROctetString osn = new DEROctetString(sn);
            ASN1EncodableVector derV = new ASN1EncodableVector();
            derV.add(osn);
            DERSet derSet = new DERSet(derV);
            Attribute attribute = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, derSet);
            derV = new ASN1EncodableVector();
            derV.add(attribute);
            derSet = new DERSet(derV);
            SafeBag keyBag = new SafeBag(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag, ASN1Parser.writeBytes2DERObj(epki.getEncoded()), derSet);
            SafeBag[] keyBags = new SafeBag[]{keyBag};
            SafeContents safeContents = new SafeContents(keyBags);
            DEROctetString octString = new DEROctetString(ASN1Parser.writeDERObj2Bytes(safeContents));
            ContentInfo keyContent = new ContentInfo(PKCSObjectIdentifiers.data, octString);
            ContentInfo[] contentInfos = new ContentInfo[2];
            contentInfos[0] = keyContent;
            octString = new DEROctetString(ASN1Parser.writeDERObj2Bytes(cert));
            CertBag certBag = new CertBag(PKCSObjectIdentifiers.x509certType, octString);
            SafeBag sbag = new SafeBag(PKCSObjectIdentifiers.certBag, certBag, derSet);
            SafeBag[] certBags = new SafeBag[]{sbag};
            safeContents = new SafeContents(certBags);
            EncryptedData encryptedData = PKCS12.encryptedCertContents(safeContents, password);
            contentInfos[1] = certContent = new ContentInfo(PKCSObjectIdentifiers.encryptedData, encryptedData);
            AuthenticatedSafe authenticatedSafe = new AuthenticatedSafe(contentInfos);
            octString = new DEROctetString(ASN1Parser.writeDERObj2Bytes(authenticatedSafe));
            ContentInfo authSafe = new ContentInfo(PKCSObjectIdentifiers.data, octString);
            MacData macData = PKCS12.generateMacData(authSafe, password);
            return new Pfx(authSafe, macData);
        }
        catch (Exception ex) {
            throw new PKIException("850609", "\u4ea7\u751fPKCS12\u7ed3\u6784\u5931\u8d25", ex);
        }
    }

    private static EncryptedPrivateKeyInfo generateEPKI(PrivateKey prvKey, byte[] password) throws Exception {
        byte[] keyData = prvKey.getEncoded();
        byte[] salt = SecureRandoms.getInstance().genBytes(8);
        PKCS12ParametersGenerator p12gen = new PKCS12ParametersGenerator(new SHA1Digest());
        p12gen.init(password, salt, 2000);
        CipherParameters param = p12gen.generateDerivedParameters(192, 64);
        ParametersWithIV ivParam = (ParametersWithIV)param;
        byte[] iv = ivParam.getIV();
        KeyParameter keyParam = (KeyParameter)ivParam.getParameters();
        byte[] encryptKeyData = keyParam.getKey();
        CBCParam cbcParam = new CBCParam(iv);
        Mechanism_Inside mechanism = new Mechanism_Inside("DESede/CBC/PKCS7Padding", cbcParam);
        byte[] en_data = RSASymmetricCryptoUtil.encrypt(encryptKeyData, keyData, mechanism);
        DEROctetString deS = new DEROctetString(en_data);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        DEROctetString de0 = new DEROctetString(salt);
        DERInteger deI = new DERInteger(2000);
        vector.add(de0);
        vector.add(deI);
        DERSequence deSeq = new DERSequence(vector);
        AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.pbeWithSHAAnd3DESCBC, (ASN1Encodable)deSeq);
        vector = new ASN1EncodableVector();
        vector.add(algId);
        vector.add(deS);
        deSeq = new DERSequence(vector);
        return EncryptedPrivateKeyInfo.getInstance(deSeq);
    }

    private static EncryptedData encryptedCertContents(ASN1Encodable safeContents, byte[] password) throws Exception {
        byte[] salt = SecureRandoms.getInstance().genBytes(8);
        PKCS12ParametersGenerator p12gen = new PKCS12ParametersGenerator(new SHA1Digest());
        p12gen.init(password, salt, 2000);
        CipherParameters param = p12gen.generateDerivedParameters(40, 64);
        byte[] en_data = PKCS12.rc2doCipher(true, param, ASN1Parser.writeDERObj2Bytes(safeContents));
        DEROctetString octString = new DEROctetString(en_data);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        DEROctetString de0 = new DEROctetString(salt);
        DERInteger deI = new DERInteger(2000);
        vector.add(de0);
        vector.add(deI);
        DERSequence deSeq = new DERSequence(vector);
        AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.pbeWithSHAAnd40RC2CBC, (ASN1Encodable)deSeq);
        return new EncryptedData(PKCSObjectIdentifiers.data, algId, octString);
    }

    private static byte[] rc2doCipher(boolean isEncrypt, CipherParameters param, byte[] data) throws Exception {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new RC2Engine()));
        cipher.init(isEncrypt, param);
        byte[] out = new byte[cipher.getOutputSize(data.length)];
        int res = cipher.processBytes(data, 0, data.length, out, 0);
        int validLen = -1;
        if (res < out.length) {
            validLen = cipher.doFinal(out, res);
        }
        if (isEncrypt) {
            return out;
        }
        byte[] d = new byte[out.length - cipher.getBlockSize() + validLen];
        System.arraycopy(out, 0, d, 0, d.length);
        return d;
    }

    private boolean verifyMac() throws PKIException {
        MacData macData = this.pfx.getMacData();
        DigestInfo digestInfo = macData.getMac();
        ASN1ObjectIdentifier oid = digestInfo.getAlgorithmId().getAlgorithm();
        PKCS12ParametersGenerator p12gen = null;
        int keyLen = 0;
        ExtendedDigest digest = null;
        if (oid.equals(PKCSObjectIdentifiers.sha1)) {
            p12gen = new PKCS12ParametersGenerator(new SHA1Digest());
            keyLen = 160;
            digest = new SHA1Digest();
        } else if (oid.equals(PKCSObjectIdentifiers.md2)) {
            p12gen = new PKCS12ParametersGenerator(new MD2Digest());
            keyLen = 128;
            digest = new MD2Digest();
        } else if (oid.equals(PKCSObjectIdentifiers.md5)) {
            p12gen = new PKCS12ParametersGenerator(new MD5Digest());
            keyLen = 128;
            digest = new MD5Digest();
        } else {
            throw new PKIException("not support digest algorithmIdentifier:" + oid);
        }
        byte[] salt = macData.getSalt();
        int iterations = macData.getIterationCount().intValue();
        p12gen.init(this.password, salt, iterations);
        CipherParameters param = p12gen.generateDerivedMacParameters(keyLen);
        KeyParameter keyParam = (KeyParameter)param;
        ASN1OctetString oct = ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent());
        byte[] content = oct.getOctets();
        HMac hmac = new HMac(digest);
        hmac.init(keyParam);
        hmac.update(content, 0, content.length);
        byte[] my_digest = new byte[hmac.getMacSize()];
        hmac.doFinal(my_digest, 0);
        byte[] digest_ori = digestInfo.getDigest();
        return Arrays.areEqual(my_digest, digest_ori);
    }

    private static MacData generateMacData(ContentInfo authSafe, byte[] password) throws Exception {
        byte[] salt = SecureRandoms.getInstance().genBytes(8);
        PKCS12ParametersGenerator p12gen = new PKCS12ParametersGenerator(new SHA1Digest());
        p12gen.init(password, salt, 2000);
        CipherParameters param = p12gen.generateDerivedMacParameters(160);
        ASN1OctetString oct = ASN1OctetString.getInstance(authSafe.getContent());
        byte[] da = oct.getOctets();
        HMac mac = new HMac(new SHA1Digest());
        mac.init(param);
        mac.update(da, 0, da.length);
        byte[] hmac = new byte[mac.getMacSize()];
        mac.doFinal(hmac, 0);
        DigestInfo digestInfo = new DigestInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1), hmac);
        return new MacData(digestInfo, salt, 2000);
    }

    public X509Cert[] getCerts() throws PKIException {
        try {
            if (!this.decrypted) {
                throw new Exception("pfx file hasn't been decrypted yet.");
            }
            ASN1OctetString oct = null;
            ASN1Sequence seq = null;
            Vector<X509Cert> v = new Vector<X509Cert>();
            for (int i = 0; i < this.certBags.length; ++i) {
                ASN1ObjectIdentifier certId = this.certBags[i].getCertId();
                if (certId.equals(PKCSObjectIdentifiers.x509certType)) {
                    oct = ASN1OctetString.getInstance(this.certBags[i].getCertValue());
                    seq = this.oct2Seq(oct);
                    Certificate certStruc = Certificate.getInstance(seq);
                    X509Cert cert = new X509Cert(certStruc);
                    v.add(cert);
                    continue;
                }
                if (certId.equals(PKCSObjectIdentifiers.sdsiCertType)) continue;
                throw new Exception("not support certBag type, id=" + certId.getId());
            }
            X509Cert[] certs = new X509Cert[v.size()];
            v.toArray(certs);
            return certs;
        }
        catch (Exception ex) {
            throw new PKIException("850608", "\u83b7\u53d6P12\u516c\u94a5\u8bc1\u4e66\u5931\u8d25", ex);
        }
    }

    public PrivateKey getPrivateKey() throws PKIException {
        try {
            if (!this.decrypted) {
                throw new Exception("pfx file hasn't been decrypted yet.");
            }
            ASN1Sequence s = (ASN1Sequence)this.privateKeyInfo;
            byte[] keyData = null;
            keyData = ASN1Parser.writeDERObj2Bytes(s);
            PKCS8EncodedKeySpec p8KeySpec = new PKCS8EncodedKeySpec(keyData);
            PrivateKeyInfo info = PrivateKeyInfo.getInstance(p8KeySpec.getEncoded());
            return new BCRSAPrivateCrtKey(info);
        }
        catch (Exception ex) {
            throw new PKIException("850607", "\u83b7\u53d6P12\u79c1\u94a5\u5931\u8d25", ex);
        }
    }
}

