/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.asn1.eac;

import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.asn1.ASN1Object;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.DERApplicationSpecific;
import cfca.org.bouncycastle.asn1.eac.BidirectionalMap;
import cfca.org.bouncycastle.asn1.eac.EACObjectIdentifiers;
import cfca.org.bouncycastle.asn1.eac.EACTags;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Hashtable;

public class CertificateHolderAuthorization
extends ASN1Object {
    ASN1ObjectIdentifier oid;
    DERApplicationSpecific accessRights;
    public static final ASN1ObjectIdentifier id_role_EAC = EACObjectIdentifiers.bsi_de.branch("3.1.2.1");
    public static final int CVCA = 192;
    public static final int DV_DOMESTIC = 128;
    public static final int DV_FOREIGN = 64;
    public static final int IS = 0;
    public static final int RADG4 = 2;
    public static final int RADG3 = 1;
    static Hashtable RightsDecodeMap = new Hashtable();
    static BidirectionalMap AuthorizationRole = new BidirectionalMap();
    static Hashtable ReverseMap = new Hashtable();

    public static String GetRoleDescription(int i) {
        return (String)AuthorizationRole.get(new Integer(i));
    }

    public static int GetFlag(String description) {
        Integer i = (Integer)AuthorizationRole.getReverse(description);
        if (i == null) {
            throw new InvalidParameterException("Unknown value " + description);
        }
        return i;
    }

    private void setPrivateData(ASN1InputStream cha) throws IOException {
        ASN1Primitive obj = cha.readObject();
        if (!(obj instanceof ASN1ObjectIdentifier)) {
            throw new IllegalArgumentException("no Oid in CerticateHolderAuthorization");
        }
        this.oid = (ASN1ObjectIdentifier)obj;
        obj = cha.readObject();
        if (!(obj instanceof DERApplicationSpecific)) {
            throw new IllegalArgumentException("No access rights in CerticateHolderAuthorization");
        }
        this.accessRights = (DERApplicationSpecific)obj;
    }

    public CertificateHolderAuthorization(ASN1ObjectIdentifier oid, int rights) throws IOException {
        this.setOid(oid);
        this.setAccessRights((byte)rights);
    }

    public CertificateHolderAuthorization(DERApplicationSpecific aSpe) throws IOException {
        if (aSpe.getApplicationTag() == 76) {
            this.setPrivateData(new ASN1InputStream(aSpe.getContents()));
        }
    }

    public int getAccessRights() {
        return this.accessRights.getContents()[0] & 0xFF;
    }

    private void setAccessRights(byte rights) {
        byte[] accessRights = new byte[]{rights};
        this.accessRights = new DERApplicationSpecific(EACTags.getTag(83), accessRights);
    }

    public ASN1ObjectIdentifier getOid() {
        return this.oid;
    }

    private void setOid(ASN1ObjectIdentifier oid) {
        this.oid = oid;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.oid);
        v.add(this.accessRights);
        return new DERApplicationSpecific(76, v);
    }

    static {
        RightsDecodeMap.put(new Integer(2), "RADG4");
        RightsDecodeMap.put(new Integer(1), "RADG3");
        AuthorizationRole.put(new Integer(192), "CVCA");
        AuthorizationRole.put(new Integer(128), "DV_DOMESTIC");
        AuthorizationRole.put(new Integer(64), "DV_FOREIGN");
        AuthorizationRole.put(new Integer(0), "IS");
    }
}

