/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.asn1.esf;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1Object;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.DERSequence;
import cfca.org.bouncycastle.asn1.x509.DisplayText;
import cfca.org.bouncycastle.asn1.x509.NoticeReference;
import java.util.Enumeration;

public class SPUserNotice
extends ASN1Object {
    private NoticeReference noticeRef;
    private DisplayText explicitText;

    public static SPUserNotice getInstance(Object obj) {
        if (obj instanceof SPUserNotice) {
            return (SPUserNotice)obj;
        }
        if (obj != null) {
            return new SPUserNotice(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private SPUserNotice(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Encodable object = (ASN1Encodable)e.nextElement();
            if (object instanceof NoticeReference) {
                this.noticeRef = NoticeReference.getInstance(object);
                continue;
            }
            if (object instanceof DisplayText) {
                this.explicitText = DisplayText.getInstance(object);
                continue;
            }
            throw new IllegalArgumentException("Invalid element in 'SPUserNotice'.");
        }
    }

    public SPUserNotice(NoticeReference noticeRef, DisplayText explicitText) {
        this.noticeRef = noticeRef;
        this.explicitText = explicitText;
    }

    public NoticeReference getNoticeRef() {
        return this.noticeRef;
    }

    public DisplayText getExplicitText() {
        return this.explicitText;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.noticeRef != null) {
            v.add(this.noticeRef);
        }
        if (this.explicitText != null) {
            v.add(this.explicitText);
        }
        return new DERSequence(v);
    }
}

