/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.cms.KEKIdentifier;
import cfca.org.bouncycastle.asn1.cms.OriginatorInfo;
import cfca.org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import cfca.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cfca.org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import cfca.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cfca.org.bouncycastle.cms.CMSAttributeTableGenerator;
import cfca.org.bouncycastle.cms.CMSPBEKey;
import cfca.org.bouncycastle.cms.CMSUtils;
import cfca.org.bouncycastle.cms.KEKRecipientInfoGenerator;
import cfca.org.bouncycastle.cms.OriginatorInformation;
import cfca.org.bouncycastle.cms.PKCS5Scheme2UTF8PBEKey;
import cfca.org.bouncycastle.cms.PasswordRecipientInfoGenerator;
import cfca.org.bouncycastle.cms.RecipientInfoGenerator;
import cfca.org.bouncycastle.cms.jcajce.JceKEKRecipientInfoGenerator;
import cfca.org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientInfoGenerator;
import cfca.org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import cfca.org.bouncycastle.cms.jcajce.JcePasswordRecipientInfoGenerator;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;

public class CMSEnvelopedGenerator {
    public static final String DES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String RC2_CBC = PKCSObjectIdentifiers.RC2_CBC.getId();
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    public static final String CAMELLIA128_CBC = NTTObjectIdentifiers.id_camellia128_cbc.getId();
    public static final String CAMELLIA192_CBC = NTTObjectIdentifiers.id_camellia192_cbc.getId();
    public static final String CAMELLIA256_CBC = NTTObjectIdentifiers.id_camellia256_cbc.getId();
    public static final String SEED_CBC = KISAObjectIdentifiers.id_seedCBC.getId();
    public static final String DES_EDE3_WRAP = PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId();
    public static final String AES128_WRAP = NISTObjectIdentifiers.id_aes128_wrap.getId();
    public static final String AES192_WRAP = NISTObjectIdentifiers.id_aes192_wrap.getId();
    public static final String AES256_WRAP = NISTObjectIdentifiers.id_aes256_wrap.getId();
    public static final String CAMELLIA128_WRAP = NTTObjectIdentifiers.id_camellia128_wrap.getId();
    public static final String CAMELLIA192_WRAP = NTTObjectIdentifiers.id_camellia192_wrap.getId();
    public static final String CAMELLIA256_WRAP = NTTObjectIdentifiers.id_camellia256_wrap.getId();
    public static final String SEED_WRAP = KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId();
    public static final String ECDH_SHA1KDF = X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme.getId();
    public static final String ECMQV_SHA1KDF = X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme.getId();
    final List oldRecipientInfoGenerators = new ArrayList();
    final List recipientInfoGenerators = new ArrayList();
    protected CMSAttributeTableGenerator unprotectedAttributeGenerator = null;
    final SecureRandom rand;
    protected OriginatorInfo originatorInfo;

    public CMSEnvelopedGenerator() {
        this(new SecureRandom());
    }

    public CMSEnvelopedGenerator(SecureRandom rand) {
        this.rand = rand;
    }

    public void setUnprotectedAttributeGenerator(CMSAttributeTableGenerator unprotectedAttributeGenerator) {
        this.unprotectedAttributeGenerator = unprotectedAttributeGenerator;
    }

    public void setOriginatorInfo(OriginatorInformation originatorInfo) {
        this.originatorInfo = originatorInfo.toASN1Structure();
    }

    public void addKeyTransRecipient(X509Certificate cert) throws IllegalArgumentException {
        try {
            this.oldRecipientInfoGenerators.add(new JceKeyTransRecipientInfoGenerator(cert));
        }
        catch (CertificateEncodingException e) {
            throw new IllegalArgumentException("unable to encode certificate: " + e.getMessage());
        }
    }

    public void addKeyTransRecipient(PublicKey key, byte[] subKeyId) throws IllegalArgumentException {
        this.oldRecipientInfoGenerators.add(new JceKeyTransRecipientInfoGenerator(subKeyId, key));
    }

    public void addKEKRecipient(SecretKey key, byte[] keyIdentifier) {
        this.addKEKRecipient(key, new KEKIdentifier(keyIdentifier, null, null));
    }

    public void addKEKRecipient(SecretKey key, KEKIdentifier kekIdentifier) {
        this.oldRecipientInfoGenerators.add(new JceKEKRecipientInfoGenerator(kekIdentifier, key));
    }

    public void addPasswordRecipient(CMSPBEKey pbeKey, String kekAlgorithmOid) {
        this.oldRecipientInfoGenerators.add(new JcePasswordRecipientInfoGenerator(new ASN1ObjectIdentifier(kekAlgorithmOid), pbeKey.getPassword()).setSaltAndIterationCount(pbeKey.getSalt(), pbeKey.getIterationCount()).setPasswordConversionScheme(pbeKey instanceof PKCS5Scheme2UTF8PBEKey ? 1 : 0));
    }

    public void addKeyAgreementRecipient(String agreementAlgorithm, PrivateKey senderPrivateKey, PublicKey senderPublicKey, X509Certificate recipientCert, String cekWrapAlgorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipient(agreementAlgorithm, senderPrivateKey, senderPublicKey, recipientCert, cekWrapAlgorithm, CMSUtils.getProvider(provider));
    }

    public void addKeyAgreementRecipient(String agreementAlgorithm, PrivateKey senderPrivateKey, PublicKey senderPublicKey, X509Certificate recipientCert, String cekWrapAlgorithm, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        ArrayList<X509Certificate> recipients = new ArrayList<X509Certificate>();
        recipients.add(recipientCert);
        this.addKeyAgreementRecipients(agreementAlgorithm, senderPrivateKey, senderPublicKey, recipients, cekWrapAlgorithm, provider);
    }

    public void addKeyAgreementRecipients(String agreementAlgorithm, PrivateKey senderPrivateKey, PublicKey senderPublicKey, Collection recipientCerts, String cekWrapAlgorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.addKeyAgreementRecipients(agreementAlgorithm, senderPrivateKey, senderPublicKey, recipientCerts, cekWrapAlgorithm, CMSUtils.getProvider(provider));
    }

    public void addKeyAgreementRecipients(String agreementAlgorithm, PrivateKey senderPrivateKey, PublicKey senderPublicKey, Collection recipientCerts, String cekWrapAlgorithm, Provider provider) throws NoSuchAlgorithmException, InvalidKeyException {
        JceKeyAgreeRecipientInfoGenerator recipientInfoGenerator = new JceKeyAgreeRecipientInfoGenerator(new ASN1ObjectIdentifier(agreementAlgorithm), senderPrivateKey, senderPublicKey, new ASN1ObjectIdentifier(cekWrapAlgorithm)).setProvider(provider);
        Iterator it = recipientCerts.iterator();
        while (it.hasNext()) {
            try {
                recipientInfoGenerator.addRecipient((X509Certificate)it.next());
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("unable to encode certificate: " + e.getMessage());
            }
        }
        this.oldRecipientInfoGenerators.add(recipientInfoGenerator);
    }

    public void addRecipientInfoGenerator(RecipientInfoGenerator recipientGenerator) {
        this.recipientInfoGenerators.add(recipientGenerator);
    }

    protected AlgorithmIdentifier getAlgorithmIdentifier(String encryptionOID, AlgorithmParameters params) throws IOException {
        ASN1Primitive asn1Params = params != null ? ASN1Primitive.fromByteArray(params.getEncoded("ASN.1")) : DERNull.INSTANCE;
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(encryptionOID), (ASN1Encodable)asn1Params);
    }

    protected void convertOldRecipients(SecureRandom rand, Provider provider) {
        Iterator it = this.oldRecipientInfoGenerators.iterator();
        while (it.hasNext()) {
            RecipientInfoGenerator recip;
            Object recipient = it.next();
            if (recipient instanceof JceKeyTransRecipientInfoGenerator) {
                recip = (JceKeyTransRecipientInfoGenerator)recipient;
                if (provider != null) {
                    ((JceKeyTransRecipientInfoGenerator)recip).setProvider(provider);
                }
                this.recipientInfoGenerators.add(recip);
                continue;
            }
            if (recipient instanceof KEKRecipientInfoGenerator) {
                recip = (JceKEKRecipientInfoGenerator)recipient;
                if (provider != null) {
                    ((JceKEKRecipientInfoGenerator)recip).setProvider(provider);
                }
                ((JceKEKRecipientInfoGenerator)recip).setSecureRandom(rand);
                this.recipientInfoGenerators.add(recip);
                continue;
            }
            if (recipient instanceof JcePasswordRecipientInfoGenerator) {
                recip = (JcePasswordRecipientInfoGenerator)recipient;
                if (provider != null) {
                    ((JcePasswordRecipientInfoGenerator)recip).setProvider(provider);
                }
                ((PasswordRecipientInfoGenerator)recip).setSecureRandom(rand);
                this.recipientInfoGenerators.add(recip);
                continue;
            }
            if (!(recipient instanceof JceKeyAgreeRecipientInfoGenerator)) continue;
            recip = (JceKeyAgreeRecipientInfoGenerator)recipient;
            if (provider != null) {
                ((JceKeyAgreeRecipientInfoGenerator)recip).setProvider(provider);
            }
            ((JceKeyAgreeRecipientInfoGenerator)recip).setSecureRandom(rand);
            this.recipientInfoGenerators.add(recip);
        }
        this.oldRecipientInfoGenerators.clear();
    }
}

