/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms;

import cfca.org.bouncycastle.asn1.cms.KEKIdentifier;
import cfca.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.cms.AuthAttributesProvider;
import cfca.org.bouncycastle.cms.CMSEnvelopedHelper;
import cfca.org.bouncycastle.cms.CMSException;
import cfca.org.bouncycastle.cms.CMSSecureReadable;
import cfca.org.bouncycastle.cms.CMSTypedStream;
import cfca.org.bouncycastle.cms.CMSUtils;
import cfca.org.bouncycastle.cms.KEKRecipient;
import cfca.org.bouncycastle.cms.KEKRecipientId;
import cfca.org.bouncycastle.cms.Recipient;
import cfca.org.bouncycastle.cms.RecipientInformation;
import cfca.org.bouncycastle.cms.RecipientOperator;
import cfca.org.bouncycastle.cms.jcajce.JceKEKAuthenticatedRecipient;
import cfca.org.bouncycastle.cms.jcajce.JceKEKEnvelopedRecipient;
import cfca.org.bouncycastle.cms.jcajce.JceKEKRecipient;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.SecretKey;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(prov));
    }

    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            JceKEKRecipient recipient = this.secureReadable instanceof CMSEnvelopedHelper.CMSEnvelopedSecureReadable ? new JceKEKEnvelopedRecipient((SecretKey)key) : new JceKEKAuthenticatedRecipient((SecretKey)key);
            if (prov != null) {
                recipient.setProvider(prov);
            }
            return this.getContentStream(recipient);
        }
        catch (IOException e) {
            throw new CMSException("encoding error: " + e.getMessage(), e);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

