/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms;

import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cfca.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.org.bouncycastle.asn1.cms.RecipientIdentifier;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.cms.AuthAttributesProvider;
import cfca.org.bouncycastle.cms.CMSEnvelopedHelper;
import cfca.org.bouncycastle.cms.CMSException;
import cfca.org.bouncycastle.cms.CMSSecureReadable;
import cfca.org.bouncycastle.cms.CMSTypedStream;
import cfca.org.bouncycastle.cms.CMSUtils;
import cfca.org.bouncycastle.cms.KeyTransRecipient;
import cfca.org.bouncycastle.cms.KeyTransRecipientId;
import cfca.org.bouncycastle.cms.Recipient;
import cfca.org.bouncycastle.cms.RecipientInformation;
import cfca.org.bouncycastle.cms.RecipientOperator;
import cfca.org.bouncycastle.cms.jcajce.JceKeyTransAuthenticatedRecipient;
import cfca.org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import cfca.org.bouncycastle.cms.jcajce.JceKeyTransRecipient;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        RecipientIdentifier r = info.getRecipientIdentifier();
        if (r.isTagged()) {
            ASN1OctetString octs = ASN1OctetString.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(octs.getOctets());
        } else {
            IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(r.getId());
            this.rid = new KeyTransRecipientId(iAnds.getName(), iAnds.getSerialNumber().getValue());
        }
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(prov));
    }

    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            JceKeyTransRecipient recipient = this.secureReadable instanceof CMSEnvelopedHelper.CMSEnvelopedSecureReadable ? new JceKeyTransEnvelopedRecipient((PrivateKey)key) : new JceKeyTransAuthenticatedRecipient((PrivateKey)key);
            if (prov != null) {
                recipient.setProvider(prov);
                if (prov.getName().equalsIgnoreCase("SunJCE")) {
                    recipient.setContentProvider((String)null);
                }
            }
            return this.getContentStream(recipient);
        }
        catch (IOException e) {
            throw new CMSException("encoding error: " + e.getMessage(), e);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

