/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.DERSequence;
import cfca.org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import cfca.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import cfca.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.cms.CMSException;
import cfca.org.bouncycastle.cms.PasswordRecipientInformation;
import cfca.org.bouncycastle.cms.RecipientInfoGenerator;
import cfca.org.bouncycastle.crypto.PBEParametersGenerator;
import cfca.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.operator.GenericKey;
import java.security.SecureRandom;

public abstract class PasswordRecipientInfoGenerator
implements RecipientInfoGenerator {
    private char[] password;
    private AlgorithmIdentifier keyDerivationAlgorithm;
    private ASN1ObjectIdentifier kekAlgorithm;
    private SecureRandom random;
    private int schemeID;
    private int keySize;
    private int blockSize;

    protected PasswordRecipientInfoGenerator(ASN1ObjectIdentifier kekAlgorithm, char[] password) {
        this(kekAlgorithm, password, PasswordRecipientInfoGenerator.getKeySize(kekAlgorithm), (Integer)PasswordRecipientInformation.BLOCKSIZES.get(kekAlgorithm));
    }

    protected PasswordRecipientInfoGenerator(ASN1ObjectIdentifier kekAlgorithm, char[] password, int keySize, int blockSize) {
        this.password = password;
        this.schemeID = 1;
        this.kekAlgorithm = kekAlgorithm;
        this.keySize = keySize;
        this.blockSize = blockSize;
    }

    private static int getKeySize(ASN1ObjectIdentifier kekAlgorithm) {
        Integer size = (Integer)PasswordRecipientInformation.KEYSIZES.get(kekAlgorithm);
        if (size == null) {
            throw new IllegalArgumentException("cannot find key size for algorithm: " + kekAlgorithm);
        }
        return size;
    }

    public PasswordRecipientInfoGenerator setPasswordConversionScheme(int schemeID) {
        this.schemeID = schemeID;
        return this;
    }

    public PasswordRecipientInfoGenerator setSaltAndIterationCount(byte[] salt, int iterationCount) {
        this.keyDerivationAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, (ASN1Encodable)new PBKDF2Params(salt, iterationCount));
        return this;
    }

    public PasswordRecipientInfoGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        byte[] derivedKey;
        PKCS5S2ParametersGenerator gen;
        byte[] iv = new byte[this.blockSize];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(iv);
        if (this.keyDerivationAlgorithm == null) {
            byte[] salt = new byte[20];
            this.random.nextBytes(salt);
            this.keyDerivationAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, (ASN1Encodable)new PBKDF2Params(salt, 1024));
        }
        PBKDF2Params params = PBKDF2Params.getInstance(this.keyDerivationAlgorithm.getParameters());
        if (this.schemeID == 0) {
            gen = new PKCS5S2ParametersGenerator();
            gen.init(PBEParametersGenerator.PKCS5PasswordToBytes(this.password), params.getSalt(), params.getIterationCount().intValue());
            derivedKey = ((KeyParameter)gen.generateDerivedParameters(this.keySize)).getKey();
        } else {
            gen = new PKCS5S2ParametersGenerator();
            gen.init(PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(this.password), params.getSalt(), params.getIterationCount().intValue());
            derivedKey = ((KeyParameter)gen.generateDerivedParameters(this.keySize)).getKey();
        }
        AlgorithmIdentifier kekAlgorithmId = new AlgorithmIdentifier(this.kekAlgorithm, (ASN1Encodable)new DEROctetString(iv));
        byte[] encryptedKeyBytes = this.generateEncryptedBytes(kekAlgorithmId, derivedKey, contentEncryptionKey);
        DEROctetString encryptedKey = new DEROctetString(encryptedKeyBytes);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.kekAlgorithm);
        v.add(new DEROctetString(iv));
        AlgorithmIdentifier keyEncryptionAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_PWRI_KEK, (ASN1Encodable)new DERSequence(v));
        return new RecipientInfo(new PasswordRecipientInfo(this.keyDerivationAlgorithm, keyEncryptionAlgorithm, encryptedKey));
    }

    protected abstract byte[] generateEncryptedBytes(AlgorithmIdentifier var1, byte[] var2, GenericKey var3) throws CMSException;
}

