/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.cms.jcajce;

import cfca.org.bouncycastle.cert.X509CertificateHolder;
import cfca.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import cfca.org.bouncycastle.cms.CMSAttributeTableGenerator;
import cfca.org.bouncycastle.cms.SignerInfoGenerator;
import cfca.org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import cfca.org.bouncycastle.operator.ContentSigner;
import cfca.org.bouncycastle.operator.DigestCalculatorProvider;
import cfca.org.bouncycastle.operator.OperatorCreationException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaSignerInfoGeneratorBuilder {
    private SignerInfoGeneratorBuilder builder;

    public JcaSignerInfoGeneratorBuilder(DigestCalculatorProvider digestProvider) {
        this.builder = new SignerInfoGeneratorBuilder(digestProvider);
    }

    public JcaSignerInfoGeneratorBuilder setDirectSignature(boolean hasNoSignedAttributes) {
        this.builder.setDirectSignature(hasNoSignedAttributes);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setSignedAttributeGenerator(CMSAttributeTableGenerator signedGen) {
        this.builder.setSignedAttributeGenerator(signedGen);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setUnsignedAttributeGenerator(CMSAttributeTableGenerator unsignedGen) {
        this.builder.setUnsignedAttributeGenerator(unsignedGen);
        return this;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509CertificateHolder certHolder) throws OperatorCreationException {
        return this.builder.build(contentSigner, certHolder);
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, byte[] keyIdentifier) throws OperatorCreationException {
        return this.builder.build(contentSigner, keyIdentifier);
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509Certificate certificate) throws OperatorCreationException, CertificateEncodingException {
        return this.build(contentSigner, new JcaX509CertificateHolder(certificate));
    }
}

