/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.crypto.tls;

import cfca.org.bouncycastle.crypto.CryptoException;
import cfca.org.bouncycastle.crypto.Signer;
import cfca.org.bouncycastle.crypto.digests.NullDigest;
import cfca.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import cfca.org.bouncycastle.crypto.engines.RSABlindedEngine;
import cfca.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithRandom;
import cfca.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.org.bouncycastle.crypto.signers.GenericSigner;
import cfca.org.bouncycastle.crypto.tls.CombinedHash;
import cfca.org.bouncycastle.crypto.tls.TlsSigner;
import java.security.SecureRandom;

class TlsRSASigner
implements TlsSigner {
    TlsRSASigner() {
    }

    public byte[] calculateRawSignature(SecureRandom random, AsymmetricKeyParameter privateKey, byte[] md5andsha1) throws CryptoException {
        GenericSigner sig = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), new NullDigest());
        sig.init(true, new ParametersWithRandom(privateKey, random));
        sig.update(md5andsha1, 0, md5andsha1.length);
        return sig.generateSignature();
    }

    public Signer createVerifyer(AsymmetricKeyParameter publicKey) {
        GenericSigner s = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), new CombinedHash());
        s.init(false, publicKey);
        return s;
    }

    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof RSAKeyParameters && !publicKey.isPrivate();
    }
}

