/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.jcajce.provider.asymmetric.ec;

import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.DERInteger;
import cfca.org.bouncycastle.asn1.DERSequence;
import cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.org.bouncycastle.crypto.DSA;
import cfca.org.bouncycastle.crypto.Digest;
import cfca.org.bouncycastle.crypto.digests.NullDigest;
import cfca.org.bouncycastle.crypto.digests.RIPEMD160Digest;
import cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.org.bouncycastle.crypto.digests.SHA224Digest;
import cfca.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.org.bouncycastle.crypto.digests.SHA384Digest;
import cfca.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithRandom;
import cfca.org.bouncycastle.crypto.signers.ECDSASigner;
import cfca.org.bouncycastle.crypto.signers.ECNRSigner;
import cfca.org.bouncycastle.jcajce.provider.asymmetric.ec.ECUtil;
import cfca.org.bouncycastle.jcajce.provider.asymmetric.util.DSABase;
import cfca.org.bouncycastle.jcajce.provider.asymmetric.util.DSAEncoder;
import cfca.org.bouncycastle.jce.interfaces.ECKey;
import cfca.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

public class SignatureSpi
extends DSABase {
    SignatureSpi(Digest digest, DSA signer, DSAEncoder encoder) {
        super("ECDSA", digest, signer, encoder);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter param;
        if (publicKey instanceof ECPublicKey) {
            param = ECUtil.generatePublicKeyParameter(publicKey);
        } else {
            try {
                byte[] bytes = publicKey.getEncoded();
                publicKey = BouncyCastleProvider.getPublicKey(SubjectPublicKeyInfo.getInstance(bytes));
                if (!(publicKey instanceof ECPublicKey)) {
                    throw new InvalidKeyException("can't recognise key type in ECDSA based signer");
                }
                param = ECUtil.generatePublicKeyParameter(publicKey);
            }
            catch (Exception e) {
                throw new InvalidKeyException("can't recognise key type in ECDSA based signer");
            }
        }
        this.digest.reset();
        this.signer.init(false, param);
    }

    protected void doEngineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        if (!(privateKey instanceof ECKey)) {
            throw new InvalidKeyException("can't recognise key type in ECDSA based signer");
        }
        AsymmetricKeyParameter param = ECUtil.generatePrivateKeyParameter(privateKey);
        this.digest.reset();
        if (random != null) {
            this.signer.init(true, new ParametersWithRandom(param, random));
        } else {
            this.signer.init(true, param);
        }
    }

    private static class CVCDSAEncoder
    implements DSAEncoder {
        private CVCDSAEncoder() {
        }

        public byte[] encode(BigInteger r, BigInteger s) throws IOException {
            byte[] second;
            byte[] first = this.makeUnsigned(r);
            byte[] res = first.length > (second = this.makeUnsigned(s)).length ? new byte[first.length * 2] : new byte[second.length * 2];
            System.arraycopy(first, 0, res, res.length / 2 - first.length, first.length);
            System.arraycopy(second, 0, res, res.length - second.length, second.length);
            return res;
        }

        private byte[] makeUnsigned(BigInteger val) {
            byte[] res = val.toByteArray();
            if (res[0] == 0) {
                byte[] tmp = new byte[res.length - 1];
                System.arraycopy(res, 1, tmp, 0, tmp.length);
                return tmp;
            }
            return res;
        }

        public BigInteger[] decode(byte[] encoding) throws IOException {
            BigInteger[] sig = new BigInteger[2];
            byte[] first = new byte[encoding.length / 2];
            byte[] second = new byte[encoding.length / 2];
            System.arraycopy(encoding, 0, first, 0, first.length);
            System.arraycopy(encoding, first.length, second, 0, second.length);
            sig[0] = new BigInteger(1, first);
            sig[1] = new BigInteger(1, second);
            return sig;
        }
    }

    private static class StdDSAEncoder
    implements DSAEncoder {
        private StdDSAEncoder() {
        }

        public byte[] encode(BigInteger r, BigInteger s) throws IOException {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new DERInteger(r));
            v.add(new DERInteger(s));
            return new DERSequence(v).getEncoded("DER");
        }

        public BigInteger[] decode(byte[] encoding) throws IOException {
            ASN1Sequence s = (ASN1Sequence)ASN1Primitive.fromByteArray(encoding);
            BigInteger[] sig = new BigInteger[]{((DERInteger)s.getObjectAt(0)).getValue(), ((DERInteger)s.getObjectAt(1)).getValue()};
            return sig;
        }
    }

    public static class ecCVCDSA256
    extends SignatureSpi {
        public ecCVCDSA256() {
            super(new SHA256Digest(), new ECDSASigner(), new CVCDSAEncoder());
        }
    }

    public static class ecCVCDSA224
    extends SignatureSpi {
        public ecCVCDSA224() {
            super(new SHA224Digest(), new ECDSASigner(), new CVCDSAEncoder());
        }
    }

    public static class ecCVCDSA
    extends SignatureSpi {
        public ecCVCDSA() {
            super(new SHA1Digest(), new ECDSASigner(), new CVCDSAEncoder());
        }
    }

    public static class ecNR512
    extends SignatureSpi {
        public ecNR512() {
            super(new SHA512Digest(), new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecNR384
    extends SignatureSpi {
        public ecNR384() {
            super(new SHA384Digest(), new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecNR256
    extends SignatureSpi {
        public ecNR256() {
            super(new SHA256Digest(), new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecNR224
    extends SignatureSpi {
        public ecNR224() {
            super(new SHA224Digest(), new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecNR
    extends SignatureSpi {
        public ecNR() {
            super(new SHA1Digest(), new ECNRSigner(), new StdDSAEncoder());
        }
    }

    public static class ecDSARipeMD160
    extends SignatureSpi {
        public ecDSARipeMD160() {
            super(new RIPEMD160Digest(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDSA512
    extends SignatureSpi {
        public ecDSA512() {
            super(new SHA512Digest(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDSA384
    extends SignatureSpi {
        public ecDSA384() {
            super(new SHA384Digest(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDSA256
    extends SignatureSpi {
        public ecDSA256() {
            super(new SHA256Digest(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDSA224
    extends SignatureSpi {
        public ecDSA224() {
            super(new SHA224Digest(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDSAnone
    extends SignatureSpi {
        public ecDSAnone() {
            super(new NullDigest(), new ECDSASigner(), new StdDSAEncoder());
        }
    }

    public static class ecDSA
    extends SignatureSpi {
        public ecDSA() {
            super(new SHA1Digest(), new ECDSASigner(), new StdDSAEncoder());
        }
    }
}

