/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.jcajce.provider.asymmetric.gost;

import cfca.org.bouncycastle.crypto.generators.GOST3410ParametersGenerator;
import cfca.org.bouncycastle.crypto.params.GOST3410Parameters;
import cfca.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import cfca.org.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public abstract class AlgorithmParameterGeneratorSpi
extends java.security.AlgorithmParameterGeneratorSpi {
    protected SecureRandom random;
    protected int strength = 1024;

    protected void engineInit(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
    }

    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for GOST3410 parameter generation.");
    }

    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters params;
        GOST3410ParametersGenerator pGen = new GOST3410ParametersGenerator();
        if (this.random != null) {
            pGen.init(this.strength, 2, this.random);
        } else {
            pGen.init(this.strength, 2, new SecureRandom());
        }
        GOST3410Parameters p = pGen.generateParameters();
        try {
            params = AlgorithmParameters.getInstance("GOST3410", BouncyCastleProvider.PROVIDER_NAME);
            params.init(new GOST3410ParameterSpec(new GOST3410PublicKeyParameterSetSpec(p.getP(), p.getQ(), p.getA())));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return params;
    }
}

