/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.bouncycastle.operator.bc;

import cfca.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import cfca.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cfca.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cfca.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.crypto.Digest;
import cfca.org.bouncycastle.crypto.ExtendedDigest;
import cfca.org.bouncycastle.crypto.digests.GOST3411Digest;
import cfca.org.bouncycastle.crypto.digests.MD2Digest;
import cfca.org.bouncycastle.crypto.digests.MD4Digest;
import cfca.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.org.bouncycastle.crypto.digests.RIPEMD128Digest;
import cfca.org.bouncycastle.crypto.digests.RIPEMD160Digest;
import cfca.org.bouncycastle.crypto.digests.RIPEMD256Digest;
import cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.org.bouncycastle.crypto.digests.SHA224Digest;
import cfca.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.org.bouncycastle.crypto.digests.SHA384Digest;
import cfca.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.org.bouncycastle.operator.OperatorCreationException;

class BcUtil {
    BcUtil() {
    }

    static Digest createDigest(AlgorithmIdentifier digAlg) throws OperatorCreationException {
        ExtendedDigest dig;
        if (digAlg.getAlgorithm().equals(OIWObjectIdentifiers.idSHA1)) {
            dig = new SHA1Digest();
        } else if (digAlg.getAlgorithm().equals(NISTObjectIdentifiers.id_sha224)) {
            dig = new SHA224Digest();
        } else if (digAlg.getAlgorithm().equals(NISTObjectIdentifiers.id_sha256)) {
            dig = new SHA256Digest();
        } else if (digAlg.getAlgorithm().equals(NISTObjectIdentifiers.id_sha384)) {
            dig = new SHA384Digest();
        } else if (digAlg.getAlgorithm().equals(NISTObjectIdentifiers.id_sha512)) {
            dig = new SHA512Digest();
        } else if (digAlg.getAlgorithm().equals(PKCSObjectIdentifiers.md5)) {
            dig = new MD5Digest();
        } else if (digAlg.getAlgorithm().equals(PKCSObjectIdentifiers.md4)) {
            dig = new MD4Digest();
        } else if (digAlg.getAlgorithm().equals(PKCSObjectIdentifiers.md2)) {
            dig = new MD2Digest();
        } else if (digAlg.getAlgorithm().equals(CryptoProObjectIdentifiers.gostR3411)) {
            dig = new GOST3411Digest();
        } else if (digAlg.getAlgorithm().equals(TeleTrusTObjectIdentifiers.ripemd128)) {
            dig = new RIPEMD128Digest();
        } else if (digAlg.getAlgorithm().equals(TeleTrusTObjectIdentifiers.ripemd160)) {
            dig = new RIPEMD160Digest();
        } else if (digAlg.getAlgorithm().equals(TeleTrusTObjectIdentifiers.ripemd256)) {
            dig = new RIPEMD256Digest();
        } else {
            throw new OperatorCreationException("cannot recognise digest");
        }
        return dig;
    }
}

