/*
 * Decompiled with CFR 0.152.
 */
package cfca.rsa.signature;

import cfca.internal.tool.FileUtil;
import cfca.org.bouncycastle.crypto.Signer;
import cfca.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.org.bouncycastle.crypto.signers.RSADigestSigner;
import cfca.sm2rsa.common.GlobalVariable;
import cfca.sm2rsa.common.PKIException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.security.Key;
import java.security.interfaces.RSAPublicKey;

public class RSASignUtil {
    public static boolean verifySign(String digestAlgorithm, Key pubKey, byte[] sourceData, byte[] signature) throws PKIException {
        if (sourceData == null || signature == null) {
            return false;
        }
        Signer signer = RSASignUtil.getSigner(digestAlgorithm);
        if ("SM2".equalsIgnoreCase(pubKey.getAlgorithm())) {
            return false;
        }
        RSAPublicKey publicKey = (RSAPublicKey)pubKey;
        RSAKeyParameters pubParameter = RSASignUtil.generatePublicKeyParameter(publicKey);
        signer.init(false, pubParameter);
        try {
            signer.update(sourceData, 0, sourceData.length);
        }
        catch (Exception e) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        return signer.verifySignature(signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifySignFile(String digestAlgorithm, Key pubKey, String sourceFilePath, byte[] signature) throws Exception {
        if (sourceFilePath == null || signature == null) {
            return false;
        }
        Signer signer = RSASignUtil.getSigner(digestAlgorithm);
        RSAPublicKey publicKey = (RSAPublicKey)pubKey;
        RSAKeyParameters pubParameter = RSASignUtil.generatePublicKeyParameter(publicKey);
        signer.init(false, pubParameter);
        BufferedInputStream bfis = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFilePath);
            bfis = new BufferedInputStream(fis);
            int buffer_size = GlobalVariable.BIG_FILE_BUFFER;
            byte[] buffer = new byte[buffer_size];
            int i = bfis.read(buffer);
            if (i == -1) {
                throw new Exception("the source data is null!");
            }
            do {
                signer.update(buffer, 0, i);
            } while ((i = bfis.read(buffer)) != -1);
        }
        finally {
            if (bfis != null) {
                try {
                    bfis.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        return signer.verifySignature(signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifySignFile(String digestAlgorithm, Key pubKey, String sourceFilePath, long startPos, long dataLength, byte[] signature, String generate_sourceFilePath) throws Exception {
        byte[] buffer;
        RandomAccessFile bfis = null;
        FileOutputStream fos = null;
        if (sourceFilePath == null || signature == null) {
            boolean bl = false;
            return bl;
        }
        Signer signer = RSASignUtil.getSigner(digestAlgorithm);
        RSAPublicKey publicKey = (RSAPublicKey)pubKey;
        RSAKeyParameters pubParameter = RSASignUtil.generatePublicKeyParameter(publicKey);
        signer.init(false, pubParameter);
        bfis = new RandomAccessFile(new File(sourceFilePath), "r");
        bfis.seek(startPos);
        if (generate_sourceFilePath != null && !generate_sourceFilePath.trim().equals("")) {
            fos = new FileOutputStream(generate_sourceFilePath);
        }
        if (dataLength > (long)GlobalVariable.BIG_FILE_BUFFER) {
            int readLen;
            buffer = new byte[GlobalVariable.BIG_FILE_BUFFER];
            for (long readTotalLen = 0L; (readLen = bfis.read(buffer)) > 0 && readTotalLen < dataLength; readTotalLen += (long)readLen) {
                if (readTotalLen + (long)readLen <= dataLength) {
                    signer.update(buffer, 0, readLen);
                    FileUtil.writeBytesToFile(buffer, 0, readLen, fos);
                    continue;
                }
                int left = (int)(dataLength - readTotalLen);
                signer.update(buffer, 0, left);
                FileUtil.writeBytesToFile(buffer, 0, left, fos);
                break;
            }
        } else {
            buffer = new byte[(int)dataLength];
            int i = bfis.read(buffer);
            signer.update(buffer, 0, i);
            FileUtil.writeBytesToFile(buffer, 0, i, fos);
        }
        boolean bl = signer.verifySignature(signature);
        return bl;
        finally {
            if (bfis != null) {
                try {
                    bfis.close();
                }
                catch (Exception e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static Signer getSigner(String digestAlgorithm) throws PKIException {
        if (digestAlgorithm.equals("MD5")) {
            return new RSADigestSigner(new MD5Digest());
        }
        if (digestAlgorithm.equals("SHA1")) {
            return new RSADigestSigner(new SHA1Digest());
        }
        if (digestAlgorithm.equals("SHA256")) {
            return new RSADigestSigner(new SHA256Digest());
        }
        if (digestAlgorithm.equals("SHA512")) {
            return new RSADigestSigner(new SHA512Digest());
        }
        throw new PKIException("can not support this degest algorithm:" + digestAlgorithm);
    }

    private static RSAKeyParameters generatePublicKeyParameter(RSAPublicKey key) {
        return new RSAKeyParameters(false, key.getModulus(), key.getPublicExponent());
    }
}

