/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.sm2;

import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.asn1.ASN1Integer;
import cfca.org.bouncycastle.asn1.ASN1Object;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.DERSequence;
import cfca.org.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.util.Enumeration;

public final class ASN1SM2Signature
extends ASN1Object {
    private ASN1Integer r;
    private ASN1Integer s;

    public static ASN1SM2Signature getInstance(Object o) throws IllegalArgumentException {
        if (o instanceof ASN1SM2Signature) {
            return (ASN1SM2Signature)o;
        }
        if (o != null) {
            return new ASN1SM2Signature(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public ASN1SM2Signature(BigInteger r, BigInteger s) {
        this.r = new ASN1Integer(r);
        this.s = new ASN1Integer(s);
    }

    public ASN1SM2Signature(ASN1Integer r, ASN1Integer s) {
        this.r = r;
        this.s = s;
    }

    public ASN1SM2Signature(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.r = (ASN1Integer)e.nextElement();
        this.s = (ASN1Integer)e.nextElement();
    }

    public ASN1SM2Signature(byte[] signature) throws SecurityException {
        if (signature == null || signature.length < 64) {
            throw new SecurityException("Unknown signature value");
        }
        if (signature.length == 64) {
            this.r = new ASN1Integer(new BigInteger(1, Arrays.copyOfRange(signature, 0, 32)));
            this.s = new ASN1Integer(new BigInteger(1, Arrays.copyOfRange(signature, 32, 64)));
        } else {
            ASN1InputStream asn1Is = null;
            try {
                asn1Is = new ASN1InputStream(signature);
                ASN1Sequence seq = null;
                seq = (ASN1Sequence)asn1Is.readObject();
                Enumeration e = seq.getObjects();
                this.r = (ASN1Integer)e.nextElement();
                this.s = (ASN1Integer)e.nextElement();
            }
            catch (Exception e) {
                throw new SecurityException("Unknown  signature value: " + e.getMessage());
            }
            finally {
                if (asn1Is != null) {
                    try {
                        asn1Is.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public ASN1Integer getR() {
        return this.r;
    }

    public ASN1Integer getS() {
        return this.s;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.r);
        v.add(this.s);
        return new DERSequence(v);
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("SM2Signature [r=");
        builder.append(this.r);
        builder.append(", s=");
        builder.append(this.s);
        builder.append(']');
        return builder.toString();
    }
}

