/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm.algorithm;

import cfca.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import cfca.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import cfca.org.bouncycastle.math.ec.ECCurve;
import cfca.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.signature.sm2.BCSoftSM2;
import cfca.sm.algorithm.SM2Result;
import cfca.sm.algorithm.SM2Util;
import cfca.system.SecureRandoms;
import java.math.BigInteger;

public class SM2 {
    public String[] ecc_param = SM2Util.sm2_param;
    public BigInteger ecc_p;
    public BigInteger ecc_a;
    public BigInteger ecc_b;
    public BigInteger ecc_n;
    public BigInteger ecc_gx;
    public BigInteger ecc_gy;
    public ECCurve ecc_curve;
    public ECPoint ecc_point_g;
    public ECDomainParameters ecc_bc_spec;
    public ECKeyPairGenerator ecc_key_pair_generator;

    public SM2() {
        this.init();
    }

    private void init() {
        this.ecc_p = SM2Params.p;
        this.ecc_a = SM2Params.a;
        this.ecc_b = SM2Params.b;
        this.ecc_n = SM2Params.n;
        this.ecc_gx = SM2Params.gx;
        this.ecc_gy = SM2Params.gy;
        this.ecc_bc_spec = SM2Params.sm2DomainParameters;
        this.ecc_curve = this.ecc_bc_spec.getCurve();
        this.ecc_point_g = this.ecc_bc_spec.getG();
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init(new ECKeyGenerationParameters(this.ecc_bc_spec, SecureRandoms.getInstance().newSecureRandom()));
    }

    public void sm2Sign(byte[] hash, BigInteger d, SM2Result sm2Ret) {
        if (hash == null) {
            throw new IllegalArgumentException("null not allowed for hash");
        }
        if (d == null) {
            throw new IllegalArgumentException("null not allowed for d");
        }
        if (sm2Ret == null) {
            throw new IllegalArgumentException("null not allowed for sm2Ret");
        }
        byte[] data = BCSoftSM2.sign(hash, d);
        ASN1SM2Signature sig = new ASN1SM2Signature(data);
        sm2Ret.r = sig.getR().getValue();
        sm2Ret.s = sig.getS().getValue();
    }

    public boolean sm2Verify(byte[] hash, ECPoint userKey, SM2Result sm2Ret) {
        if (hash == null) {
            throw new IllegalArgumentException("null not allowed for hash");
        }
        if (userKey == null) {
            throw new IllegalArgumentException("null not allowed for userKey");
        }
        if (sm2Ret == null) {
            throw new IllegalArgumentException("null not allowed for sm2Ret");
        }
        if (sm2Ret.r == null || sm2Ret.s == null) {
            throw new IllegalArgumentException("null not allowed for sm2Ret: r/s");
        }
        byte[] signature = new byte[64];
        System.arraycopy(BigIntegers.asUnsignedByteArray(32, sm2Ret.r), 0, signature, 0, 32);
        System.arraycopy(BigIntegers.asUnsignedByteArray(32, sm2Ret.s), 0, signature, 32, 32);
        return BCSoftSM2.verify(hash, signature, userKey);
    }
}

