/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm.algorithm;

import cfca.internal.tool.BigIntegerUtil;
import cfca.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.signature.sm2.BCSoftSM2;
import cfca.sm.algorithm.SM3Digest;
import cfca.sm2.signature.SM2PrivateKey;
import cfca.sm2.signature.SM2PublicKey;
import java.math.BigInteger;
import java.security.KeyPair;
import java.util.Arrays;

public class SM2Crypto {
    private int ct = 1;
    private ECPoint tempQ;
    private ECPoint userQ = null;
    private SM3Digest sm3KeyBase;
    private SM3Digest sm3C3;
    private byte[] key = new byte[32];
    private byte keyOff = 0;
    private BigInteger userD;

    private void reset() {
        this.sm3KeyBase = new SM3Digest();
        this.sm3C3 = new SM3Digest();
        byte[] p = BigIntegerUtil.asUnsigned32ByteArray(this.tempQ.getAffineXCoord().toBigInteger());
        this.sm3KeyBase.update(p, 0, p.length);
        this.sm3C3.update(p, 0, p.length);
        p = BigIntegerUtil.asUnsigned32ByteArray(this.tempQ.getAffineYCoord().toBigInteger());
        this.sm3KeyBase.update(p, 0, p.length);
        this.ct = 1;
        this.nextKey();
    }

    private void nextKey() {
        SM3Digest sm3keycur = new SM3Digest(this.sm3KeyBase);
        sm3keycur.update((byte)(this.ct >> 24 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 16 & 0xFF));
        sm3keycur.update((byte)(this.ct >> 8 & 0xFF));
        sm3keycur.update((byte)(this.ct & 0xFF));
        sm3keycur.doFinal(this.key, 0);
        this.keyOff = 0;
        ++this.ct;
    }

    public void init_enc(ECPoint userKey) {
        BigInteger k = null;
        KeyPair keypair = BCSoftSM2.generateKeyPair();
        k = ((SM2PrivateKey)keypair.getPrivate()).getD();
        this.userQ = ((SM2PublicKey)keypair.getPublic()).getQ().normalize();
        this.tempQ = userKey.multiply(k).normalize();
        this.reset();
    }

    public byte[] encrypt(byte[] sourceData) {
        byte[] data = (byte[])sourceData.clone();
        this.sm3C3.update(data, 0, data.length);
        int i = 0;
        while (i < data.length) {
            if (this.keyOff == this.key.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            data[n] = (byte)(data[n] ^ this.key[by]);
        }
        byte[] ret = new byte[64 + data.length + 32];
        byte[] c1X = BigIntegerUtil.asUnsigned32ByteArray(this.userQ.getAffineXCoord().toBigInteger());
        byte[] c1Y = BigIntegerUtil.asUnsigned32ByteArray(this.userQ.getAffineYCoord().toBigInteger());
        System.arraycopy(c1X, 0, ret, 0, 32);
        System.arraycopy(c1Y, 0, ret, 32, 32);
        System.arraycopy(data, 0, ret, 64, data.length);
        byte[] c3 = new byte[32];
        this.dofinal(c3);
        System.arraycopy(c3, 0, ret, 64 + data.length, 32);
        return ret;
    }

    public void init_dec(BigInteger userD) {
        this.userD = userD;
    }

    private ECPoint getECPoint(BigInteger X, BigInteger Y) {
        return SM2Params.sm2ParameterSpec.getCurve().createPoint(X, Y);
    }

    public byte[] decrypt(byte[] encryptData) throws Exception {
        byte[] data = (byte[])encryptData.clone();
        byte[] c1X_byte = new byte[32];
        byte[] c1Y_byte = new byte[32];
        System.arraycopy(data, 0, c1X_byte, 0, 32);
        System.arraycopy(data, 32, c1Y_byte, 0, 32);
        BigInteger ecc_c1X = new BigInteger(1, c1X_byte);
        BigInteger ecc_c1Y = new BigInteger(1, c1Y_byte);
        int encryptedLen = data.length - 64 - 32;
        byte[] encrypted = new byte[encryptedLen];
        System.arraycopy(data, 64, encrypted, 0, encryptedLen);
        ECPoint c1 = this.getECPoint(ecc_c1X, ecc_c1Y);
        this.tempQ = c1.multiply(this.userD).normalize();
        this.reset();
        int i = 0;
        while (i < encryptedLen) {
            if (this.keyOff == this.key.length) {
                this.nextKey();
            }
            int n = i++;
            byte by = this.keyOff;
            this.keyOff = (byte)(by + 1);
            encrypted[n] = (byte)(encrypted[n] ^ this.key[by]);
        }
        this.sm3C3.update(encrypted, 0, encryptedLen);
        byte[] c3 = new byte[32];
        this.dofinal(c3);
        byte[] old_c3 = new byte[32];
        System.arraycopy(data, 64 + encryptedLen, old_c3, 0, 32);
        if (Arrays.equals(c3, old_c3)) {
            return encrypted;
        }
        throw new Exception("can not decrypted use SM2 encryp/decrypt,please check if the data is right");
    }

    private void dofinal(byte[] c3) {
        byte[] value = BigIntegerUtil.asUnsigned32ByteArray(this.tempQ.getAffineYCoord().toBigInteger());
        this.sm3C3.update(value, 0, value.length);
        this.sm3C3.doFinal(c3, 0);
        this.reset();
    }
}

