/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm.algorithm;

import cfca.internal.tool.ASN1Parser;
import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1Integer;
import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.BERSequence;
import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sm.algorithm.SM3Digest;
import cfca.sm.algorithm.SM4Engine;
import cfca.sm2.signature.SM2PrivateKey;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cfca.util.Base64;
import cfca.util.KeyUtil;
import cfca.x509.certificate.X509Cert;

public class SM2Pfx
implements ASN1Encodable,
PKCSObjectIdentifiers {
    private ASN1Sequence privateInfo = null;
    private ASN1Sequence publicInfo = null;
    private ASN1OctetString pubOctString;
    private ASN1OctetString priOctString;

    public static SM2Pfx getInstance(Object object) throws PKIException {
        if (object == null) {
            throw new IllegalArgumentException("null not allowed for object");
        }
        if (object instanceof SM2Pfx) {
            return (SM2Pfx)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SM2Pfx((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory " + object.getClass().getName());
    }

    public SM2Pfx(ASN1Sequence seq) throws PKIException {
        int size = seq.size();
        if (size == 3) {
            this.privateInfo = (ASN1Sequence)seq.getObjectAt(1);
            this.publicInfo = (ASN1Sequence)seq.getObjectAt(2);
            if (this.privateInfo.size() != 3) {
                throw new PKIException("the sm2 file is not right format,can not get the private part");
            }
            this.priOctString = (ASN1OctetString)this.privateInfo.getObjectAt(2);
            if (this.publicInfo.size() == 2) {
                this.pubOctString = (ASN1OctetString)this.publicInfo.getObjectAt(1);
            } else {
                throw new PKIException("the sm2 file is not right format.can not get the public part");
            }
        }
    }

    private byte[] KDF(byte[] z) {
        byte[] ct = new byte[]{0, 0, 0, 1};
        SM3Digest sm3 = new SM3Digest();
        sm3.update(z, 0, z.length);
        sm3.update(ct, 0, ct.length);
        byte[] hash = new byte[32];
        sm3.doFinal(hash, 0);
        return hash;
    }

    public SM2PrivateKey getPrivateKey(String pass) throws Exception {
        if (pass != null) {
            byte[] src = pass.getBytes("UTF8");
            byte[] hash = this.KDF(src);
            byte[] iv = new byte[16];
            System.arraycopy(hash, 0, iv, 0, 16);
            byte[] key = new byte[16];
            System.arraycopy(hash, 16, key, 0, 16);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), iv);
            cipher.init(false, params);
            byte[] encryptPriKey = this.priOctString.getOctets();
            boolean isB64 = ASN1Parser.isBase64Encode(encryptPriKey);
            if (isB64) {
                encryptPriKey = ASN1Parser.convertBase64(encryptPriKey);
                encryptPriKey = Base64.decode(encryptPriKey);
            }
            int len = cipher.getOutputSize(encryptPriKey.length);
            byte[] priKey = new byte[len];
            int len1 = cipher.processBytes(encryptPriKey, 0, encryptPriKey.length, priKey, 0);
            int len2 = cipher.doFinal(priKey, len1);
            int total = len1 + len2;
            X509Cert cert = this.getPublicCert();
            SM2PublicKey pubKey = (SM2PublicKey)cert.getPublicKey();
            byte[] pubX = pubKey.getPubX();
            byte[] pubY = pubKey.getPubY();
            if (total < len) {
                byte[] removeZeroSourceData = new byte[total];
                System.arraycopy(priKey, 0, removeZeroSourceData, 0, total);
                return KeyUtil.getSM2PrivateKey(removeZeroSourceData, pubX, pubY);
            }
            return KeyUtil.getSM2PrivateKey(priKey, pubX, pubY);
        }
        throw new PKIException("the pass word should not be null");
    }

    public X509Cert getPublicCert() throws PKIException {
        byte[] cert = this.pubOctString.getOctets();
        return new X509Cert(cert);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(1));
        v.add(this.privateInfo);
        v.add(this.publicInfo);
        return new BERSequence(v);
    }
}

