/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm.algorithm;

import cfca.internal.tool.BigEndianUtil;
import cfca.org.bouncycastle.crypto.BlockCipher;
import cfca.org.bouncycastle.crypto.CipherParameters;
import cfca.org.bouncycastle.crypto.DataLengthException;
import cfca.org.bouncycastle.crypto.params.KeyParameter;

public class SM4Engine
implements BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private int[] workingKey = null;
    static byte[][] SboxTable = new byte[][]{{-42, -112, -23, -2, -52, -31, 61, -73, 22, -74, 20, -62, 40, -5, 44, 5}, {43, 103, -102, 118, 42, -66, 4, -61, -86, 68, 19, 38, 73, -122, 6, -103}, {-100, 66, 80, -12, -111, -17, -104, 122, 51, 84, 11, 67, -19, -49, -84, 98}, {-28, -77, 28, -87, -55, 8, -24, -107, -128, -33, -108, -6, 117, -113, 63, -90}, {71, 7, -89, -4, -13, 115, 23, -70, -125, 89, 60, 25, -26, -123, 79, -88}, {104, 107, -127, -78, 113, 100, -38, -117, -8, -21, 15, 75, 112, 86, -99, 53}, {30, 36, 14, 94, 99, 88, -47, -94, 37, 34, 124, 59, 1, 33, 120, -121}, {-44, 0, 70, 87, -97, -45, 39, 82, 76, 54, 2, -25, -96, -60, -56, -98}, {-22, -65, -118, -46, 64, -57, 56, -75, -93, -9, -14, -50, -7, 97, 21, -95}, {-32, -82, 93, -92, -101, 52, 26, 85, -83, -109, 50, 48, -11, -116, -79, -29}, {29, -10, -30, 46, -126, 102, -54, 96, -64, 41, 35, -85, 13, 83, 78, 111}, {-43, -37, 55, 69, -34, -3, -114, 47, 3, -1, 106, 114, 109, 108, 91, 81}, {-115, 27, -81, -110, -69, -35, -68, 127, 17, -39, 92, 65, 31, 16, 90, -40}, {10, -63, 49, -120, -91, -51, 123, -67, 45, 116, -48, 18, -72, -27, -76, -80}, {-119, 105, -105, 74, 12, -106, 119, 126, 101, -71, -15, 9, -59, 110, -58, -124}, {24, -16, 125, -20, 58, -36, 77, 32, 121, -18, 95, 62, -41, -53, 57, 72}};
    static int[] FK = new int[]{-1548633402, 1453994832, 1736282519, -1301273892};
    static int[] CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};

    public String getAlgorithmName() {
        return "SM4";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean forEncryption, CipherParameters params) {
        if (params instanceof KeyParameter) {
            this.workingKey = this.generateWorkingKey(forEncryption, ((KeyParameter)params).getKey());
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to SM4 init - " + params.getClass().getName());
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        int i;
        if (this.workingKey == null) {
            throw new IllegalStateException("SM4 engine not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        byte[] contentTemp = new byte[4];
        int[] X = new int[36];
        for (i = 0; i < 4; ++i) {
            System.arraycopy(in, i * 4 + inOff, contentTemp, 0, 4);
            X[i] = BigEndianUtil.bigEndianByteToInt(contentTemp);
        }
        for (i = 0; i < 32; ++i) {
            X[i + 4] = X[i] ^ SM4Engine.T(BigEndianUtil.bigEndianIntToByte(X[i + 1] ^ X[i + 2] ^ X[i + 3] ^ this.workingKey[i]));
        }
        for (i = 0; i < 4; ++i) {
            contentTemp = BigEndianUtil.bigEndianIntToByte(X[35 - i]);
            System.arraycopy(contentTemp, 0, out, i * 4 + outOff, 4);
        }
        return 16;
    }

    private static int bitCycleLeft(int n, int bitLen) {
        return n << (bitLen %= 32) | n >>> 32 - bitLen;
    }

    private static int L(int B) {
        return B ^ SM4Engine.bitCycleLeft(B, 2) ^ SM4Engine.bitCycleLeft(B, 10) ^ SM4Engine.bitCycleLeft(B, 18) ^ SM4Engine.bitCycleLeft(B, 24);
    }

    private static int L2(int B) {
        return B ^ SM4Engine.bitCycleLeft(B, 13) ^ SM4Engine.bitCycleLeft(B, 23);
    }

    private static int t(byte[] a) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int row = a[i] & 0xF0;
            int col = a[i] & 0xF;
            b[i] = SboxTable[row >>>= 4][col];
        }
        return BigEndianUtil.bigEndianByteToInt(b);
    }

    private static int T(byte[] a) {
        return SM4Engine.L(SM4Engine.t(a));
    }

    private static int T2(byte[] a) {
        return SM4Engine.L2(SM4Engine.t(a));
    }

    private int[] generateWorkingKey(boolean encrypting, byte[] key) throws IllegalArgumentException {
        int i;
        if (key == null || key.length != 16) {
            throw new IllegalArgumentException("key is null or length is not 16");
        }
        int[] newKey = new int[32];
        int[] K = new int[36];
        int[] MK = new int[4];
        byte[] keyTemp = new byte[4];
        for (i = 0; i < 4; ++i) {
            System.arraycopy(key, i * 4, keyTemp, 0, 4);
            MK[i] = BigEndianUtil.bigEndianByteToInt(keyTemp);
        }
        for (i = 0; i < 4; ++i) {
            K[i] = MK[i] ^ FK[i];
        }
        for (i = 0; i < 32; ++i) {
            K[i + 4] = K[i] ^ SM4Engine.T2(BigEndianUtil.bigEndianIntToByte(K[i + 1] ^ K[i + 2] ^ K[i + 3] ^ CK[i]));
            newKey[i] = K[i + 4];
        }
        if (encrypting) {
            return newKey;
        }
        int[] reverse = new int[32];
        for (int i2 = 0; i2 < 32; ++i2) {
            reverse[i2] = newKey[31 - i2];
        }
        return reverse;
    }

    public void reset() {
    }
}

