/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2.envelope;

import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1Object;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.BERSequence;
import cfca.org.bouncycastle.asn1.BERTaggedObject;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sm2.envelope.SM2EncryptedInputStream;

public class SM2EncryptedContentInfo
extends ASN1Object {
    private ASN1ObjectIdentifier contentType;
    private AlgorithmIdentifier contentEncryptionAlgorithm;
    private SM2EncryptedInputStream encryptedStream;

    public SM2EncryptedContentInfo(ASN1ObjectIdentifier contentType, AlgorithmIdentifier contentEncryptionAlgorithm, SM2EncryptedInputStream encryptedStream) {
        this.contentType = contentType;
        this.contentEncryptionAlgorithm = contentEncryptionAlgorithm;
        this.encryptedStream = encryptedStream;
    }

    private SM2EncryptedContentInfo(ASN1Sequence seq) {
        if (seq.size() < 2) {
            throw new IllegalArgumentException("Truncated Sequence Found");
        }
        this.contentType = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        this.contentEncryptionAlgorithm = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        if (seq.size() > 2) {
            this.encryptedStream = SM2EncryptedInputStream.getInstance(seq.getObjectAt(2));
        }
    }

    public static SM2EncryptedContentInfo getInstance(Object obj) {
        if (obj instanceof SM2EncryptedContentInfo) {
            return (SM2EncryptedContentInfo)obj;
        }
        if (obj != null) {
            return new SM2EncryptedContentInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public SM2EncryptedInputStream getEncryptedContent() {
        return this.encryptedStream;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.contentType);
        v.add(this.contentEncryptionAlgorithm);
        if (this.encryptedStream != null) {
            v.add(new BERTaggedObject(false, 0, this.encryptedStream));
        }
        return new BERSequence(v);
    }
}

