/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2.envelope;

import cfca.asn1.parser.ASN1Node;
import cfca.asn1.parser.BigFileDecrypt;
import cfca.asn1.parser.EnvelopFileParser;
import cfca.internal.tool.ASN1Parser;
import cfca.internal.tool.Mechanism_Inside;
import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.BEROctetString;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.DEROutputStream;
import cfca.org.bouncycastle.asn1.DERSet;
import cfca.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import cfca.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cfca.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.org.bouncycastle.asn1.cms.RecipientIdentifier;
import cfca.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cfca.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.sm.algorithm.SM4Engine;
import cfca.sm2.envelope.SM2EncryptedContentInfo;
import cfca.sm2.envelope.SM2EncryptedInputStream;
import cfca.sm2.envelope.SM2EnvelopedData;
import cfca.sm2.envelope.SM2SymmetricCryptoUtil;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.PKCS7EnvelopedData;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cfca.system.SecureRandoms;
import cfca.util.Base64;
import cfca.util.cipher.lib.JCrypto;
import cfca.util.cipher.lib.Session;
import cfca.x509.certificate.X509Cert;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;

public class SM2EnvelopeUtil {
    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        SymmetricAlgorithmParameters params = SM2EnvelopeUtil.buildSymmetricAlgorithmParameters(symmetricAlgorithm, receiverCerts, session);
        byte[] encryptedData = SM2EnvelopeUtil.SM4Encrypt(params.symmetricKey, sourceData, params.contentEncryptionAlg);
        BEROctetString encryptOctet = new BEROctetString(encryptedData);
        EncryptedContentInfo eci = new EncryptedContentInfo(PKCSObjectIdentifiers.sm2Data, params.contentEncryptionAlgId, encryptOctet);
        EnvelopedData enData = new EnvelopedData(null, new DERSet(params.recipientInfos), eci, null);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.sm2EnvelopedData, enData);
        byte[] envelopeBytes = ASN1Parser.writeDERObj2Bytes(new CMSEnvelopedData(contentInfo).toASN1Structure());
        return Base64.encode(envelopeBytes);
    }

    public static final byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts) throws Exception {
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        return SM2EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session);
    }

    public static void envelopeFile(String sourceFilePath, String encryptedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        SymmetricAlgorithmParameters params = SM2EnvelopeUtil.buildSymmetricAlgorithmParameters(symmetricAlgorithm, receiverCerts, session);
        SM2EncryptedInputStream encryptStream = new SM2EncryptedInputStream(new File(sourceFilePath), params.symmetricKey, params.contentEncryptionAlg);
        SM2EncryptedContentInfo sm2Eci = new SM2EncryptedContentInfo(PKCSObjectIdentifiers.sm2Data, params.contentEncryptionAlgId, encryptStream);
        SM2EnvelopedData enData = new SM2EnvelopedData(null, new DERSet(params.recipientInfos), sm2Eci, null);
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.sm2EnvelopedData, enData);
        File file = new File(encryptedFilePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fos = null;
        ASN1OutputStream dos = null;
        try {
            fos = new FileOutputStream(file);
            dos = new DEROutputStream(fos);
            ((DEROutputStream)dos).writeObject(contentInfo);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static final void envelopeFile(String sourceFilePath, String encryptedFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts) throws Exception {
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        SM2EnvelopeUtil.envelopeFile(sourceFilePath, encryptedFilePath, symmetricAlgorithm, receiverCerts, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void openEnvelopedFile(String encryptedFilePath, String plainTextFilePath, PrivateKey privateKey, X509Cert recipientCert, Session session) throws Exception {
        EnvelopFileParser parser = new EnvelopFileParser(new File(encryptedFilePath));
        parser.parser();
        ASN1Node receiver_node = parser.getReceiver_node();
        ASN1Node encrypted_node = parser.getEncrypted_node();
        FileOutputStream fos = null;
        try {
            ASN1Set receivers = ASN1Set.getInstance(receiver_node.getData());
            byte[] symmetricKey = SM2EnvelopeUtil.checkRecipientsAndSymmetricKey(privateKey, recipientCert, receivers, session);
            ASN1Node symmetric_encrypted = (ASN1Node)encrypted_node.childNodes.get(1);
            byte[] symmetricAlg_byte = symmetric_encrypted.getData();
            AlgorithmIdentifier symmetricAlgId = AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(symmetricAlg_byte));
            Mechanism_Inside mechanism = SM2EnvelopeUtil.buildMechanism(symmetricAlgId);
            File plainTextFile = new File(plainTextFilePath);
            if (!plainTextFile.exists()) {
                plainTextFile.createNewFile();
            }
            fos = new FileOutputStream(plainTextFile);
            ASN1Node file_encrypted = (ASN1Node)encrypted_node.childNodes.get(2);
            if (file_encrypted.childNodes.size() == 1) {
                file_encrypted = (ASN1Node)file_encrypted.childNodes.get(0);
            }
            BigFileDecrypt.bigFileBlockDecrypt(symmetricKey, new SM4Engine(), (CBCParam)mechanism.getParam(), file_encrypted, fos);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static final void openEnvelopedFile(String encryptedFilePath, String plainTextFilePath, PrivateKey privateKey, X509Cert recipientCert) throws Exception {
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        SM2EnvelopeUtil.openEnvelopedFile(encryptedFilePath, plainTextFilePath, privateKey, recipientCert, session);
    }

    public static final byte[] openEvelopedMessage(byte[] cmsEnvelopedData, PrivateKey privateKey, X509Cert recipientCert, Session session) throws Exception {
        byte[] bEnvelop = Base64.decode(cmsEnvelopedData);
        CMSEnvelopedData cmsEnData = new CMSEnvelopedData(bEnvelop);
        ContentInfo info = cmsEnData.toASN1Structure();
        EnvelopedData enData = EnvelopedData.getInstance(info.getContent());
        ASN1Set receivers = enData.getRecipientInfos();
        byte[] symmetricKey = SM2EnvelopeUtil.checkRecipientsAndSymmetricKey(privateKey, recipientCert, receivers, session);
        EncryptedContentInfo data = enData.getEncryptedContentInfo();
        ASN1OctetString os = data.getEncryptedContent();
        AlgorithmIdentifier symmetricAlgId = data.getContentEncryptionAlgorithm();
        Mechanism_Inside mechanism = SM2EnvelopeUtil.buildMechanism(symmetricAlgId);
        byte[] sourceData = SM2EnvelopeUtil.SM4Decrypt(symmetricKey, os.getOctets(), mechanism);
        return sourceData;
    }

    public static final byte[] openEvelopedMessage(byte[] cmsEnvelopedData, PrivateKey privateKey, X509Cert recipientCert) throws Exception {
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        return SM2EnvelopeUtil.openEvelopedMessage(cmsEnvelopedData, privateKey, recipientCert, session);
    }

    private static byte[] checkRecipientsAndSymmetricKey(PrivateKey privateKey, X509Cert recipientCert, ASN1Set receivers, Session session) throws Exception {
        if (receivers == null) {
            throw new Exception("the receiver is null!!!");
        }
        SubjectKeyIdentifier acceptedRecipientSubjectKeyID = recipientCert.getSubjectKeyIdentifier();
        X500Name acceptedRecipientIssuer = recipientCert.getIssuerX500Name();
        BigInteger acceptedRecipientSN = recipientCert.getSerialNumber();
        ASN1OctetString encryptKey = null;
        AlgorithmIdentifier algId = null;
        RecipientInfo recip = null;
        KeyTransRecipientInfo inf = null;
        int len = receivers.size();
        for (int i = 0; i < len; ++i) {
            recip = RecipientInfo.getInstance(receivers.getObjectAt(i));
            if (!(recip.getInfo() instanceof KeyTransRecipientInfo) || !SM2EnvelopeUtil.hasRecipent(inf = KeyTransRecipientInfo.getInstance(recip.getInfo()), acceptedRecipientSubjectKeyID, acceptedRecipientIssuer, acceptedRecipientSN)) continue;
            encryptKey = inf.getEncryptedKey();
            algId = inf.getKeyEncryptionAlgorithm();
            break;
        }
        if (encryptKey == null || algId == null) {
            throw new Exception("can not find the receiver!!!");
        }
        byte[] symmetricKey = SM2EnvelopeUtil.SM2DecryptSymmetricKey(privateKey, encryptKey.getOctets(), session);
        if (symmetricKey == null) {
            throw new SecurityException("decrypt symmetricKey failure");
        }
        return symmetricKey;
    }

    private static boolean hasRecipent(KeyTransRecipientInfo keyTransRecipientInfo, SubjectKeyIdentifier acceptedRecipientSubjectKeyID, X500Name acceptedRecipientIssuer, BigInteger acceptedRecipientSN) {
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier == null) {
            return false;
        }
        IssuerAndSerialNumber issu = new IssuerAndSerialNumber(acceptedRecipientIssuer, acceptedRecipientSN);
        if (!recipientIdentifier.getId().toASN1Primitive().asn1Equals(issu.toASN1Primitive())) {
            return false;
        }
        if (acceptedRecipientSubjectKeyID != null && recipientIdentifier.getId() != null) {
            DEROctetString oct = new DEROctetString(acceptedRecipientSubjectKeyID.getKeyIdentifier());
            return recipientIdentifier.getId().toASN1Primitive().asn1Equals(oct);
        }
        return false;
    }

    private static Mechanism_Inside buildMechanism(AlgorithmIdentifier symmetricAlgId) throws PKIException {
        Mechanism_Inside mechanism = null;
        String encryptionAlgStr = (String)PKCS7EnvelopedData.OID_MECH.get(symmetricAlgId.getAlgorithm());
        if (encryptionAlgStr.indexOf("CBC") != -1) {
            DEROctetString doct = (DEROctetString)symmetricAlgId.getParameters();
            CBCParam cbcParam = new CBCParam(doct.getOctets());
            mechanism = encryptionAlgStr.equals("SM4/CBC/PKCS7Padding") ? new Mechanism_Inside("SM4/CBC/PKCS7Padding", cbcParam) : new Mechanism_Inside("SM4/CBC/PKCS7Padding", cbcParam);
        } else if (encryptionAlgStr.indexOf("ECB") != -1) {
            mechanism = new Mechanism_Inside("SM4/ECB/PKCS7Padding");
        } else {
            throw new PKIException("850629", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301Algorithm is:" + encryptionAlgStr);
        }
        return mechanism;
    }

    private static RecipientInfo buildRecipientInfo(X509Cert cert, byte[] symmetricKey, Session session) throws Exception {
        byte[] encryptedKey = SM2EnvelopeUtil.SM2EncryptSymmetricKey(cert.getPublicKey(), symmetricKey, session);
        DEROctetString encKey = new DEROctetString(encryptedKey);
        SubjectKeyIdentifier sid = cert.getSubjectKeyIdentifier();
        if (sid == null) {
            throw new Exception("the cert has no extension data with SubjectKeyIdentifier,can not create envelope data");
        }
        AlgorithmIdentifier keyEncAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.SM2_pubKey_encrypt, (ASN1Encodable)new DERNull());
        KeyTransRecipientInfo ktr = new KeyTransRecipientInfo(new RecipientIdentifier(new DEROctetString(sid.getKeyIdentifier())), keyEncAlg, encKey);
        return new RecipientInfo(ktr);
    }

    private static SymmetricAlgorithmParameters buildSymmetricAlgorithmParameters(String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        int keyLength = 16;
        int ivLength = 16;
        byte[] keyAndIv = SecureRandoms.getInstance().genBytes(32);
        byte[] symmetricKey = new byte[16];
        System.arraycopy(keyAndIv, 0, symmetricKey, 0, symmetricKey.length);
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        for (int i = 0; i < receiverCerts.length; ++i) {
            recipientInfos.add(SM2EnvelopeUtil.buildRecipientInfo(receiverCerts[i], symmetricKey, session));
        }
        ASN1ObjectIdentifier tOID = (ASN1ObjectIdentifier)PKCS7EnvelopedData.MECH_OID.get(symmetricAlgorithm);
        Mechanism_Inside contentEncryptionAlg = null;
        AlgorithmIdentifier contentEncryptionAlgId = null;
        if (symmetricAlgorithm.indexOf("CBC") != -1) {
            byte[] iv = new byte[16];
            System.arraycopy(keyAndIv, 16, iv, 0, iv.length);
            CBCParam cbcParam = new CBCParam(iv);
            contentEncryptionAlg = new Mechanism_Inside(symmetricAlgorithm, cbcParam);
            DEROctetString doct = new DEROctetString(iv);
            contentEncryptionAlgId = new AlgorithmIdentifier(tOID, (ASN1Encodable)doct);
        } else {
            contentEncryptionAlg = new Mechanism_Inside(symmetricAlgorithm);
            contentEncryptionAlgId = new AlgorithmIdentifier(tOID, (ASN1Encodable)new DERNull());
        }
        SymmetricAlgorithmParameters params = new SymmetricAlgorithmParameters();
        params.symmetricKey = symmetricKey;
        params.recipientInfos = recipientInfos;
        params.contentEncryptionAlg = contentEncryptionAlg;
        params.contentEncryptionAlgId = contentEncryptionAlgId;
        return params;
    }

    private static final byte[] SM4Encrypt(byte[] key, byte[] sourceData, Mechanism_Inside contentEncryptionAlg) throws Exception {
        return SM2SymmetricCryptoUtil.cryptoUtil(true, key, sourceData, contentEncryptionAlg);
    }

    private static final byte[] SM4Decrypt(byte[] symmetricKey, byte[] octets, Mechanism_Inside mechanism) throws Exception {
        return SM2SymmetricCryptoUtil.cryptoUtil(false, symmetricKey, octets, mechanism);
    }

    private static final byte[] SM2EncryptSymmetricKey(PublicKey publicKey, byte[] symmetricKey, Session session) throws Exception {
        Mechanism_Inside contentEncryptionAlg = new Mechanism_Inside("SM2");
        byte[] encryptedSymmetricKey = session.encrypt(contentEncryptionAlg, publicKey, symmetricKey);
        return encryptedSymmetricKey;
    }

    private static final byte[] SM2DecryptSymmetricKey(PrivateKey privateKey, byte[] encryptedSymmetricKey, Session session) throws Exception {
        Mechanism_Inside contentEncryptionAlg = new Mechanism_Inside("SM2");
        byte[] decryptedSymmetricKey = session.encrypt(contentEncryptionAlg, privateKey, encryptedSymmetricKey);
        return decryptedSymmetricKey;
    }

    static final class SymmetricAlgorithmParameters {
        public ASN1EncodableVector recipientInfos;
        public Mechanism_Inside contentEncryptionAlg;
        byte[] symmetricKey;
        AlgorithmIdentifier contentEncryptionAlgId = null;

        SymmetricAlgorithmParameters() {
        }
    }
}

