/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2.envelope;

import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sm.algorithm.SM2Crypto;
import cfca.sm.algorithm.SM4Engine;
import cfca.sm2.signature.SM2PrivateKey;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.Mechanism;
import cfca.system.SecureRandoms;
import java.security.Key;

public class SM2SymmetricCryptoUtil {
    public static byte[] generateSecretKey() {
        return SecureRandoms.getInstance().genBytes(16);
    }

    public static byte[] generateIV() {
        return SecureRandoms.getInstance().genBytes(16);
    }

    public static byte[] cryptoUtil(boolean forEncryption, byte[] key, byte[] sourceData, Mechanism algName) throws Exception {
        if (algName.getMechanismType().indexOf("SM4") != -1 && algName.getMechanismType().indexOf("CBC") != -1) {
            CBCParam param = (CBCParam)algName.getParam();
            return SM2SymmetricCryptoUtil.useSM4CBCEncrypt(forEncryption, key, sourceData, param.getIv());
        }
        if (algName.getMechanismType().indexOf("SM4") != -1 && algName.getMechanismType().indexOf("ECB") != -1) {
            return SM2SymmetricCryptoUtil.useSM4ECBEncrypt(forEncryption, key, sourceData);
        }
        throw new Exception("can not support this algorithm to encrypt:" + algName.getMechanismType());
    }

    private static byte[] useSM4CBCEncrypt(boolean forEncryption, byte[] key, byte[] input, byte[] iv) throws Exception {
        ParametersWithIV param = new ParametersWithIV(new KeyParameter(key), iv);
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
        cipher.init(forEncryption, param);
        int len = cipher.getOutputSize(input.length);
        byte[] out = new byte[len];
        int len1 = cipher.processBytes(input, 0, input.length, out, 0);
        int len2 = cipher.doFinal(out, len1);
        int total = len1 + len2;
        if (total < len) {
            byte[] out2 = new byte[total];
            System.arraycopy(out, 0, out2, 0, total);
            return out2;
        }
        return out;
    }

    private static byte[] useSM4ECBEncrypt(boolean forEncryption, byte[] key, byte[] input) throws Exception {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new SM4Engine(), new PKCS7Padding());
        KeyParameter params = new KeyParameter(key);
        cipher.init(forEncryption, params);
        int len = cipher.getOutputSize(input.length);
        byte[] out = new byte[len];
        int len1 = cipher.processBytes(input, 0, input.length, out, 0);
        int len2 = cipher.doFinal(out, len1);
        int total = len1 + len2;
        if (total < len) {
            byte[] out2 = new byte[total];
            System.arraycopy(out, 0, out2, 0, total);
            return out2;
        }
        return out;
    }

    public static byte[] sm2Encrypt(boolean isEncrypted, Key sm2Key, byte[] input) throws Exception {
        SM2Crypto crypto = new SM2Crypto();
        if (isEncrypted) {
            SM2PublicKey pubKey = (SM2PublicKey)sm2Key;
            crypto.init_enc(pubKey.getQ());
            return crypto.encrypt(input);
        }
        SM2PrivateKey priKey = (SM2PrivateKey)sm2Key;
        crypto.init_dec(priKey.getD());
        return crypto.decrypt(input);
    }
}

