/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2.signature;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cfca.org.bouncycastle.asn1.sec.ECPrivateKey;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x9.X962Parameters;
import cfca.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cfca.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.org.bouncycastle.math.ec.ECPoint;
import cfca.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sm2.signature.SM2PublicKey;
import java.math.BigInteger;
import java.security.PrivateKey;

public final class SM2PrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 5602980457820266873L;
    private BigInteger d = null;
    private byte[] dBytes = null;
    private SM2PublicKey pubKey = null;

    public static SM2PrivateKey getInstance(byte[] encoded) {
        if (encoded == null) {
            throw new IllegalArgumentException("null not allowed for encoded");
        }
        BigInteger d = null;
        BigInteger x = null;
        BigInteger y = null;
        switch (encoded.length) {
            case 32: {
                byte[] value = new byte[32];
                System.arraycopy(encoded, 0, value, 0, 32);
                d = new BigInteger(1, value);
                break;
            }
            case 96: {
                byte[] value = new byte[32];
                System.arraycopy(encoded, 0, value, 0, 32);
                d = new BigInteger(1, value);
                value = new byte[32];
                System.arraycopy(encoded, 32, value, 0, 32);
                x = new BigInteger(1, value);
                value = new byte[32];
                System.arraycopy(encoded, 64, value, 0, 32);
                y = new BigInteger(1, value);
                break;
            }
            default: {
                try {
                    AlgorithmIdentifier aid = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)new X962Parameters(DERNull.INSTANCE));
                    PrivateKeyInfo info = PrivateKeyInfo.getInstance(encoded);
                    if (!aid.equals(info.getPrivateKeyAlgorithm())) {
                        throw new SecurityException("encoded not valid");
                    }
                    ECPrivateKey key = ECPrivateKey.getInstance(info.parsePrivateKey());
                    d = key.getKey();
                    break;
                }
                catch (Exception e) {
                    throw new SecurityException("encoded not valid", e);
                }
            }
        }
        ECDomainParameters params = SM2Params.sm2DomainParameters;
        SM2PrivateKey sm2PrivateKey = new SM2PrivateKey(new ECPrivateKeyParameters(d, params));
        SM2PublicKey pubKey = null;
        if (x == null || y == null) {
            pubKey = SM2PrivateKey.buildPublicKey(d);
        } else {
            ECPoint Q = params.getCurve().createPoint(x, y).normalize();
            pubKey = new SM2PublicKey(new ECPublicKeyParameters(Q, params));
        }
        sm2PrivateKey.setSM2PublicKey(pubKey);
        return sm2PrivateKey;
    }

    public SM2PrivateKey(ECPrivateKeyParameters priParam) {
        if (priParam == null) {
            throw new IllegalArgumentException("null not allowed for priParam");
        }
        this.d = priParam.getD();
        this.dBytes = BigIntegers.asUnsignedByteArray(32, this.d);
        this.pubKey = SM2PrivateKey.buildPublicKey(this.d);
    }

    public byte[] getEncoded() {
        X962Parameters params = new X962Parameters(DERNull.INSTANCE);
        PrivateKeyInfo info = null;
        ECPrivateKey keyStructure = new ECPrivateKey(this.getD(), params);
        try {
            info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)params), keyStructure);
            return info.getEncoded("DER");
        }
        catch (Exception e) {
            throw new SecurityException("getEncoded Failure for SM2PrivateKey");
        }
    }

    public BigInteger getD() {
        return this.d;
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getD_Bytes() {
        return this.dBytes;
    }

    public void setSM2PublicKey(SM2PublicKey pubKey) {
        if (pubKey != null) {
            this.pubKey = pubKey;
        }
    }

    public SM2PublicKey getSM2PublicKey() {
        return this.pubKey;
    }

    private static SM2PublicKey buildPublicKey(BigInteger d) {
        ECDomainParameters params = SM2Params.sm2DomainParameters;
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        ECPoint Q = multiplier.multiply(params.getG(), d).normalize();
        return new SM2PublicKey(new ECPublicKeyParameters(Q, params));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.d == null ? 0 : this.d.hashCode());
        result = 31 * result + (this.pubKey == null ? 0 : this.pubKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SM2PrivateKey other = (SM2PrivateKey)obj;
        if (this.d == null ? other.d != null : !this.d.equals(other.d)) {
            return false;
        }
        return !(this.pubKey == null ? other.pubKey != null : !this.pubKey.equals(other.pubKey));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SM2PrivateKey [d=0x");
        buffer.append(this.d.toString(16));
        buffer.append("]");
        return buffer.toString();
    }
}

