/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2.signature;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.DERObjectIdentifier;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cfca.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.PublicKey;

public final class SM2PublicKey
implements PublicKey {
    private static final long serialVersionUID = -5142670102495411792L;
    private BigInteger pubX = null;
    private BigInteger pubY = null;
    private byte[] xBytes = null;
    private byte[] yBytes = null;
    private ECPoint Q = null;
    private byte[] zvalue = null;
    private boolean withCompression = false;

    public SM2PublicKey(byte[] encoded) {
        if (encoded == null) {
            throw new IllegalArgumentException("null not allowed for encoded");
        }
        byte[] coding = null;
        if (encoded.length != 64 && encoded.length != 65) {
            try {
                AlgorithmIdentifier aid = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)new DERObjectIdentifier("1.2.156.10197.1.301"));
                SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(encoded);
                if (!aid.equals(info.getAlgorithm())) {
                    throw new SecurityException("encoded not valid");
                }
                coding = info.getPublicKeyData().getBytes();
                if (coding.length != 65) {
                    throw new SecurityException("encoded not valid");
                }
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SecurityException("encoded not valid", e);
            }
        }
        int offset = encoded.length == 64 ? 0 : 1;
        this.xBytes = new byte[32];
        this.yBytes = new byte[32];
        System.arraycopy(coding, offset, this.xBytes, 0, this.xBytes.length);
        System.arraycopy(coding, offset += this.xBytes.length, this.yBytes, 0, this.yBytes.length);
        this.pubX = new BigInteger(1, this.xBytes);
        this.pubY = new BigInteger(1, this.yBytes);
        this.Q = SM2Params.sm2ParameterSpec.getCurve().createPoint(this.pubX, this.pubY).normalize();
        this.zvalue = SM2Params.calcZ(this.xBytes, this.yBytes);
    }

    public SM2PublicKey(ECPublicKeyParameters ecParam) {
        if (ecParam == null) {
            throw new IllegalArgumentException("null not allowed for ecParam");
        }
        this.Q = ecParam.getQ().normalize();
        this.pubX = this.Q.getAffineXCoord().toBigInteger();
        this.pubY = this.Q.getAffineYCoord().toBigInteger();
        this.xBytes = BigIntegers.asUnsignedByteArray(32, this.pubX);
        this.yBytes = BigIntegers.asUnsignedByteArray(32, this.pubY);
        this.zvalue = SM2Params.calcZ(this.xBytes, this.yBytes);
    }

    public byte[] getEncoded() {
        try {
            byte[] encoding = new byte[65];
            encoding[0] = 4;
            System.arraycopy(this.xBytes, 0, encoding, 1, this.xBytes.length);
            System.arraycopy(this.yBytes, 0, encoding, 33, this.yBytes.length);
            AlgorithmIdentifier aid = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)new DERObjectIdentifier("1.2.156.10197.1.301"));
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(aid, encoding);
            return info.getEncoded("DER");
        }
        catch (Exception ex) {
            throw new SecurityException("encoded failure for SM2PublicKey");
        }
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "X.509";
    }

    public ECPoint getQ() {
        return this.Q;
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    public byte[] getPubX() {
        return this.xBytes;
    }

    public void setPubX(byte[] pubX) {
        this.pubX = new BigInteger(1, pubX);
    }

    public byte[] getPubY() {
        return this.yBytes;
    }

    public void setPubY(byte[] pubY) {
        this.pubY = new BigInteger(1, pubY);
    }

    public BigInteger getPubX_Int() {
        return this.pubX;
    }

    public BigInteger getPubY_Int() {
        return this.pubY;
    }

    public boolean isWithCompression() {
        return this.withCompression;
    }

    public final byte[] getDefaultZ() {
        return this.zvalue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pubX == null ? 0 : this.pubX.hashCode());
        result = 31 * result + (this.pubY == null ? 0 : this.pubY.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SM2PublicKey other = (SM2PublicKey)obj;
        if (this.pubX == null ? other.pubX != null : !this.pubX.equals(other.pubX)) {
            return false;
        }
        return !(this.pubY == null ? other.pubY != null : !this.pubY.equals(other.pubY));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SM2PublicKey [");
        buffer.append("\nX=0x");
        buffer.append(this.pubX.toString(16));
        buffer.append("\nY=0x");
        buffer.append(this.pubY.toString(16));
        buffer.append("\nZ=0x");
        buffer.append(this.zvalue != null ? new BigInteger(1, this.zvalue).toString(16) : null);
        buffer.append("\n]");
        return buffer.toString();
    }

    public byte[] calcZ(byte[] userId) {
        return SM2Params.calcZ(this.xBytes, this.yBytes, userId);
    }
}

