/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2.signature;

import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.signature.sm2.SM2PackageUtil;
import cfca.sm.algorithm.SM3Digest;
import cfca.sm2.signature.SM2PrivateKey;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.PKIException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class SM2Signature {
    private boolean useJNI = false;
    private SM3Digest engine;
    private Key key;

    public SM2Signature(boolean useJNI) throws PKIException {
        this.useJNI = useJNI;
        this.engine = new SM3Digest();
    }

    public SM2Signature() throws PKIException {
        this(false);
    }

    public void initSign(PrivateKey privateKey) throws PKIException {
        if (!(privateKey instanceof SM2PrivateKey)) {
            throw new PKIException("Can't recognise key type in SM2 based signer");
        }
        this.key = (SM2PrivateKey)privateKey;
        this.engine.reset();
    }

    public void initVerify(PublicKey publicKey) throws PKIException {
        if (!(publicKey instanceof SM2PublicKey)) {
            throw new PKIException("Can't recognise key type in SM2 based signer");
        }
        this.key = (SM2PublicKey)publicKey;
        this.engine.reset();
    }

    public void update(byte b) throws PKIException {
        if (this.key == null) {
            throw new IllegalStateException("key not initialised");
        }
        this.engine.update(b);
    }

    public void update(byte[] data, int offset, int length) throws PKIException {
        if (this.key == null) {
            throw new IllegalStateException("key not initialised");
        }
        if (data != null) {
            this.engine.update(data, offset, length);
        }
    }

    public byte[] sign(byte[] data) throws PKIException {
        byte[] signature;
        this.update(data, 0, data.length);
        byte[] hash = new byte[32];
        this.engine.doFinal(hash, 0);
        try {
            if (this.useJNI) {
                byte[] d = ((SM2PrivateKey)this.key).getD_Bytes();
                signature = SM2PackageUtil.encryptByJNI(hash, d);
            } else {
                signature = SM2PackageUtil.encryptByBC(hash, this.key);
            }
        }
        catch (Exception e) {
            throw new PKIException("\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        return signature;
    }

    public boolean verify(byte[] signature, byte[] data) throws PKIException {
        boolean result;
        if (signature == null || signature.length < 64) {
            return false;
        }
        this.update(data, 0, data.length);
        byte[] signBytes = null;
        if (signature.length > 64) {
            ASN1SM2Signature sigVal = new ASN1SM2Signature(signature);
            signBytes = new byte[64];
            System.arraycopy(BigIntegers.asUnsignedByteArray(32, sigVal.getR().getValue()), 0, signBytes, 0, 32);
            System.arraycopy(BigIntegers.asUnsignedByteArray(32, sigVal.getS().getValue()), 0, signBytes, 32, 32);
        } else {
            signBytes = (byte[])signature.clone();
        }
        byte[] hash = new byte[32];
        this.engine.doFinal(hash, 0);
        try {
            if (this.useJNI) {
                SM2PublicKey publicKey = (SM2PublicKey)this.key;
                result = SM2PackageUtil.verifyByJNI(hash, signBytes, publicKey.getPubX(), publicKey.getPubY());
            } else {
                result = SM2PackageUtil.verifyByBC(hash, signBytes, this.key);
            }
        }
        catch (Exception e) {
            throw new PKIException("\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
        return result;
    }
}

