/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2rsa.common;

import cfca.org.bouncycastle.asn1.ASN1OutputStream;
import cfca.org.bouncycastle.asn1.ASN1Primitive;
import cfca.org.bouncycastle.asn1.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class PKCS7AttachSourceFile
extends ASN1Primitive {
    private File sourceFile;
    private long totalLength;

    public static PKCS7AttachSourceFile getInstance(Object obj) {
        if (obj != null && obj instanceof PKCS7AttachSourceFile) {
            return (PKCS7AttachSourceFile)obj;
        }
        return null;
    }

    public PKCS7AttachSourceFile() {
        throw new SecurityException("null not allowed for sourceFile");
    }

    public PKCS7AttachSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
        this.totalLength = sourceFile.length();
    }

    public int hashCode() {
        return 0;
    }

    public boolean isConstructed() {
        return false;
    }

    public long encodedLength() throws IOException {
        return (long)(1 + StreamUtil.calculateBodyLength(this.totalLength)) + this.totalLength;
    }

    public void encode(ASN1OutputStream out) {
        if (this.sourceFile == null) {
            throw new SecurityException("null not allowed for sourceFile");
        }
        FileInputStream fis = null;
        try {
            out.write(4);
            out.writeLength(this.totalLength);
            fis = new FileInputStream(this.sourceFile);
            byte[] buffer = new byte[8192];
            int rLength = 0;
            while ((rLength = fis.read(buffer)) != -1) {
                out.write(buffer, 0, rLength);
            }
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean asn1Equals(ASN1Primitive o) {
        return false;
    }
}

