/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2rsa.common;

import cfca.internal.tool.ASN1Parser;
import cfca.internal.tool.BigIntegerUtil;
import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.asn1.ASN1Integer;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.BERSet;
import cfca.org.bouncycastle.asn1.DERInteger;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.DERObjectIdentifier;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.DERSet;
import cfca.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.Certificate;
import cfca.sm2.signature.SM2SignerInfo;
import cfca.sm2.signature.SM2SignerInfo2;
import cfca.sm2.signature.SM2SignerInfox;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cfca.util.Base64;
import cfca.util.CertUtil;
import cfca.util.cipher.lib.Session;
import cfca.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Enumeration;

public class PKCS7SignedData {
    private Session session = null;
    private SignedData signedData = null;
    static final String pkcs_7 = "1.2.840.113549.1.7";
    public static final String DATA = new DERObjectIdentifier("1.2.840.113549.1.7.1").getId();
    public static final String SIGNED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.2").getId();
    public static final String ENVELOPED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.3").getId();
    public static final String SIGNED_ENVELOPED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.4").getId();
    public static final String DIGESTED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.5").getId();
    public static final String ENCRYPTED_DATA = new DERObjectIdentifier("1.2.840.113549.1.7.6").getId();

    public PKCS7SignedData(Session session) {
        this.session = session;
    }

    public final byte[] packageSM2SignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] encryptedData, X509Cert[] certs) throws Exception {
        if (certs == null) {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        if (encryptedData == null || encryptedData.length != 64) {
            throw new Exception("the encrypt data is null or not 64 bytes!");
        }
        byte[] r = null;
        byte[] s = null;
        if ((encryptedData[0] & 0x80) != 0) {
            r = new byte[33];
            r[0] = 0;
            System.arraycopy(encryptedData, 0, r, 1, 32);
        } else {
            r = new byte[32];
            System.arraycopy(encryptedData, 0, r, 0, 32);
        }
        if ((encryptedData[32] & 0x80) != 0) {
            s = new byte[33];
            s[0] = 0;
            System.arraycopy(encryptedData, 32, s, 1, 32);
        } else {
            s = new byte[32];
            System.arraycopy(encryptedData, 32, s, 0, 32);
        }
        DERInteger derR = new DERInteger(r);
        DERInteger derS = new DERInteger(s);
        BigInteger sn = certs[0].getSerialNumber();
        X500Name issuer = certs[0].getIssuerX500Name();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
        AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.SM2_sign, (ASN1Encodable)new DERNull());
        AlgorithmIdentifier digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm3, (ASN1Encodable)new DERNull());
        SM2SignerInfox signerInfo = null;
        signerInfo = this.isNewFormat() ? new SM2SignerInfo2(new ASN1Integer(1), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null) : new SM2SignerInfo(new ASN1Integer(1), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null);
        ContentInfo contentInfo = null;
        if (ifAttach) {
            DEROctetString derSourceData = new DEROctetString(sourceData);
            contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.sm2Data, derSourceData) : new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
        } else {
            contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.sm2Data, null) : new ContentInfo(new ASN1ObjectIdentifier(contentType), null);
        }
        ASN1EncodableVector derV = new ASN1EncodableVector();
        derV.add(digestAlgIdentifier);
        DERSet digestAlgorithmSets = new DERSet(derV);
        derV = new ASN1EncodableVector();
        derV.add(signerInfo);
        DERSet signerInfos = new DERSet(derV);
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < certs.length; ++i) {
            Certificate certStruc = certs[i].getCertStructure();
            v.add(certStruc);
        }
        BERSet setCert = new BERSet(v);
        SignedData signedData = new SignedData(new ASN1Integer(1), digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
        ContentInfo contentInfoTemp = new ContentInfo(PKCSObjectIdentifiers.sm2SignedData, signedData);
        return ASN1Parser.writeDERObj2Bytes(contentInfoTemp);
    }

    public byte[] packageSignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] encryptData, Mechanism digestAlgorithm, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
            }
            if (CertUtil.isSM2Cert(certs[0])) {
                return this.packageSM2SignedData(ifAttach, contentType, sourceData, encryptData, certs);
            }
            return this.packageRSASignedData(ifAttach, contentType, sourceData, encryptData, digestAlgorithm, certs);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public void loadDer(byte[] data) throws PKIException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        this.load(bis);
    }

    public void loadBase64(byte[] data) throws PKIException {
        byte[] tmpData = ASN1Parser.convertBase64(data);
        tmpData = Base64.decode(tmpData);
        ByteArrayInputStream bis = new ByteArrayInputStream(tmpData);
        this.load(bis);
    }

    private void load(InputStream ins) throws PKIException {
        ASN1InputStream ais = new ASN1InputStream(ins);
        SignedData sd = null;
        try {
            ASN1Sequence seq = (ASN1Sequence)ais.readObject();
            ContentInfo contentInfo = ContentInfo.getInstance(seq);
            sd = SignedData.getInstance(contentInfo.getContent());
            ins.close();
            ais.close();
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u89e3\u6790PKCS7\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", ex);
        }
        this.signedData = sd;
    }

    public boolean verifyP7SignedDataAttach() throws PKIException {
        byte[] sourceData = this.getSourceData();
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfo((byte[])sourceData.clone(), true, null, aset, null);
        }
        return this.verifySignerInfo((byte[])sourceData.clone(), aset, null);
    }

    public byte[] getSourceData() throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.sm2Data)) {
            if (contentInfo.getContent() == null) {
                throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", new Exception("no sourceData to be verify."));
            }
            sourceData = ((ASN1OctetString)contentInfo.getContent()).getOctets();
        } else {
            sourceData = ASN1Parser.writeDERObj2Bytes(contentInfo.getContent().toASN1Primitive());
        }
        return (byte[])sourceData.clone();
    }

    private boolean verifySignerInfoByFile(String sourceFilePath, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                Mechanism signM = null;
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("MD5withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = new Mechanism("SHA1withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                    signM = new Mechanism("SHA256withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                    signM = new Mechanism("SHA512withRSA");
                } else {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                return this.session.verifySign(signM, pubKey, sourceFilePath, signature);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    private boolean verifySignerInfo(byte[] content, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                Mechanism signM = null;
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("MD5withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = new Mechanism("SHA1withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                    signM = new Mechanism("SHA256withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                    signM = new Mechanism("SHA512withRSA");
                } else {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                if (authAttributes != null) {
                    byte[] bAuthAttries = ASN1Parser.writeDERObj2Bytes(authAttributes);
                    return this.session.verifySign(signM, pubKey, bAuthAttries, signature);
                }
                return this.session.verifySign(signM, pubKey, content, signature);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    private boolean verifySM2SignerInfoByFile(String sourceFilePath, boolean ifZValue, byte[] userId, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            SM2SignerInfox signerInfo = null;
            if (signerEnumer.hasMoreElements()) {
                signerInfo = this.isNewFormat() ? SM2SignerInfo2.getInstance(signerEnumer.nextElement()) : SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                return this.session.verifySign(new Mechanism("SM3withSM2"), pubKey, sourceFilePath, signature);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException("8506204", "\u9a8c\u8bc1SM2\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    private boolean verifySM2SignerInfo(byte[] content, boolean ifZValue, byte[] userId, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            SM2SignerInfox signerInfo = null;
            if (signerEnumer.hasMoreElements()) {
                byte[] signature;
                signerInfo = this.isNewFormat() ? SM2SignerInfo2.getInstance(signerEnumer.nextElement()) : SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signatureAsBytes = signerInfo.getSignatureAsBytes();
                if (128 != signatureAsBytes.length) {
                    byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                    byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                    signature = new byte[64];
                    System.arraycopy(r, 0, signature, 0, 32);
                    System.arraycopy(s, 0, signature, 32, 32);
                } else {
                    signature = (byte[])signatureAsBytes.clone();
                }
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                if (authAttributes != null) {
                    byte[] bAuthAttries = ASN1Parser.writeDERObj2Bytes(authAttributes);
                    return this.session.verifySign(new Mechanism("SM3withSM2"), pubKey, bAuthAttries, signature);
                }
                return this.session.verifySign(new Mechanism("SM3withSM2"), pubKey, content, signature);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException("8506204", "\u9a8c\u8bc1SM2\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    private boolean isSM2Cert() {
        ASN1Set certSet = this.signedData.getCertificates();
        Certificate certStru = Certificate.getInstance(certSet.getObjectAt(0));
        return CertUtil.isSM2Cert(new X509Cert(certStru));
    }

    private X509Cert[] getSignerCerts() throws PKIException {
        ASN1Set certSet = this.signedData.getCertificates();
        X509Cert[] signerCerts = new X509Cert[certSet.size()];
        for (int i = 0; i < certSet.size(); ++i) {
            Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
            signerCerts[i] = new X509Cert(certStru);
        }
        return signerCerts;
    }

    public X509Cert getSignerX509Cert() throws PKIException {
        X509Cert signerCerts = null;
        ASN1Set certSet = this.signedData.getCertificates();
        Certificate certStru = Certificate.getInstance(certSet.getObjectAt(0));
        signerCerts = new X509Cert(certStru);
        return signerCerts;
    }

    private X509Cert getSignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        for (int i = 0; i < certs.length; ++i) {
            X500Name tmpIssuer = certs[i].getIssuerX500Name();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (!tmpIssuer.toString().equals(issuer) || tmpSN.compareTo(sn) != 0) continue;
            return certs[i];
        }
        return null;
    }

    private X509Cert getSM2SignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        for (int i = 0; i < certs.length; ++i) {
            X500Name tmpIssuer = certs[i].getIssuerX500Name();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (!tmpIssuer.toString().equals(issuer) || tmpSN.compareTo(sn) != 0) continue;
            return certs[i];
        }
        return null;
    }

    public boolean verifyP7SignedData(String sourceDataFilePath) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfoByFile(sourceDataFilePath, true, null, aset, null);
        }
        return this.verifySignerInfoByFile(sourceDataFilePath, aset, null);
    }

    public boolean verifyP7SignedData(byte[] sourceData) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfo(sourceData, true, null, aset, null);
        }
        return this.verifySignerInfo(sourceData, aset, null);
    }

    private byte[] getSM2Signature() throws PKIException {
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        if (signerEnumer.hasMoreElements()) {
            SM2SignerInfox signerInfo = null;
            signerInfo = this.isNewFormat() ? SM2SignerInfo2.getInstance(signerEnumer.nextElement()) : SM2SignerInfo.getInstance(signerEnumer.nextElement());
            byte[] signature = signerInfo.getSignatureAsBytes();
            if (signature != null && signature.length == 128) {
                return signature;
            }
            byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
            byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
            signature = new byte[64];
            System.arraycopy(r, 0, signature, 0, 32);
            System.arraycopy(s, 0, signature, 32, 32);
            return signature;
        }
        throw new PKIException("can not get SM2SignerInfo object!!!");
    }

    public byte[] getSignature() throws PKIException {
        if (this.isSM2Cert()) {
            return this.getSM2Signature();
        }
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        if (signerEnumer.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            return signerInfo.getEncryptedDigest().getOctets();
        }
        throw new PKIException("can not get SignerInfo object!!!");
    }

    public String getDigestAlgorithm() throws PKIException {
        if (this.isSM2Cert()) {
            return "SM3";
        }
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        String signM = null;
        if (signerEnumer.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
            if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                signM = "MD5";
            } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                signM = "SHA1";
            } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                signM = "SHA256";
            } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                signM = "SHA512";
            } else {
                throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
            }
            return signM;
        }
        throw new PKIException("can not get SignerInfo object!!!");
    }

    public boolean verifySM2SignedData(String sourceFilePath, boolean ifZValue, byte[] userId) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (ifZValue) {
            if (userId != null) {
                return this.verifySM2SignerInfoByFile(sourceFilePath, true, (byte[])userId.clone(), aset, null);
            }
            return this.verifySM2SignerInfoByFile(sourceFilePath, true, null, aset, null);
        }
        return this.verifySM2SignerInfoByFile(sourceFilePath, false, null, aset, null);
    }

    public boolean verifySM2SignedData(byte[] sourceData, boolean ifZValue, byte[] userId) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (ifZValue) {
            if (userId != null) {
                return this.verifySM2SignerInfo((byte[])sourceData.clone(), true, (byte[])userId.clone(), aset, null);
            }
            return this.verifySM2SignerInfo((byte[])sourceData.clone(), true, null, aset, null);
        }
        return this.verifySM2SignerInfo((byte[])sourceData.clone(), false, null, aset, null);
    }

    public byte[] packageRSASignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] encryptData, Mechanism mechanism, X509Cert[] certs) throws PKIException {
        if (certs == null) {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        DEROctetString encryptedData = new DEROctetString(encryptData);
        BigInteger sn = certs[0].getSerialNumber();
        X500Name issuer = certs[0].getIssuerX500Name();
        IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
        AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)new DERNull());
        AlgorithmIdentifier digestAlgIdentifier = null;
        String digestAlgorithm = mechanism.getMechanismType();
        if (digestAlgorithm.equals("MD5") || digestAlgorithm.equals("MD5withRSAEncryption")) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, (ASN1Encodable)new DERNull());
        } else if (digestAlgorithm.equals("SHA1") || digestAlgorithm.equals("SHA1withRSAEncryption")) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, (ASN1Encodable)new DERNull());
        } else if (digestAlgorithm.equals("SHA256") || digestAlgorithm.equals("SHA256withRSAEncryption")) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256, (ASN1Encodable)new DERNull());
        } else if (digestAlgorithm.equals("SHA512") || digestAlgorithm.equals("SHA512withRSA")) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512, (ASN1Encodable)new DERNull());
        }
        SignerInfo signerInfo = new SignerInfo(new ASN1Integer(1), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, encryptedData, null);
        ContentInfo contentInfo = null;
        if (ifAttach) {
            DEROctetString derSourceData = new DEROctetString(sourceData);
            contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data, derSourceData) : new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
        } else {
            contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data, null) : new ContentInfo(new ASN1ObjectIdentifier(contentType), null);
        }
        ASN1EncodableVector derV = new ASN1EncodableVector();
        derV.add(digestAlgIdentifier);
        BERSet digestAlgorithmSets = new BERSet(derV);
        derV = new ASN1EncodableVector();
        derV.add(signerInfo);
        DERSet signerInfos = new DERSet(derV);
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < certs.length; ++i) {
            Certificate certStruc = certs[i].getCertStructure();
            v.add(certStruc);
        }
        BERSet setCert = new BERSet(v);
        SignedData signedData = new SignedData(new ASN1Integer(1), digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
        ContentInfo contentInfoTemp = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
        return ASN1Parser.writeDERObj2Bytes(contentInfoTemp);
    }

    public boolean verifyP7SignedDataByHash(byte[] digest) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfoByHash(digest, aset, null);
        }
        return this.verifySignerInfoByHash(digest, aset, null);
    }

    private boolean verifySignerInfoByHash(byte[] digest, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            Enumeration signerEnumer;
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            if ((signerEnumer = signerInfos.getObjects()).hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                Mechanism signM = null;
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = new Mechanism("MD5withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = new Mechanism("SHA1withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                    signM = new Mechanism("SHA256withRSAEncryption");
                } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                    signM = new Mechanism("SHA512withRSA");
                } else {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                return this.session.verifyByHash(signM, pubKey, digest, signature);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    private boolean verifySM2SignerInfoByHash(byte[] digest, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            SM2SignerInfox signerInfo = null;
            if (signerEnumer.hasMoreElements()) {
                signerInfo = this.isNewFormat() ? SM2SignerInfo2.getInstance(signerEnumer.nextElement()) : SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                return this.session.verifyByHash(new Mechanism("SM3withSM2"), pubKey, digest, signature);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException("8506204", "\u9a8c\u8bc1SM2\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    boolean isNewFormat() {
        return false;
    }
}

