/*
 * Decompiled with CFR 0.152.
 */
package cfca.sm2rsa.common;

import cfca.asn1.parser.ASN1Node;
import cfca.asn1.parser.PKCS7SignFileParser;
import cfca.internal.tool.BigIntegerUtil;
import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.org.bouncycastle.asn1.ASN1Integer;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.BERSet;
import cfca.org.bouncycastle.asn1.DERInteger;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.DEROutputStream;
import cfca.org.bouncycastle.asn1.DERSet;
import cfca.org.bouncycastle.asn1.DERTaggedObject;
import cfca.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.Certificate;
import cfca.rsa.signature.RSASignUtil;
import cfca.sadk.signature.sm2.SM2PackageUtil;
import cfca.sm2.signature.SM2HashUtil;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2.signature.SM2SignerInfo;
import cfca.sm2.signature.SM2SignerInfo2;
import cfca.sm2.signature.SM2SignerInfox;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKCS7AttachSourceFile;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cfca.util.CertUtil;
import cfca.util.cipher.lib.JNISoftLib;
import cfca.util.cipher.lib.Session;
import cfca.x509.certificate.X509Cert;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Enumeration;

public class PKCS7SignedFile {
    private String digestAlgorithm;
    private byte[] signature;
    private byte[] sourceData;
    private X509Cert signerCert;
    private Session session = null;

    public PKCS7SignedFile(Session session) {
        this.session = session;
    }

    private X509Cert getSignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        if (certs == null) {
            throw new IllegalArgumentException("null not allowed for certs");
        }
        if (issuerAndSN == null) {
            throw new IllegalArgumentException("null not allowed for issuerAndSN");
        }
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        X500Name certIssuer = null;
        BigInteger certSN = null;
        for (int i = 0; i < certs.length; ++i) {
            if (certs[i] == null) continue;
            certIssuer = certs[i].getIssuerX500Name();
            certSN = certs[i].getSerialNumber();
            if (!certIssuer.toString().equals(issuer) || certSN.compareTo(sn) != 0) continue;
            return certs[i];
        }
        return null;
    }

    public final boolean verifyP7SignedFile(String signFile, String saveSrcFilePath) throws Exception {
        if (signFile == null) {
            throw new IllegalArgumentException("null not allowed for signFile");
        }
        PKCS7SignFileParser parser = new PKCS7SignFileParser(new File(signFile));
        parser.parser();
        ASN1Node certificate_node = parser.getCertificate_node();
        ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
        if (CertUtil.isSM2Cert(new X509Cert(Certificate.getInstance(certSet.getObjectAt(0))))) {
            return this.verifySM2P7SignedFile(signFile, saveSrcFilePath, true, null, parser);
        }
        return this.verifyRSAP7SignedFile(signFile, saveSrcFilePath, parser);
    }

    private boolean verifySM2P7SignedFile(String signFile, String saveSrcFilePath, boolean ifZValue, byte[] userId, PKCS7SignFileParser parser) throws Exception {
        try {
            ASN1Node sourceData_node = (ASN1Node)((ASN1Node)parser.getSourceData_node().childNodes.get((int)1)).childNodes.get(0);
            if (sourceData_node.childNodes.size() == 1) {
                sourceData_node = (ASN1Node)sourceData_node.childNodes.get(0);
            }
            ASN1Node certificate_node = parser.getCertificate_node();
            ASN1Node singerinfo_node = parser.getSingerinfo_node();
            ASN1Set signerInfos = ASN1Set.getInstance(singerinfo_node.getData());
            ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
            X509Cert[] certs = new X509Cert[certSet.size()];
            for (int i = 0; i < certSet.size(); ++i) {
                Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
                certs[i] = new X509Cert(certStru);
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            SM2SignerInfox signerInfo = null;
            if (signerEnumer.hasMoreElements()) {
                X509Cert signerCert;
                signerInfo = this.isNewFormat() ? SM2SignerInfo2.getInstance(signerEnumer.nextElement()) : SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                this.signerCert = signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                this.digestAlgorithm = "SM3";
                this.signature = signature;
                this.sourceData = "source file is too big, will not display,please see the sourceFilePath attribute".getBytes("UTF8");
                byte[] hash = null;
                long valueStartPos = sourceData_node.valueStartPos;
                long valueLength = sourceData_node.valueLength;
                hash = ifZValue ? SM2HashUtil.hashFile(true, userId, sourceData_node.f.getAbsolutePath(), valueStartPos, valueLength, pubKey, saveSrcFilePath, this.session) : SM2HashUtil.hashFile(false, null, sourceData_node.f.getAbsolutePath(), valueStartPos, valueLength, null, saveSrcFilePath, this.session);
                if (this.session instanceof JNISoftLib) {
                    SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                    byte[] pubX = sm2PubKey.getPubX();
                    byte[] pubY = sm2PubKey.getPubY();
                    return SM2PackageUtil.verifyByJNI(hash, signature, pubX, pubY);
                }
                return SM2PackageUtil.verifyByBC(hash, signature, pubKey);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    private boolean verifyRSAP7SignedFile(String signFile, String saveSrcFilePath, PKCS7SignFileParser parser) throws Exception {
        try {
            ASN1Node sourceData_node = (ASN1Node)((ASN1Node)parser.getSourceData_node().childNodes.get((int)1)).childNodes.get(0);
            if (sourceData_node.childNodes.size() == 1) {
                sourceData_node = (ASN1Node)sourceData_node.childNodes.get(0);
            }
            ASN1Node certificate_node = parser.getCertificate_node();
            ASN1Node singerinfo_node = parser.getSingerinfo_node();
            ASN1Set signerInfos = ASN1Set.getInstance(singerinfo_node.getData());
            ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
            X509Cert[] certs = new X509Cert[certSet.size()];
            for (int i = 0; i < certSet.size(); ++i) {
                Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
                certs[i] = new X509Cert(certStru);
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            if (signerEnumer.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException("850649", "\u9a8c\u8bc1\u7b7e\u540d\u65f6\uff0c\u7b7e\u540d\u6570\u636e\u4e2d\u7f3a\u5c11\u7b7e\u540d\u8005\u8bc1\u4e66");
                }
                this.signerCert = signerCert;
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                String signM = null;
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                if (digestId.equals(PKCSObjectIdentifiers.md5)) {
                    signM = "MD5";
                } else if (digestId.equals(PKCSObjectIdentifiers.sha1)) {
                    signM = "SHA1";
                } else if (digestId.equals(PKCSObjectIdentifiers.sha256)) {
                    signM = "SHA256";
                } else if (digestId.equals(PKCSObjectIdentifiers.sha512)) {
                    signM = "SHA512";
                } else {
                    throw new PKIException("850629", "\u89e3\u6790\u6570\u5b57\u7b7e\u540d\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301");
                }
                this.digestAlgorithm = signM;
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                this.signature = signature;
                this.sourceData = "source file is too big, will not display".getBytes("UTF8");
                return RSASignUtil.verifySignFile(signM, pubKey, sourceData_node.f.getAbsolutePath(), sourceData_node.valueStartPos, sourceData_node.valueLength, signature, saveSrcFilePath);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25", ex);
        }
    }

    public final void packageRSASignedFile(String contentType, String sourceFile, String signFile, byte[] signature, Mechanism mechanism, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
            }
            DEROctetString encryptedData = new DEROctetString(signature);
            BigInteger sn = certs[0].getSerialNumber();
            X500Name issuer = certs[0].getIssuerX500Name();
            IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
            AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)new DERNull());
            AlgorithmIdentifier digestAlgIdentifier = null;
            String digestAlgorithm = mechanism.getMechanismType();
            if (digestAlgorithm.equals("MD5withRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5, (ASN1Encodable)new DERNull());
            } else if (digestAlgorithm.equals("SHA1withRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, (ASN1Encodable)new DERNull());
            } else if (digestAlgorithm.equals("SHA256withRSAEncryption")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256, (ASN1Encodable)new DERNull());
            } else if (digestAlgorithm.equals("SHA512withRSA")) {
                digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512, (ASN1Encodable)new DERNull());
            }
            SignerInfo signerInfo = new SignerInfo(new ASN1Integer(1), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, encryptedData, null);
            ContentInfo contentInfo = null;
            PKCS7AttachSourceFile derSourceData = new PKCS7AttachSourceFile(new File(sourceFile));
            contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.data, derSourceData) : new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
            ASN1EncodableVector derV = new ASN1EncodableVector();
            derV.add(digestAlgIdentifier);
            BERSet digestAlgorithmSets = new BERSet(derV);
            derV = new ASN1EncodableVector();
            derV.add(signerInfo);
            DERSet signerInfos = new DERSet(derV);
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i < certs.length; ++i) {
                Certificate certStruc = certs[i].getCertStructure();
                v.add(certStruc);
            }
            BERSet setCert = new BERSet(v);
            SignedData signedData = new SignedData(new ASN1Integer(1), digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
            ContentInfo contentInfoTemp = new ContentInfo(PKCSObjectIdentifiers.signedData, signedData);
            File sign_file = new File(signFile);
            if (!sign_file.exists()) {
                sign_file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(signFile);
            DEROutputStream dos = new DEROutputStream(fos);
            dos.writeObject(contentInfoTemp);
            dos.close();
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public final void packageSM2SignedFile(String contentType, String sourceFile, String signFile, byte[] signature, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
            }
            byte[] r = null;
            byte[] s = null;
            if ((signature[0] & 0x80) != 0) {
                r = new byte[33];
                r[0] = 0;
                System.arraycopy(signature, 0, r, 1, 32);
            } else {
                r = new byte[32];
                System.arraycopy(signature, 0, r, 0, 32);
            }
            if ((signature[32] & 0x80) != 0) {
                s = new byte[33];
                s[0] = 0;
                System.arraycopy(signature, 32, s, 1, 32);
            } else {
                s = new byte[32];
                System.arraycopy(signature, 32, s, 0, 32);
            }
            DERInteger derR = new DERInteger(r);
            DERInteger derS = new DERInteger(s);
            BigInteger sn = certs[0].getSerialNumber();
            X500Name issuer = certs[0].getIssuerX500Name();
            IssuerAndSerialNumber issuerAndSn = new IssuerAndSerialNumber(issuer, sn);
            AlgorithmIdentifier digestEncryptAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.SM2_sign, (ASN1Encodable)new DERNull());
            AlgorithmIdentifier digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sm3, (ASN1Encodable)new DERNull());
            SM2SignerInfox signerInfo = null;
            signerInfo = this.isNewFormat() ? new SM2SignerInfo2(new ASN1Integer(1), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null) : new SM2SignerInfo(new ASN1Integer(1), issuerAndSn, digestAlgIdentifier, null, digestEncryptAlgIdentifier, ASN1Integer.getInstance(derR), ASN1Integer.getInstance(derS), null);
            ContentInfo contentInfo = null;
            PKCS7AttachSourceFile derSourceData = new PKCS7AttachSourceFile(new File(sourceFile));
            contentInfo = contentType == null ? new ContentInfo(PKCSObjectIdentifiers.sm2Data, derSourceData) : new ContentInfo(new ASN1ObjectIdentifier(contentType), derSourceData);
            ASN1EncodableVector derV = new ASN1EncodableVector();
            derV.add(digestAlgIdentifier);
            DERSet digestAlgorithmSets = new DERSet(derV);
            derV = new ASN1EncodableVector();
            derV.add(signerInfo);
            DERSet signerInfos = new DERSet(derV);
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i < certs.length; ++i) {
                Certificate certStruc = certs[i].getCertStructure();
                v.add(certStruc);
            }
            BERSet setCert = new BERSet(v);
            SignedData signedData = new SignedData(new ASN1Integer(1), digestAlgorithmSets, contentInfo, setCert, null, signerInfos);
            ContentInfo contentInfoTemp = new ContentInfo(PKCSObjectIdentifiers.sm2SignedData, signedData);
            File sign_file = new File(signFile);
            if (!sign_file.exists()) {
                sign_file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(signFile);
            DEROutputStream dos = new DEROutputStream(fos);
            dos.writeObject(contentInfoTemp);
            dos.close();
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public final void packageSignedFile(String contentType, String sourceFilePath, String signFile, byte[] signture, Mechanism mechanism, X509Cert[] certs) throws PKIException {
        if (certs == null) {
            throw new PKIException("850615", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\uff0c\u8bc1\u4e66\u96c6\u5408\u4e3a\u7a7a");
        }
        if (CertUtil.isSM2Cert(certs[0])) {
            this.packageSM2SignedFile(contentType, sourceFilePath, signFile, signture, certs);
        } else {
            this.packageRSASignedFile(contentType, sourceFilePath, signFile, signture, mechanism, certs);
        }
    }

    public final String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public final byte[] getSignature() {
        return this.signature;
    }

    public final byte[] getSourceData() {
        return this.sourceData;
    }

    public final X509Cert getSignerX509Cert() {
        return this.signerCert;
    }

    boolean isNewFormat() {
        return false;
    }
}

