/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.internal.tool.ASN1Parser;
import cfca.internal.tool.FileUtil;
import cfca.internal.tool.InitKeyStore;
import cfca.internal.tool.P7b;
import cfca.internal.tool.PKCS12;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.x509.BasicConstraints;
import cfca.sm.algorithm.SM2Pfx;
import cfca.sm2rsa.common.PKCS7SignedData2;
import cfca.sm2rsa.common.PKIException;
import cfca.sm2rsa.common.X9ObjectIdentifiers;
import cfca.util.Base64;
import cfca.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;

public class CertUtil {
    public static byte[] getCertExtensionData(X509Cert cert, String oid) throws PKIException {
        if (cert == null) {
            throw new IllegalArgumentException("null not allowed for cert");
        }
        if (oid == null) {
            throw new IllegalArgumentException("null not allowed for oid");
        }
        try {
            byte[] extension = cert.getExtensionByteData(new ASN1ObjectIdentifier(oid));
            if (extension == null) {
                return null;
            }
            byte b = extension[1];
            int blen = b & 0x80;
            if (blen == 0) {
                byte[] ret = new byte[extension.length - 2];
                System.arraycopy(extension, 2, ret, 0, extension.length - 2);
                return ret;
            }
            blen = b & 0x7F;
            byte[] ret = new byte[extension.length - 2 - blen];
            System.arraycopy(extension, 2 + blen, ret, 0, extension.length - 2 - blen);
            return ret;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static X509Cert getCertFromSM2(String sm2Path) throws PKIException {
        if (sm2Path == null) {
            throw new IllegalArgumentException("null not allowed for sm2Path");
        }
        FilterInputStream asn1InputStream = null;
        try {
            FileInputStream fis = new FileInputStream(sm2Path);
            byte[] data = new byte[fis.available()];
            fis.read(data);
            fis.close();
            boolean isB64 = ASN1Parser.isBase64Encode(data);
            if (isB64) {
                data = ASN1Parser.convertBase64(data);
                data = Base64.decode(data);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            asn1InputStream = new ASN1InputStream(bis);
            SM2Pfx object = SM2Pfx.getInstance(((ASN1InputStream)asn1InputStream).readObject());
            X509Cert x509Cert = object.getPublicCert();
            return x509Cert;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (asn1InputStream != null) {
                try {
                    asn1InputStream.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public static X509Cert getCertFromPfx(String pfxPath, String pfxPWD) throws PKIException {
        if (pfxPath == null) {
            throw new IllegalArgumentException("null not allowed for pfxPath");
        }
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(pfxPath);
        pkcs12.decrypt(pfxPWD.toCharArray());
        return pkcs12.getCerts()[0];
    }

    public static X509Cert getCertFromPfx(byte[] pfxData, String pfxPWD) throws PKIException {
        if (pfxData == null) {
            throw new IllegalArgumentException("null not allowed for pfxData");
        }
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(pfxData);
        pkcs12.decrypt(pfxPWD.toCharArray());
        return pkcs12.getCerts()[0];
    }

    public static X509Cert getCertFromPfx(InputStream inputStream, String pfxPWD) throws PKIException {
        if (inputStream == null) {
            throw new IllegalArgumentException("null not allowed for inputStream");
        }
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(inputStream);
        pkcs12.decrypt(pfxPWD.toCharArray());
        return pkcs12.getCerts()[0];
    }

    public static X509Cert getCertFromJks(String jksFilePath, String jksPWD, String alias) throws PKIException {
        if (jksFilePath == null) {
            throw new IllegalArgumentException("null not allowed for jksFilePath");
        }
        if (alias == null) {
            throw new IllegalArgumentException("null not allowed for alias");
        }
        try {
            KeyStore keyStore = InitKeyStore.initJKSKeyStore(jksFilePath, jksPWD);
            Certificate certificate = keyStore.getCertificate(alias);
            if (certificate != null) {
                return new X509Cert(certificate.getEncoded());
            }
            throw new PKIException("no such alias cert!");
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static X509Cert[] parseP7b(String filePath) throws PKIException {
        if (filePath == null) {
            throw new IllegalArgumentException("null not allowed for filePath");
        }
        try {
            return P7b.parseP7b(FileUtil.getBytesFromFile(filePath));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static X509Cert[] parseP7b(byte[] p7bData) throws PKIException {
        if (p7bData == null) {
            throw new IllegalArgumentException("null not allowed for p7bData");
        }
        try {
            return P7b.parseP7b(p7bData);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void generateP7bFile(X509Cert[] certs, String saveFilePath) throws PKIException {
        if (certs == null) {
            throw new IllegalArgumentException("null not allowed for certs");
        }
        try {
            P7b.generateP7bFile(certs, saveFilePath);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static boolean isSM2Cert(X509Cert cert) {
        return cert != null && cert.getCertStructure().getSignatureAlgorithm().getAlgorithm().equals(X9ObjectIdentifiers.sm3_with_SM2);
    }

    public static boolean isCACert(X509Cert cert) throws PKIException {
        BasicConstraints bcs;
        boolean isCA = false;
        if (cert != null && (bcs = cert.getBasicConstraints()) != null) {
            isCA = bcs.isCA();
        }
        return isCA;
    }

    public static X509Cert getSignerCertFromP7SignData(byte[] p7SignData) throws PKIException {
        if (p7SignData == null) {
            throw new IllegalArgumentException("null not allowed for p7SignData");
        }
        PKCS7SignedData2 pkcs7SignedData = new PKCS7SignedData2(null);
        pkcs7SignedData.loadBase64(p7SignData);
        return pkcs7SignedData.getSignerX509Cert();
    }
}

