/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.org.bouncycastle.crypto.BlockCipher;
import cfca.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.rsa.envelope.RSASymmetricCryptoUtil;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.GlobalVariable;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKIException;
import cfca.util.Base64;
import cfca.util.cipher.lib.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;

public class EncryptUtil {
    private static boolean isHex(String str) {
        if (str == null) {
            return false;
        }
        String lowStr = str.toLowerCase();
        int len = lowStr.length();
        for (int i = 0; i < len; ++i) {
            if (lowStr.charAt(i) >= '0' && lowStr.charAt(i) <= '9' || lowStr.charAt(i) >= 'a' && lowStr.charAt(i) <= 'f') continue;
            return false;
        }
        return true;
    }

    private static byte[] hexToByte(String hex) throws UnsupportedEncodingException {
        byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        byte[] decodingTable = new byte[128];
        for (int i = 0; i < encodingTable.length; ++i) {
            decodingTable[encodingTable[i]] = (byte)i;
        }
        decodingTable[65] = decodingTable[97];
        decodingTable[66] = decodingTable[98];
        decodingTable[67] = decodingTable[99];
        decodingTable[68] = decodingTable[100];
        decodingTable[69] = decodingTable[101];
        decodingTable[70] = decodingTable[102];
        int len = hex.length();
        byte[] hex_byte = hex.getBytes("UTF-8");
        int retLen = len / 2;
        byte[] ret = new byte[retLen];
        int j = 0;
        for (int i = 0; i < len; i += 2) {
            ret[j] = decodingTable[hex_byte[i]];
            ret[j] = (byte)(ret[j] << 4 | decodingTable[hex_byte[i + 1]]);
            ++j;
        }
        return ret;
    }

    private static byte[] doWithPwd(byte[] data, String pwd, boolean encryptFlag) throws Exception {
        byte[] ivKey = EncryptUtil.hexToByte(pwd);
        Mechanism algName = new Mechanism("DESede/CBC/PKCS7Padding");
        byte[] iv = new byte[8];
        byte[] key = new byte[24];
        System.arraycopy(ivKey, 0, iv, 0, 8);
        System.arraycopy(ivKey, 8, key, 0, 24);
        CBCParam param = new CBCParam(iv);
        algName.setParam(param);
        if (encryptFlag) {
            return RSASymmetricCryptoUtil.encrypt(key, data, algName);
        }
        return RSASymmetricCryptoUtil.decrypt(key, data, algName);
    }

    public static String encryptMessageByPwd_3DES(String sourceData, String pwd) throws PKIException {
        if (EncryptUtil.isHex(pwd) && pwd.length() == 64) {
            try {
                byte[] sourceData_utf8 = sourceData.getBytes("UTF-8");
                byte[] encryptData = EncryptUtil.doWithPwd(sourceData_utf8, pwd, true);
                return new String(Base64.encode(encryptData), "UTF-8");
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static String decryptMessageByPwd_3DES(String encryptData, String pwd) throws PKIException {
        if (EncryptUtil.isHex(pwd) && pwd.length() == 64) {
            try {
                byte[] encryptData_utf8 = Base64.decode(encryptData.getBytes("UTF-8"));
                byte[] sourceData = EncryptUtil.doWithPwd(encryptData_utf8, pwd, false);
                return new String(sourceData, "UTF-8");
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static void encryptFileByPwd_3DES(String sourceFilePath, String encryptFilePath, String pwd) throws PKIException {
        if (EncryptUtil.isHex(pwd) && pwd.length() == 64) {
            FileOutputStream fos = null;
            try {
                byte[] ivKey = EncryptUtil.hexToByte(pwd);
                byte[] iv = new byte[8];
                byte[] key = new byte[24];
                System.arraycopy(ivKey, 0, iv, 0, 8);
                System.arraycopy(ivKey, 8, key, 0, 24);
                CBCParam param = new CBCParam(iv);
                fos = new FileOutputStream(encryptFilePath);
                EncryptUtil.bigFileBlockEncrypt(true, key, new DESedeEngine(), param, new File(sourceFilePath), fos);
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static void decryptFileByPwd_3DES(String encryptFilePath, String plainTextFilePath, String pwd) throws PKIException {
        if (EncryptUtil.isHex(pwd) && pwd.length() == 64) {
            FileOutputStream fos = null;
            try {
                byte[] ivKey = EncryptUtil.hexToByte(pwd);
                byte[] iv = new byte[8];
                byte[] key = new byte[24];
                System.arraycopy(ivKey, 0, iv, 0, 8);
                System.arraycopy(ivKey, 8, key, 0, 24);
                CBCParam param = new CBCParam(iv);
                fos = new FileOutputStream(plainTextFilePath);
                EncryptUtil.bigFileBlockEncrypt(false, key, new DESedeEngine(), param, new File(encryptFilePath), fos);
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    private static void bigFileBlockEncrypt(boolean encryptFlag, byte[] key, BlockCipher engine, CBCParam param, File f, FileOutputStream fos) throws Exception {
        FileInputStream fis = null;
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), param.getIv());
            cipher.init(encryptFlag, params);
            int readLen = 0;
            byte[] buffer = new byte[GlobalVariable.BIG_FILE_BUFFER];
            byte[] outBytes = new byte[GlobalVariable.BIG_FILE_BUFFER + 100];
            long readTotalLen = 0L;
            long fileLen = f.length();
            int processLen = 0;
            fis = new FileInputStream(f);
            int len1 = 0;
            int len2 = 0;
            while ((readLen = fis.read(buffer)) > 0) {
                if (readLen == GlobalVariable.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < fileLen) {
                    processLen = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                    fos.write(outBytes, 0, processLen);
                    continue;
                }
                len1 = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                len2 = cipher.doFinal(outBytes, len1);
                fos.write(outBytes, 0, len1 + len2);
                break;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static byte[] encrypt(Mechanism encryptAlg, Key key, byte[] sourceData, Session session) throws PKIException {
        try {
            return Base64.encode(session.encrypt(encryptAlg, key, sourceData));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] decrypt(Mechanism encryptAlg, Key key, byte[] encryptData, Session session) throws PKIException {
        try {
            return session.decrypt(encryptAlg, key, Base64.decode(encryptData));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void encrypt(Mechanism encryptAlg, Key key, String sourceFilePath, String encryptFilePath, Session session) throws PKIException {
        try {
            session.encrypt(encryptAlg, key, sourceFilePath, encryptFilePath);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static void decrypt(Mechanism encryptAlg, Key key, String encryptFilePath, String plainTextFilePath, Session session) throws PKIException {
        try {
            session.decrypt(encryptAlg, key, encryptFilePath, plainTextFilePath);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }
}

