/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.asn1.parser.ASN1Node;
import cfca.asn1.parser.BigFileDecrypt;
import cfca.asn1.parser.EnvelopFileParser;
import cfca.org.bouncycastle.asn1.ASN1OctetString;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import cfca.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cfca.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.org.bouncycastle.asn1.cms.RecipientIdentifier;
import cfca.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.org.bouncycastle.crypto.engines.RC4Engine;
import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.rsa.envelope.RSAEnvelopeUtil;
import cfca.rsa.envelope.RSASymmetricCryptoUtil;
import cfca.sm.algorithm.SM4Engine;
import cfca.sm2.envelope.SM2EnvelopeUtil;
import cfca.sm2.envelope.SM2SymmetricCryptoUtil;
import cfca.sm2rsa.common.CBCParam;
import cfca.sm2rsa.common.GlobalVariable;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKCS7EnvelopedData;
import cfca.sm2rsa.common.PKCS7SignedData2;
import cfca.sm2rsa.common.PKIException;
import cfca.util.Base64;
import cfca.util.CertUtil;
import cfca.util.cipher.lib.Session;
import cfca.x509.certificate.X509Cert;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.PrivateKey;

public class EnvelopeUtil {
    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        if (sourceData == null || sourceData.length <= 0) {
            throw new PKIException("null not allowed for parameters: sourceData");
        }
        if (symmetricAlgorithm == null) {
            throw new PKIException("null not allowed for parameters: symmetricAlgorithm");
        }
        if (receiverCerts == null || receiverCerts.length == 0) {
            throw new PKIException("null/length not allowed for parameters: receiverCerts");
        }
        try {
            if (CertUtil.isSM2Cert(receiverCerts[0])) {
                return SM2EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts);
            }
            return RSAEnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts);
        }
        catch (Exception e) {
            throw new PKIException("envelope message failure", e);
        }
    }

    public static byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws PKIException {
        if (sourceData == null || sourceData.length <= 0) {
            throw new PKIException("null not allowed for parameters: sourceData");
        }
        if (symmetricAlgorithm == null) {
            throw new PKIException("null not allowed for parameters: symmetricAlgorithm");
        }
        if (receiverCerts == null || receiverCerts.length == 0) {
            throw new PKIException("null/length not allowed for parameters: receiverCerts");
        }
        if (session == null) {
            throw new PKIException("null not allowed for parameters: session");
        }
        try {
            if (CertUtil.isSM2Cert(receiverCerts[0])) {
                return SM2EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session);
            }
            return RSAEnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, receiverCerts, session);
        }
        catch (Exception e) {
            throw new PKIException("envelope message failure", e);
        }
    }

    public static void envelopeFile(String sourceFilePath, String encryptFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        if (sourceFilePath == null) {
            throw new PKIException("null not allowed for parameters: sourceFilePath");
        }
        if (encryptFilePath == null) {
            throw new PKIException("null not allowed for parameters: encryptFilePath");
        }
        if (symmetricAlgorithm == null) {
            throw new PKIException("null not allowed for parameters: symmetricAlgorithm");
        }
        if (receiverCerts == null || receiverCerts.length == 0) {
            throw new PKIException("null/length not allowed for parameters: receiverCerts");
        }
        try {
            File srcFile = new File(sourceFilePath);
            if (srcFile.length() <= 0L) {
                throw new PKIException("the souce file is null or empty!");
            }
            if (CertUtil.isSM2Cert(receiverCerts[0])) {
                SM2EnvelopeUtil.envelopeFile(sourceFilePath, encryptFilePath, symmetricAlgorithm, receiverCerts);
            } else {
                RSAEnvelopeUtil.envelopeFile(sourceFilePath, encryptFilePath, symmetricAlgorithm, receiverCerts);
            }
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("envelope file failure", e);
        }
    }

    public static void envelopeFile(String sourceFilePath, String encryptFilePath, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws PKIException {
        if (sourceFilePath == null) {
            throw new PKIException("null not allowed for parameters: sourceFilePath");
        }
        if (encryptFilePath == null) {
            throw new PKIException("null not allowed for parameters: encryptFilePath");
        }
        if (symmetricAlgorithm == null) {
            throw new PKIException("null not allowed for parameters: symmetricAlgorithm");
        }
        if (receiverCerts == null || receiverCerts.length == 0) {
            throw new PKIException("null/length not allowed for parameters: receiverCerts");
        }
        if (session == null) {
            throw new PKIException("null not allowed for parameters: session");
        }
        try {
            File srcFile = new File(sourceFilePath);
            if (srcFile.length() <= 0L) {
                throw new PKIException("the souce file is null or empty!");
            }
            if (CertUtil.isSM2Cert(receiverCerts[0])) {
                SM2EnvelopeUtil.envelopeFile(sourceFilePath, encryptFilePath, symmetricAlgorithm, receiverCerts, session);
            } else {
                RSAEnvelopeUtil.envelopeFile(sourceFilePath, encryptFilePath, symmetricAlgorithm, receiverCerts, session);
            }
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("envelope file failure", e);
        }
    }

    public static byte[] envelopeMS(byte[] sourceData, String signAlg, PrivateKey signPriKey, X509Cert signCert, String symmetricAlg, X509Cert[] recvCerts, Session session) throws PKIException {
        if (sourceData == null) {
            throw new PKIException("null not allowed for parameters: sourceData");
        }
        if (signAlg == null) {
            throw new PKIException("null not allowed for parameters: signAlg");
        }
        if (signPriKey == null) {
            throw new PKIException("null not allowed for parameters: signPriKey");
        }
        if (signCert == null) {
            throw new PKIException("null not allowed for parameters: signCert");
        }
        if (symmetricAlg == null) {
            throw new PKIException("null not allowed for parameters: symmetricAlg");
        }
        if (recvCerts == null || recvCerts.length == 0) {
            throw new PKIException("null/length not allowed for parameters: recvCerts");
        }
        if (session == null) {
            throw new PKIException("null not allowed for parameters: session");
        }
        PKCS7SignedData2 p7 = new PKCS7SignedData2(session);
        X509Cert[] certs = new X509Cert[]{signCert};
        Mechanism mechanism = new Mechanism(signAlg);
        byte[] signture = session.sign(mechanism, signPriKey, sourceData);
        byte[] signData = p7.packageSignedData(true, null, sourceData, signture, mechanism, certs);
        return EnvelopeUtil.envelopeMessage(signData, symmetricAlg, recvCerts);
    }

    public static final byte[] openEvelopedMessage(byte[] cmsEnvelopedData, PrivateKey privateKey, X509Cert recipientCert, Session session) throws PKIException {
        if (cmsEnvelopedData == null) {
            throw new PKIException("null not allowed for parameters: cmsEnvelopedData");
        }
        if (privateKey == null) {
            throw new PKIException("null not allowed for parameters: privateKey");
        }
        if (recipientCert == null) {
            throw new PKIException("null not allowed for parameters: recipientCert");
        }
        if (session == null) {
            throw new PKIException("null not allowed for parameters: session");
        }
        try {
            byte[] bEnvelop = null;
            boolean isSM2Type = CertUtil.isSM2Cert(recipientCert);
            bEnvelop = Base64.decode(cmsEnvelopedData);
            CMSEnvelopedData cmsEnData = new CMSEnvelopedData(bEnvelop);
            ContentInfo info = cmsEnData.toASN1Structure();
            EnvelopedData enData = EnvelopedData.getInstance(info.getContent());
            ASN1Set receivers = enData.getRecipientInfos();
            byte[] symmetricKey = EnvelopeUtil.checkRecipientsAndSymmetricKey(isSM2Type, privateKey, recipientCert, receivers, session);
            EncryptedContentInfo data = enData.getEncryptedContentInfo();
            AlgorithmIdentifier symmetricAlgId = data.getContentEncryptionAlgorithm();
            Mechanism mechanism = EnvelopeUtil.buildMechanism(symmetricAlgId);
            byte[] encryptedBytes = data.getEncryptedContent().getOctets();
            byte[] sourceData = null;
            sourceData = isSM2Type ? SM2SymmetricCryptoUtil.cryptoUtil(false, symmetricKey, encryptedBytes, mechanism) : RSASymmetricCryptoUtil.decrypt(symmetricKey, encryptedBytes, mechanism);
            return sourceData;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("850935", "\u89e3\u6790\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
    }

    public static final void openEnvelopedFile(String envelopedFilePath, String plainTextFilePath, PrivateKey privateKey, X509Cert recipientCert, Session session) throws PKIException {
        if (envelopedFilePath == null) {
            throw new PKIException("null not allowed for parameters: envelopedFilePath");
        }
        if (plainTextFilePath == null) {
            throw new PKIException("null not allowed for parameters: plainTextFilePath");
        }
        if (privateKey == null) {
            throw new PKIException("null not allowed for parameters: privateKey");
        }
        if (recipientCert == null) {
            throw new PKIException("null not allowed for parameters: recipientCert");
        }
        if (session == null) {
            throw new PKIException("null not allowed for parameters: session");
        }
        FileOutputStream fos = null;
        FilterOutputStream out = null;
        try {
            EnvelopFileParser parser = new EnvelopFileParser(new File(envelopedFilePath));
            parser.parser();
            ASN1Node receiver_node = parser.getReceiver_node();
            ASN1Node encrypted_node = parser.getEncrypted_node();
            boolean isSM2Type = CertUtil.isSM2Cert(recipientCert);
            ASN1Set receivers = ASN1Set.getInstance(receiver_node.getData());
            byte[] symmetricKey = EnvelopeUtil.checkRecipientsAndSymmetricKey(isSM2Type, privateKey, recipientCert, receivers, session);
            ASN1Node symmetric_encrypted = (ASN1Node)encrypted_node.childNodes.get(1);
            byte[] symmetricAlg_byte = symmetric_encrypted.getData();
            AlgorithmIdentifier symmetricAlgId = AlgorithmIdentifier.getInstance(ASN1Sequence.getInstance(symmetricAlg_byte));
            Mechanism mechanism = EnvelopeUtil.buildMechanism(symmetricAlgId);
            File plainTextFile = new File(plainTextFilePath);
            if (!plainTextFile.exists()) {
                plainTextFile.createNewFile();
            }
            fos = new FileOutputStream(plainTextFile);
            out = new BufferedOutputStream(fos, GlobalVariable.BIG_FILE_BUFFER);
            if (isSM2Type) {
                ASN1Node encryptedNode = (ASN1Node)encrypted_node.childNodes.get(2);
                if (encryptedNode.childNodes.size() == 1) {
                    encryptedNode = (ASN1Node)encryptedNode.childNodes.get(0);
                }
                BigFileDecrypt.bigFileBlockDecrypt(symmetricKey, new SM4Engine(), (CBCParam)mechanism.getParam(), encryptedNode, out);
            } else {
                ASN1Node encryptedNode = (ASN1Node)encrypted_node.childNodes.get(2);
                if (encryptedNode.childNodes.size() == 0) {
                    if (mechanism.getMechanismType().equals("RC4")) {
                        BigFileDecrypt.bigFileRC4Decrypt(symmetricKey, encryptedNode, out);
                    } else {
                        BigFileDecrypt.bigFileBlockDecrypt(symmetricKey, new DESedeEngine(), (CBCParam)mechanism.getParam(), encryptedNode, out);
                    }
                } else if (encryptedNode.childNodes.size() == 1) {
                    encryptedNode = (ASN1Node)encryptedNode.childNodes.get(0);
                    if (mechanism.getMechanismType().equals("RC4")) {
                        BigFileDecrypt.bigFileRC4Decrypt(symmetricKey, encryptedNode, out);
                    } else {
                        BigFileDecrypt.bigFileBlockDecrypt(symmetricKey, new DESedeEngine(), (CBCParam)mechanism.getParam(), encryptedNode, out);
                    }
                } else {
                    EnvelopeUtil.DecryptMicrosoftFile(mechanism, symmetricKey, encryptedNode, (BufferedOutputStream)out);
                }
            }
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("850935", "\u89e3\u6790\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static byte[] openEnvelopedMS(byte[] cmsEnvelopedData, PrivateKey recvPriKey, X509Cert recvCert, Session session) throws PKIException {
        if (cmsEnvelopedData == null) {
            throw new PKIException("null not allowed for parameters: cmsEnvelopedData");
        }
        if (recvPriKey == null) {
            throw new PKIException("null not allowed for parameters: recvPriKey");
        }
        if (recvCert == null) {
            throw new PKIException("null not allowed for parameters: recvCert");
        }
        if (session == null) {
            throw new PKIException("null not allowed for parameters: session");
        }
        byte[] signData = EnvelopeUtil.openEvelopedMessage(cmsEnvelopedData, recvPriKey, recvCert, session);
        PKCS7SignedData2 p7 = new PKCS7SignedData2(session);
        p7.loadBase64(signData);
        if (p7.verifyP7SignedDataAttach()) {
            return p7.getSourceData();
        }
        throw new PKIException("850604", "\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5931\u8d25");
    }

    private static boolean hasRecipent(KeyTransRecipientInfo inf, byte[] subjectPubKeyID, X500Name recipientIssuer, BigInteger recipientSN) {
        RecipientIdentifier id = inf.getRecipientIdentifier();
        DEROctetString oct = new DEROctetString(subjectPubKeyID);
        IssuerAndSerialNumber issu = new IssuerAndSerialNumber(recipientIssuer, recipientSN);
        return id.getId().toASN1Primitive().asn1Equals(oct) || id.getId().toASN1Primitive().asn1Equals(issu.toASN1Primitive());
    }

    private static byte[] checkRecipientsAndSymmetricKey(boolean sm2Type, PrivateKey privateKey, X509Cert recipientCert, ASN1Set receivers, Session session) throws PKIException {
        if (receivers == null) {
            throw new PKIException("the receiver is null!!!");
        }
        byte[] acceptedRecipientSubjectKeyID = recipientCert.getSubjectKeyIdentifier().getKeyIdentifier();
        X500Name acceptedRecipientIssuer = recipientCert.getIssuerX500Name();
        BigInteger acceptedRecipientSN = recipientCert.getSerialNumber();
        RecipientInfo recipientInfo = null;
        KeyTransRecipientInfo keyTransRecipientInfo = null;
        ASN1OctetString encryptKey = null;
        AlgorithmIdentifier algId = null;
        int len = receivers.size();
        for (int i = 0; i < len; ++i) {
            recipientInfo = RecipientInfo.getInstance(receivers.getObjectAt(i));
            if (!(recipientInfo.getInfo() instanceof KeyTransRecipientInfo) || !EnvelopeUtil.hasRecipent(keyTransRecipientInfo = KeyTransRecipientInfo.getInstance(recipientInfo.getInfo()), acceptedRecipientSubjectKeyID, acceptedRecipientIssuer, acceptedRecipientSN)) continue;
            encryptKey = keyTransRecipientInfo.getEncryptedKey();
            algId = keyTransRecipientInfo.getKeyEncryptionAlgorithm();
            break;
        }
        if (encryptKey == null || algId == null) {
            throw new PKIException("can not find the receiver!!!");
        }
        Mechanism contentEncryptionAlg = sm2Type ? new Mechanism("SM2") : new Mechanism("RSA/ECB/PKCS1PADDING");
        byte[] symmetricKey = session.decrypt(contentEncryptionAlg, privateKey, encryptKey.getOctets());
        if (symmetricKey == null) {
            throw new PKIException("decrypt symmetricKey failure");
        }
        return symmetricKey;
    }

    private static Mechanism buildMechanism(AlgorithmIdentifier symmetricAlgId) throws PKIException {
        if (symmetricAlgId == null) {
            throw new PKIException("missing symmetric encryption algorithm identifier ");
        }
        Mechanism mechanism = null;
        String encryptionAlgorithm = (String)PKCS7EnvelopedData.OID_MECH.get(symmetricAlgId.getAlgorithm());
        if (encryptionAlgorithm.indexOf("CBC") != -1) {
            DEROctetString doct = (DEROctetString)symmetricAlgId.getParameters();
            CBCParam cbcParam = new CBCParam(doct.getOctets());
            if (encryptionAlgorithm.equals("DESede/CBC/PKCS7Padding")) {
                mechanism = new Mechanism("DESede/CBC/PKCS7Padding", cbcParam);
            } else if (encryptionAlgorithm.equals("SM4/CBC/PKCS7Padding")) {
                mechanism = new Mechanism("SM4/CBC/PKCS7Padding", cbcParam);
            }
        } else if (encryptionAlgorithm.indexOf("ECB") != -1) {
            if (encryptionAlgorithm.equals("DESede/ECB/PKCS7Padding")) {
                mechanism = new Mechanism("DESede/ECB/PKCS7Padding");
            } else if (encryptionAlgorithm.equals("SM4/ECB/PKCS7Padding")) {
                mechanism = new Mechanism("SM4/ECB/PKCS7Padding");
            }
        } else if (encryptionAlgorithm.indexOf("RC4") != -1) {
            mechanism = new Mechanism("RC4");
        }
        if (mechanism == null) {
            throw new PKIException("850629", "\u4ea7\u751f\u7b7e\u540d\u6570\u5b57\u4fe1\u5c01\u6570\u636e,\u7b97\u6cd5\u4e0d\u652f\u6301Algorithm is:" + encryptionAlgorithm);
        }
        return mechanism;
    }

    private static final void DecryptMicrosoftFile(Mechanism mechanism, byte[] symmetricKey, ASN1Node encryptedNode, BufferedOutputStream fos) throws Exception {
        RandomAccessFile raf = null;
        if (mechanism.getMechanismType().equals("RC4")) {
            RC4Engine rc4 = new RC4Engine();
            KeyParameter keyParam = new KeyParameter(symmetricKey);
            rc4.init(false, keyParam);
            raf = new RandomAccessFile(encryptedNode.f, "r");
            BigFileDecrypt.bigFileRC4Decrypt(rc4, encryptedNode, fos, raf);
        } else {
            DESedeEngine deSedeEngine = new DESedeEngine();
            PaddedBufferedBlockCipher cipher = null;
            CBCParam param = (CBCParam)mechanism.getParam();
            if (param == null) {
                cipher = new PaddedBufferedBlockCipher(deSedeEngine, new PKCS7Padding());
                KeyParameter params = new KeyParameter(symmetricKey);
                cipher.init(false, params);
            } else {
                cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(deSedeEngine), new PKCS7Padding());
                ParametersWithIV params = new ParametersWithIV(new KeyParameter(symmetricKey), param.getIv());
                cipher.init(false, params);
            }
            raf = new RandomAccessFile(encryptedNode.f, "r");
            BigFileDecrypt.bigFileBlockDecrypt(cipher, encryptedNode, fos, raf);
        }
    }
}

