/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cfca.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import cfca.org.bouncycastle.crypto.ExtendedDigest;
import cfca.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sm.algorithm.SM2CalHashZValue;
import cfca.sm.algorithm.SM3Digest;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.GlobalVariable;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cryptokit.jni.JNIHash;
import cryptokit.jni.JNISM2;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;

public class HashUtil {
    private static final HashMap oidMap = new HashMap();

    public static byte[] rsaHashMessage(byte[] sourceData, Mechanism mechanism) throws PKIException {
        byte[] out = null;
        try {
            if (sourceData == null || sourceData.length == 0) {
                throw new Exception("the source data is null or empty!");
            }
            ExtendedDigest digest = HashUtil.getDigest(mechanism);
            digest.update(sourceData, 0, sourceData.length);
            out = new byte[digest.getDigestSize()];
            digest.doFinal(out, 0);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        return out;
    }

    public static byte[] rsaHashMessageDER(byte[] sourceData, Mechanism mechanism) throws PKIException {
        try {
            byte[] out = HashUtil.rsaHashMessage(sourceData, mechanism);
            ExtendedDigest digest = HashUtil.getDigest(mechanism);
            AlgorithmIdentifier algId = new AlgorithmIdentifier((ASN1ObjectIdentifier)oidMap.get(digest.getAlgorithmName()), (ASN1Encodable)DERNull.INSTANCE);
            DigestInfo dInfo = new DigestInfo(algId, out);
            return dInfo.getEncoded("DER");
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] rsaHashFile(String filePath, Mechanism mechanism) throws PKIException {
        BufferedInputStream bis = null;
        FileInputStream fis = null;
        try {
            ExtendedDigest digest = HashUtil.getDigest(mechanism);
            File srcFile = new File(filePath);
            if (srcFile.length() <= 0L) {
                throw new PKIException("the source file is empty!");
            }
            fis = new FileInputStream(srcFile);
            bis = new BufferedInputStream(fis);
            int buffer_size = GlobalVariable.BIG_FILE_BUFFER;
            byte[] buffer = new byte[buffer_size];
            int i = bis.read(buffer);
            if (i == -1) {
                throw new Exception("the source data is null!");
            }
            do {
                digest.update(buffer, 0, i);
            } while ((i = bis.read(buffer)) != -1);
            byte[] out = new byte[digest.getDigestSize()];
            digest.doFinal(out, 0);
            byte[] byArray = out;
            return byArray;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static byte[] rsaHashFileDER(String filePath, Mechanism mechanism) throws PKIException {
        ExtendedDigest digest = HashUtil.getDigest(mechanism);
        byte[] out = HashUtil.rsaHashFile(filePath, mechanism);
        AlgorithmIdentifier algId = new AlgorithmIdentifier((ASN1ObjectIdentifier)oidMap.get(digest.getAlgorithmName()), (ASN1Encodable)DERNull.INSTANCE);
        DigestInfo dInfo = new DigestInfo(algId, out);
        try {
            return dInfo.getEncoded("DER");
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    private static ExtendedDigest getDigest(Mechanism mechanism) throws PKIException {
        String type = mechanism.getMechanismType();
        if (type.equals("SHA1") || type.equals("SHA1withRSAEncryption")) {
            return new SHA1Digest();
        }
        if (type.equals("SHA256") || type.equals("SHA256withRSAEncryption")) {
            return new SHA256Digest();
        }
        if (type.equals("SHA512") || type.equals("SHA512withRSA")) {
            return new SHA512Digest();
        }
        if (type.equals("MD5") || type.equals("MD5withRSAEncryption")) {
            return new MD5Digest();
        }
        throw new PKIException("can not support this algorithm:" + type);
    }

    public static byte[] sm2HashMessageWithZValue_BC(byte[] userId, byte[] sourceData, BigInteger pubX, BigInteger pubY) throws PKIException {
        if (sourceData == null || sourceData.length == 0) {
            throw new PKIException("the source data is null or empty!");
        }
        byte[] out = new byte[32];
        byte[] z = SM2CalHashZValue.getZa(pubX, pubY, userId);
        SM3Digest digest = new SM3Digest();
        digest.update(z, 0, z.length);
        digest.update(sourceData, 0, sourceData.length);
        digest.doFinal(out, 0);
        return out;
    }

    public static byte[] sm2HashMessageWithZValue_JNI(byte[] userId, byte[] sourceData, byte[] pubX, byte[] pubY) throws PKIException {
        if (sourceData == null || sourceData.length == 0) {
            throw new PKIException("the source data is null or empty!");
        }
        byte[] hash = new byte[32];
        byte[] z = new byte[32];
        if (userId == null) {
            userId = SM2Params.getDefaultuserid();
        }
        try {
            JNISM2.calculateZValue((byte[])pubX, (byte[])pubY, (byte[])userId, (byte[])z);
            JNIHash sm3_jni = new JNIHash();
            sm3_jni.init(JNIHash.NID_ChinaSM3);
            sm3_jni.update(z);
            sm3_jni.update(sourceData);
            sm3_jni.doFinal(hash);
            return hash;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] sm2HashMessageWithoutZValue_BC(byte[] sourceData) throws Exception {
        byte[] hash = new byte[32];
        SM3Digest digest = new SM3Digest();
        digest.update(sourceData, 0, sourceData.length);
        digest.doFinal(hash, 0);
        return hash;
    }

    public static byte[] sm2HashMessageWithoutZValue_JNI(byte[] sourceData) throws Exception {
        byte[] hash = new byte[32];
        JNIHash sm3_jni = new JNIHash();
        sm3_jni.init(JNIHash.NID_ChinaSM3);
        sm3_jni.update(sourceData);
        sm3_jni.doFinal(hash);
        return hash;
    }

    public static byte[] sm2HashFileWithZValue_BC(byte[] userId, String sourceFilePath, BigInteger pubX, BigInteger pubY) throws PKIException {
        try {
            byte[] zvalue = new byte[32];
            zvalue = SM2CalHashZValue.getZa(pubX, pubY, userId);
            SM3Digest digest = new SM3Digest();
            digest.update(zvalue, 0, zvalue.length);
            return HashUtil.sm2HashFile(digest, sourceFilePath);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] sm2HashFileWithZValue_JNI(byte[] userId, String sourceFilePath, byte[] pubX, byte[] pubY) throws PKIException {
        try {
            byte[] zvalue = new byte[32];
            if (userId == null) {
                userId = "".getBytes();
            }
            JNISM2.calculateZValue((byte[])pubX, (byte[])pubY, (byte[])userId, (byte[])zvalue);
            JNIHash sm3_jni = new JNIHash();
            sm3_jni.init(JNIHash.NID_ChinaSM3);
            sm3_jni.update(zvalue);
            return HashUtil.sm2HashFile(sm3_jni, sourceFilePath);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] sm2HashFileWithoutZValue_BC(String sourceFilePath) throws Exception {
        SM3Digest digest = new SM3Digest();
        return HashUtil.sm2HashFile(digest, sourceFilePath);
    }

    public static byte[] sm2HashFileWithoutZValue_JNI(String sourceFilePath) throws Exception {
        JNIHash sm3_jni = new JNIHash();
        return HashUtil.sm2HashFile(sm3_jni, sourceFilePath);
    }

    public static final byte[] sm2HashMessage(SM2PublicKey sm2PublicKey, byte[] data, boolean withZ) {
        if (data == null) {
            throw new IllegalArgumentException("null not allowed for data");
        }
        SM3Digest digest = new SM3Digest();
        byte[] out = new byte[32];
        if (withZ) {
            if (sm2PublicKey == null) {
                throw new IllegalArgumentException("null not allowed for sm2PublicKey");
            }
            byte[] zValue = sm2PublicKey.getDefaultZ();
            if (zValue == null) {
                zValue = SM2Params.calcZ(sm2PublicKey.getQ());
            }
            digest.update(zValue, 0, zValue.length);
        }
        digest.update(data, 0, data.length);
        digest.doFinal(out, 0);
        return out;
    }

    public static final byte[] sm2HashFile(SM2PublicKey sm2PublicKey, String sourceFilePath, boolean withZ) {
        if (sourceFilePath == null) {
            throw new IllegalArgumentException("null not allowed for data");
        }
        SM3Digest digest = new SM3Digest();
        if (withZ) {
            if (sm2PublicKey == null) {
                throw new IllegalArgumentException("null not allowed for sm2PubKey");
            }
            byte[] zValue = sm2PublicKey.getDefaultZ();
            if (zValue == null) {
                zValue = SM2Params.calcZ(sm2PublicKey.getQ());
            }
            digest.update(zValue, 0, zValue.length);
        }
        return HashUtil.sm2HashFile(digest, sourceFilePath);
    }

    private static final byte[] sm2HashFile(SM3Digest digest, String sourceFilePath) {
        if (sourceFilePath == null) {
            throw new IllegalArgumentException("null not allowed for data");
        }
        byte[] hash = new byte[32];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFilePath);
            byte[] buffer = new byte[8096];
            int rLength = 0;
            while ((rLength = fis.read(buffer)) >= 0) {
                digest.update(buffer, 0, rLength);
            }
            digest.doFinal(hash, 0);
        }
        catch (FileNotFoundException e) {
            throw new SecurityException("doHashSM3 failure", e);
        }
        catch (IOException e) {
            throw new SecurityException("doHashSM3 failure", e);
        }
        catch (Exception e) {
            throw new SecurityException("doHashSM3 failure", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        return hash;
    }

    private static final byte[] sm2HashFile(JNIHash sm3_jni, String sourceFilePath) {
        if (sourceFilePath == null) {
            throw new IllegalArgumentException("null not allowed for data");
        }
        byte[] hash = new byte[32];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFilePath);
            byte[] buffer = new byte[8096];
            int rLength = 0;
            byte[] data = null;
            while ((rLength = fis.read(buffer)) >= 0) {
                data = new byte[rLength];
                System.arraycopy(buffer, 0, data, 0, data.length);
                sm3_jni.update(data);
            }
            sm3_jni.doFinal(hash);
        }
        catch (FileNotFoundException e) {
            throw new SecurityException("doHashSM3 failure", e);
        }
        catch (IOException e) {
            throw new SecurityException("doHashSM3 failure", e);
        }
        catch (Exception e) {
            throw new SecurityException("doHashSM3 failure", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        return hash;
    }

    static {
        oidMap.put("RIPEMD128", TeleTrusTObjectIdentifiers.ripemd128);
        oidMap.put("RIPEMD160", TeleTrusTObjectIdentifiers.ripemd160);
        oidMap.put("RIPEMD256", TeleTrusTObjectIdentifiers.ripemd256);
        oidMap.put("SHA-1", X509ObjectIdentifiers.id_SHA1);
        oidMap.put("SHA-224", NISTObjectIdentifiers.id_sha224);
        oidMap.put("SHA-256", NISTObjectIdentifiers.id_sha256);
        oidMap.put("SHA-384", NISTObjectIdentifiers.id_sha384);
        oidMap.put("SHA-512", NISTObjectIdentifiers.id_sha512);
        oidMap.put("MD2", PKCSObjectIdentifiers.md2);
        oidMap.put("MD4", PKCSObjectIdentifiers.md4);
        oidMap.put("MD5", PKCSObjectIdentifiers.md5);
    }
}

