/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.internal.tool.ASN1Parser;
import cfca.internal.tool.InitKeyStore;
import cfca.internal.tool.PKCS12;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.org.bouncycastle.math.ec.ECPoint;
import cfca.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sm.algorithm.SM2Pfx;
import cfca.sm2.signature.SM2PrivateKey;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKIException;
import cfca.util.Base64;
import cfca.util.cipher.lib.Session;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;

public class KeyUtil {
    public static SM2PrivateKey getPrivateKeyFromSM2(String sm2Path, String sm2PWD) throws PKIException {
        if (sm2Path == null) {
            throw new IllegalArgumentException("null not allowed for sm2Path");
        }
        if (sm2PWD == null) {
            throw new IllegalArgumentException("null not allowed for sm2PWD");
        }
        FileInputStream fis = null;
        FilterInputStream ais = null;
        try {
            fis = new FileInputStream(sm2Path);
            byte[] data = new byte[fis.available()];
            fis.read(data);
            fis.close();
            boolean isB64 = ASN1Parser.isBase64Encode(data);
            if (isB64) {
                data = ASN1Parser.convertBase64(data);
                data = Base64.decode(data);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ais = new ASN1InputStream(bis);
            SM2Pfx object = SM2Pfx.getInstance(((ASN1InputStream)ais).readObject());
            SM2PrivateKey sM2PrivateKey = object.getPrivateKey(sm2PWD);
            return sM2PrivateKey;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static PrivateKey getPrivateKeyFromPFX(byte[] pfxData, String pfxPWD) throws PKIException {
        if (pfxData == null) {
            throw new IllegalArgumentException("null not allowed for pfxData");
        }
        if (pfxPWD == null) {
            throw new IllegalArgumentException("null not allowed for pfxPWD");
        }
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(pfxData);
        pkcs12.decrypt(pfxPWD.toCharArray());
        return pkcs12.getPrivateKey();
    }

    public static PrivateKey getPrivateKeyFromPFX(InputStream inputStream, String pfxPWD) throws PKIException {
        if (inputStream == null) {
            throw new IllegalArgumentException("null not allowed for inputStream");
        }
        if (pfxPWD == null) {
            throw new IllegalArgumentException("null not allowed for pfxPWD");
        }
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(inputStream);
        pkcs12.decrypt(pfxPWD.toCharArray());
        return pkcs12.getPrivateKey();
    }

    public static PrivateKey getPrivateKeyFromPFX(String pfxPath, String pfxPWD) throws PKIException {
        if (pfxPath == null) {
            throw new IllegalArgumentException("null not allowed for pfxPath");
        }
        if (pfxPWD == null) {
            throw new IllegalArgumentException("null not allowed for pfxPWD");
        }
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(pfxPath);
        pkcs12.decrypt(pfxPWD.toCharArray());
        return pkcs12.getPrivateKey();
    }

    public static PrivateKey getPrivateKeyFromJKS(String jksFilePath, String jksPWD, String alias) throws PKIException {
        if (jksFilePath == null) {
            throw new IllegalArgumentException("null not allowed for jksFilePath");
        }
        if (jksPWD == null) {
            throw new IllegalArgumentException("null not allowed for jksPWD");
        }
        if (alias == null) {
            throw new IllegalArgumentException("null not allowed for alias");
        }
        try {
            KeyStore ks = InitKeyStore.initJKSKeyStore(jksFilePath, jksPWD);
            char[] password = jksPWD.toCharArray();
            return (PrivateKey)ks.getKey(alias, password);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static KeyPair generateRSAKeyPair(Mechanism mechanism, int keyLength, Session session) {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (session == null) {
            throw new IllegalArgumentException("null not allowed for session");
        }
        try {
            return session.generateKeyPair(mechanism, keyLength);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static KeyPair generateSM2KeyPair(Mechanism mechanism, Session session) {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (session == null) {
            throw new IllegalArgumentException("null not allowed for session");
        }
        try {
            return session.generateKeyPair(mechanism, 256);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static Key generateKey(Mechanism keyType, Session session) throws PKIException {
        if (keyType == null) {
            throw new IllegalArgumentException("null not allowed for keyType");
        }
        if (session == null) {
            throw new IllegalArgumentException("null not allowed for session");
        }
        return session.generateKey(keyType);
    }

    public static SM2PublicKey getSM2PublicKey(byte[] pubX, byte[] pubY) {
        if (pubX == null || pubY == null) {
            throw new IllegalArgumentException("null not allowed for pubX/pubY");
        }
        ECDomainParameters params = SM2Params.sm2DomainParameters;
        ECPoint pubPoint = params.getCurve().createPoint(new BigInteger(1, pubX), new BigInteger(1, pubY)).normalize();
        return new SM2PublicKey(new ECPublicKeyParameters(pubPoint, params));
    }

    public static SM2PrivateKey getSM2PrivateKey(byte[] d, byte[] pubX, byte[] pubY) {
        if (d == null) {
            throw new IllegalArgumentException("null not allowed for d");
        }
        ECDomainParameters params = SM2Params.sm2DomainParameters;
        BigInteger D = new BigInteger(1, d);
        SM2PublicKey pubKey = null;
        if (pubX != null && pubY != null) {
            pubKey = KeyUtil.getSM2PublicKey(pubX, pubY);
        } else {
            FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
            ECPoint Q = multiplier.multiply(params.getG(), D).normalize();
            pubKey = new SM2PublicKey(new ECPublicKeyParameters(Q, params));
        }
        ECPrivateKeyParameters priv = new ECPrivateKeyParameters(D, params);
        SM2PrivateKey priKey = new SM2PrivateKey(priv);
        if (pubX != null && pubY != null) {
            priKey.setSM2PublicKey(pubKey);
        }
        return priKey;
    }
}

