/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.org.bouncycastle.asn1.ASN1Encodable;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.DERBitString;
import cfca.org.bouncycastle.asn1.DERNull;
import cfca.org.bouncycastle.asn1.pkcs.CertificationRequest;
import cfca.org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIConstant;
import cfca.sm2rsa.common.PKIException;
import cfca.sm2rsa.common.X9ObjectIdentifiers;
import cfca.util.Base64;
import cfca.util.KeyUtil;
import cfca.util.cipher.lib.Session;
import java.security.KeyPair;

public class P10RequestUtil {
    private KeyPair keyPair;

    public String generateRSAPKCS10Request(Mechanism mechanism, int RSAKeyLength, Session session) throws PKIException {
        this.keyPair = KeyUtil.generateRSAKeyPair(mechanism, RSAKeyLength, session);
        SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance(this.keyPair.getPublic().getEncoded());
        X500Name subject = new X500Name("CN=CFCA");
        CertificationRequestInfo certRequestInfo = new CertificationRequestInfo(subject, pubInfo, null);
        AlgorithmIdentifier signAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE);
        try {
            byte[] sourceData = certRequestInfo.getEncoded("DER");
            byte[] signature = session.sign(new Mechanism("SHA1withRSAEncryption"), this.keyPair.getPrivate(), sourceData);
            CertificationRequest certRequest = new CertificationRequest(certRequestInfo, signAlg, new DERBitString(signature));
            PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(certRequest);
            return new String(Base64.encode(p10.getEncoded()));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public String generateSM2PKCS10Request(Mechanism mechanism, Session session) throws PKIException {
        this.keyPair = KeyUtil.generateSM2KeyPair(mechanism, session);
        SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance(this.keyPair.getPublic().getEncoded());
        X500Name subject = new X500Name("CN=CFCA");
        CertificationRequestInfo certRequestInfo = new CertificationRequestInfo(subject, pubInfo, null);
        AlgorithmIdentifier signAlg = new AlgorithmIdentifier(X9ObjectIdentifiers.sm3_with_SM2, (ASN1Encodable)DERNull.INSTANCE);
        try {
            byte[] sourceData = certRequestInfo.getEncoded("DER");
            byte[] signature = session.sign(new Mechanism("SM3withSM2"), this.keyPair.getPrivate(), sourceData);
            CertificationRequest certRequest = new CertificationRequest(certRequestInfo, signAlg, new DERBitString(signature));
            PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(certRequest);
            return new String(Base64.encode(p10.getEncoded()));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public static String getSubjectFromP10Request(String p10Request) throws PKIException {
        try {
            PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(Base64.decode(p10Request));
            return p10.getSubject().toString();
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static String getSignAlgFromP10Request(String p10Request) throws PKIException {
        try {
            PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(Base64.decode(p10Request));
            ASN1ObjectIdentifier oid = p10.getSignatureAlgorithm().getAlgorithm();
            boolean isContain = PKIConstant.oid2SigAlgName.containsKey(oid);
            if (!isContain) {
                return oid.getId();
            }
            String sigAlgName = (String)PKIConstant.oid2SigAlgName.get(oid);
            return sigAlgName;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public static byte[] getSignatureFromP10Request(String p10Request) throws PKIException {
        try {
            PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(Base64.decode(p10Request));
            return p10.getSignature();
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }
}

