/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.org.bouncycastle.crypto.params.KeyParameter;
import cfca.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sm.algorithm.SM3Digest;
import cfca.sm.algorithm.SM4Engine;
import cfca.sm2rsa.common.PKIException;

public class PBEWithSM4Util {
    private static byte[] KDF(byte[] z) {
        byte[] ct = new byte[]{0, 0, 0, 1};
        SM3Digest sm3 = new SM3Digest();
        sm3.update(z, 0, z.length);
        sm3.update(ct, 0, ct.length);
        byte[] hash = new byte[32];
        sm3.doFinal(hash, 0);
        return hash;
    }

    public static byte[] pbeWithSM4Encrypt(boolean isEncrypted, String pass, byte[] data) throws PKIException {
        try {
            byte[] src = pass.getBytes("UTF8");
            byte[] hash = PBEWithSM4Util.KDF(src);
            byte[] iv = new byte[16];
            System.arraycopy(hash, 0, iv, 0, 16);
            byte[] key = new byte[16];
            System.arraycopy(hash, 16, key, 0, 16);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), iv);
            cipher.init(isEncrypted, params);
            int len = cipher.getOutputSize(data.length);
            byte[] tempData = new byte[len];
            int len1 = cipher.processBytes(data, 0, data.length, tempData, 0);
            int len2 = cipher.doFinal(tempData, len1);
            int total = len1 + len2;
            if (total < len) {
                byte[] removeZeroSourceData = new byte[total];
                System.arraycopy(tempData, 0, removeZeroSourceData, 0, total);
                return removeZeroSourceData;
            }
            return tempData;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }
}

