/*
 * Decompiled with CFR 0.152.
 */
package cfca.util;

import cfca.internal.tool.ASN1Parser;
import cfca.internal.tool.FileUtil;
import cfca.org.bouncycastle.asn1.cms.Attribute;
import cfca.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.org.bouncycastle.asn1.cms.CMSAttributes;
import cfca.org.bouncycastle.asn1.cms.Time;
import cfca.org.bouncycastle.cms.CMSSignedDataParser;
import cfca.org.bouncycastle.cms.SignerInformation;
import cfca.org.bouncycastle.cms.SignerInformationStore;
import cfca.org.bouncycastle.operator.DigestCalculatorProvider;
import cfca.org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKCS7SignedData;
import cfca.sm2rsa.common.PKCS7SignedData2;
import cfca.sm2rsa.common.PKCS7SignedFile;
import cfca.sm2rsa.common.PKCS7SignedFile2;
import cfca.sm2rsa.common.PKIException;
import cfca.util.Base64;
import cfca.util.cipher.lib.Session;
import cfca.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class SignatureUtil {
    private X509Cert signCert = null;
    private String digestAlgorithm = null;
    private byte[] signature = null;
    private byte[] sourceData = null;

    public final byte[] getSourceData() {
        return this.sourceData;
    }

    public final byte[] getSignature() {
        return this.signature;
    }

    public final String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public final X509Cert getSignerCert() {
        return this.signCert;
    }

    public final String getTimeFromTimeStamp(byte[] bTimeStamp) throws PKIException {
        CMSSignedDataParser sp = null;
        try {
            byte[] base64TimeStamp = ASN1Parser.convertBase64(bTimeStamp);
            sp = new CMSSignedDataParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), (InputStream)new ByteArrayInputStream(Base64.decode(base64TimeStamp)));
            SignerInformationStore signers = sp.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            String strSignDate = null;
            while (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                AttributeTable attributeTable = signer.getSignedAttributes();
                Attribute signTimeAttri = attributeTable.get(CMSAttributes.signingTime);
                Time time = Time.getInstance(signTimeAttri.getAttrValues().getObjectAt(0).toASN1Primitive());
                Date signTimeDate = time.getDate();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                strSignDate = format.format(signTimeDate);
            }
            sp.close();
            return strSignDate;
        }
        catch (Exception ex2) {
            throw new PKIException("850914", "\u89e3\u6790\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), ex2);
        }
    }

    public final byte[] p1SignByHash(String signAlg, byte[] digest, PrivateKey priKey, Session session) throws PKIException {
        return Base64.encode(this.encodedToASN1(session.signByHash(new Mechanism(signAlg), priKey, digest)));
    }

    public final boolean p1VerifyByHash(String signAlg, byte[] digest, byte[] base64SignData, PublicKey pubKey, Session session) throws PKIException {
        byte[] signature = this.decodedSignValue(base64SignData);
        return session.verifyByHash(new Mechanism(signAlg), pubKey, digest, signature);
    }

    public final byte[] p1SignMessage(String signAlg, byte[] sourceData, PrivateKey priKey, Session session) throws PKIException {
        return Base64.encode(this.encodedToASN1(session.sign(new Mechanism(signAlg), priKey, sourceData)));
    }

    public final boolean p1VerifyMessage(String signAlg, byte[] sourceData, byte[] base64SignData, PublicKey pubKey, Session session) throws PKIException {
        byte[] signature = this.decodedSignValue(base64SignData);
        return session.verifySign(new Mechanism(signAlg), pubKey, sourceData, signature);
    }

    public final byte[] p1SignFile(String signAlg, String sourceFilePath, PrivateKey priKey, Session session) throws PKIException {
        return Base64.encode(this.encodedToASN1(session.sign(new Mechanism(signAlg), priKey, sourceFilePath)));
    }

    public final boolean p1VerifyFile(String signAlg, String sourceFilePath, byte[] base64SignData, PublicKey pubKey, Session session) throws PKIException {
        byte[] signature = this.decodedSignValue(base64SignData);
        return session.verifySign(new Mechanism(signAlg), pubKey, sourceFilePath, signature);
    }

    public final byte[] p7SignByHash(String signAlg, byte[] digest, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
        X509Cert[] certs = new X509Cert[]{cert};
        Mechanism mechanism = new Mechanism(signAlg);
        byte[] signture = session.signByHash(new Mechanism(signAlg), priKey, digest);
        return Base64.encode(p7.packageSignedData(false, null, null, signture, mechanism, certs));
    }

    public final boolean p7VerifyByHash(byte[] digest, byte[] base64PKCS7SignedData, Session session) throws PKIException {
        PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
        p7.loadBase64(base64PKCS7SignedData);
        this.signCert = p7.getSignerX509Cert();
        this.digestAlgorithm = p7.getDigestAlgorithm();
        this.signature = p7.getSignature();
        return p7.verifyP7SignedDataByHash(digest);
    }

    public final byte[] p7SignMessageAttach(String signAlg, byte[] sourceData, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
        X509Cert[] certs = new X509Cert[]{cert};
        Mechanism mechanism = new Mechanism(signAlg);
        byte[] signture = session.sign(mechanism, priKey, sourceData);
        return Base64.encode(p7.packageSignedData(true, null, sourceData, signture, mechanism, certs));
    }

    public final boolean p7VerifyMessageAttach(byte[] base64PKCS7SignedData, Session session) throws PKIException {
        PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
        p7.loadBase64(base64PKCS7SignedData);
        this.signCert = p7.getSignerX509Cert();
        this.sourceData = p7.getSourceData();
        this.digestAlgorithm = p7.getDigestAlgorithm();
        this.signature = p7.getSignature();
        return p7.verifyP7SignedDataAttach();
    }

    public final byte[] p7SignMessageDetach(String signAlg, byte[] sourceData, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
        X509Cert[] certs = new X509Cert[]{cert};
        Mechanism mechanism = new Mechanism(signAlg);
        byte[] signture = session.sign(mechanism, priKey, sourceData);
        return Base64.encode(p7.packageSignedData(false, null, sourceData, signture, mechanism, certs));
    }

    public final boolean p7VerifyMessageDetach(byte[] sourceData, byte[] base64PKCS7SignedData, Session session) throws PKIException {
        PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
        p7.loadBase64(base64PKCS7SignedData);
        this.signCert = p7.getSignerX509Cert();
        this.digestAlgorithm = p7.getDigestAlgorithm();
        this.signature = p7.getSignature();
        return p7.verifyP7SignedData(sourceData);
    }

    public final void p7SignFileAttach(String signAlg, String sourceFilePath, String signFilePath, PrivateKey priKey, X509Cert signerCert, Session session) throws PKIException {
        PKCS7SignedFile p7 = this.buildPKCS7SignedFile(session);
        X509Cert[] certs = new X509Cert[]{signerCert};
        Mechanism mechanism = new Mechanism(signAlg);
        byte[] signture = session.sign(mechanism, priKey, sourceFilePath);
        p7.packageSignedFile(null, sourceFilePath, signFilePath, signture, mechanism, certs);
    }

    public final boolean p7VerifyFileAttach(String signFilePath, String saveSrcFilePath, Session session) throws PKIException {
        try {
            File f = new File(signFilePath);
            if (f.length() <= 0x3300000L) {
                byte[] temps = FileUtil.getBytesFromFile(signFilePath);
                boolean ret = this.p7VerifyMessageAttach(temps, session);
                if (saveSrcFilePath != null && !saveSrcFilePath.trim().equals("")) {
                    FileUtil.writeBytesToFile(this.getSourceData(), saveSrcFilePath);
                }
                return ret;
            }
            PKCS7SignedFile p7 = this.buildPKCS7SignedFile(session);
            boolean result = p7.verifyP7SignedFile(signFilePath, saveSrcFilePath);
            this.signCert = p7.getSignerX509Cert();
            this.digestAlgorithm = p7.getDigestAlgorithm();
            this.signature = p7.getSignature();
            return result;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public final byte[] p7SignFileDetach(String signAlg, String sourceFilePath, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
        X509Cert[] certs = new X509Cert[]{cert};
        Mechanism mechanism = new Mechanism(signAlg);
        byte[] signture = session.sign(mechanism, priKey, sourceFilePath);
        return Base64.encode(p7.packageSignedData(false, null, null, signture, mechanism, certs));
    }

    public final boolean p7VerifyFileDetach(String srcFilePath, byte[] signData, Session session) throws PKIException {
        try {
            PKCS7SignedData p7 = this.buildPKCS7SignedData(session);
            p7.loadBase64(signData);
            this.signCert = p7.getSignerX509Cert();
            this.digestAlgorithm = p7.getDigestAlgorithm();
            this.signature = p7.getSignature();
            return p7.verifyP7SignedData(srcFilePath);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    final PKCS7SignedData buildPKCS7SignedData(Session session) {
        PKCS7SignedData p7 = null;
        p7 = this.isNewFormat() ? new PKCS7SignedData2(session) : new PKCS7SignedData(session);
        return p7;
    }

    final PKCS7SignedFile buildPKCS7SignedFile(Session session) {
        PKCS7SignedFile p7 = null;
        p7 = this.isNewFormat() ? new PKCS7SignedFile2(session) : new PKCS7SignedFile(session);
        return p7;
    }

    boolean isNewFormat() {
        return false;
    }

    private final byte[] decodedSignValue(byte[] base64SignData) throws PKIException {
        if (base64SignData == null) {
            throw new IllegalArgumentException("null not allowed for signData");
        }
        byte[] asn1RS_RS = Base64.decode(base64SignData);
        byte[] signature = null;
        if (asn1RS_RS.length == 64 || asn1RS_RS.length >= 128) {
            signature = asn1RS_RS;
        } else if (asn1RS_RS.length >= 66 && asn1RS_RS.length <= 72) {
            signature = this.decodedFromASN1(asn1RS_RS);
        } else {
            throw new PKIException("The signData is wrong!");
        }
        return signature;
    }

    private final byte[] encodedToASN1(byte[] signData) throws PKIException {
        if (signData == null) {
            return signData;
        }
        byte[] signature = null;
        if (this.isNewFormat() && signData.length == 64) {
            ASN1SM2Signature asn1 = new ASN1SM2Signature(signData);
            try {
                signature = asn1.getEncoded();
            }
            catch (IOException e) {
                throw new PKIException(e.getMessage());
            }
        } else {
            signature = signData;
        }
        return signature;
    }

    private final byte[] decodedFromASN1(byte[] asn1EncodedRS) {
        if (asn1EncodedRS == null) {
            throw new SecurityException("Unknown signature value");
        }
        byte[] signature = null;
        if (this.isNewFormat()) {
            ASN1SM2Signature value = new ASN1SM2Signature(asn1EncodedRS);
            signature = new byte[64];
            System.arraycopy(BigIntegers.asUnsignedByteArray(32, value.getR().getValue()), 0, signature, 0, 32);
            System.arraycopy(BigIntegers.asUnsignedByteArray(32, value.getS().getValue()), 0, signature, 32, 32);
            return signature;
        }
        signature = asn1EncodedRS;
        return signature;
    }
}

