/*
 * Decompiled with CFR 0.152.
 */
package cfca.util.cipher.lib;

import cfca.asn1.parser.BigFileCipherUtil;
import cfca.internal.tool.HashEncoderUtil;
import cfca.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import cfca.org.bouncycastle.crypto.engines.RSABlindedEngine;
import cfca.org.bouncycastle.crypto.engines.RSAEngine;
import cfca.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.rsa.envelope.RSASymmetricCryptoUtil;
import cfca.rsa.signature.RSAPackageUtil;
import cfca.sadk.signature.sm2.BCSoftSM2;
import cfca.sadk.signature.sm2.SM2PackageUtil;
import cfca.sm2.envelope.SM2SymmetricCryptoUtil;
import cfca.sm2.signature.SM2PrivateKey;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKIException;
import cfca.system.SecurityContext;
import cfca.util.HashUtil;
import cfca.util.cipher.lib.LibUtils;
import cfca.util.cipher.lib.Session;
import java.io.File;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;

public final class BCSoftLib
implements Session {
    static final int encryptedType_SM2 = 1;
    static final int encryptedType_RSA = 2;
    static final int encryptedType_DES_RC4 = 17;
    static final int encryptedType_SM4 = 18;
    static final HashMap hashSignatureAlgorithms = new HashMap();
    static final HashMap hashEncryptedAlgorithms = new HashMap();

    static final boolean hasSignatureAlgorithm(String mType) {
        return hashSignatureAlgorithms.containsKey(mType);
    }

    public KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        KeyPair keypair;
        block8: {
            if (mechanism == null) {
                throw new IllegalArgumentException("null not allowed for mechanism");
            }
            keypair = null;
            try {
                if ("SM2".equals(mechanism.getMechanismType())) {
                    keypair = BCSoftSM2.generateKeyPair();
                    break block8;
                }
                if ("RSA".equals(mechanism.getMechanismType())) {
                    KeyPairGenerator keyPairGen = null;
                    try {
                        keyPairGen = KeyPairGenerator.getInstance("RSA");
                    }
                    catch (Exception e) {
                        return null;
                    }
                    if (keyLength <= 512 || keyLength > 4096) {
                        throw new PKIException("key length is illgal:" + keyLength);
                    }
                    keyPairGen.initialize(keyLength);
                    keypair = keyPairGen.generateKeyPair();
                    break block8;
                }
                throw new PKIException("850231", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mechanism.getMechanismType());
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
        return keypair;
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (priKey == null) {
            throw new IllegalArgumentException("null not allowed for priKey");
        }
        if (sourceData == null) {
            throw new IllegalArgumentException("null not allowed for sourceData");
        }
        String mType = mechanism.getMechanismType();
        if (!BCSoftLib.hasSignatureAlgorithm(mType)) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if ("SM3withSM2".equals(mType)) {
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                SM2PrivateKey sm2priKey = (SM2PrivateKey)priKey;
                byte[] hash = HashUtil.sm2HashMessage(sm2priKey.getSM2PublicKey(), sourceData, SecurityContext.getUseZValue());
                return SM2PackageUtil.encryptByBC(hash, sm2priKey);
            }
            byte[] hash = HashUtil.rsaHashMessageDER(sourceData, mechanism);
            return this.RSAEncrypt((RSAPrivateKey)priKey, hash, mechanism);
        }
        catch (Exception e) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, String sourceFilePath) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (priKey == null) {
            throw new IllegalArgumentException("null not allowed for priKey");
        }
        if (sourceFilePath == null) {
            throw new IllegalArgumentException("null not allowed for sourceFilePath");
        }
        String mType = mechanism.getMechanismType();
        if (!BCSoftLib.hasSignatureAlgorithm(mType)) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if ("SM3withSM2".equals(mType)) {
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                SM2PrivateKey sm2priKey = (SM2PrivateKey)priKey;
                byte[] hash = HashUtil.sm2HashFile(sm2priKey.getSM2PublicKey(), sourceFilePath, SecurityContext.getUseZValue());
                return SM2PackageUtil.encryptByBC(hash, sm2priKey);
            }
            byte[] hash = HashUtil.rsaHashFileDER(sourceFilePath, mechanism);
            return this.RSAEncrypt((RSAPrivateKey)priKey, hash, mechanism);
        }
        catch (Exception e) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final boolean verifySign(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (pubKey == null) {
            throw new IllegalArgumentException("null not allowed for pubKey");
        }
        if (sourceData == null) {
            throw new IllegalArgumentException("null not allowed for sourceData");
        }
        if (signData == null) {
            throw new IllegalArgumentException("null not allowed for signData");
        }
        String mType = mechanism.getMechanismType();
        if (!BCSoftLib.hasSignatureAlgorithm(mType)) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if ("SM3withSM2".equals(mType)) {
                if (!(pubKey instanceof SM2PublicKey)) {
                    throw new PKIException("The public key type is not sm2 type!");
                }
                SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                if (signData.length == 64) {
                    byte[] hashWithZ = HashUtil.sm2HashMessage(sm2PubKey, sourceData, true);
                    boolean verifyWithZ = SM2PackageUtil.verifyByBC(hashWithZ, signData, pubKey);
                    if (!verifyWithZ) {
                        byte[] hashWithoutZ = HashUtil.sm2HashMessage(sm2PubKey, sourceData, false);
                        boolean verifyWithoutZ = SM2PackageUtil.verifyByBC(hashWithoutZ, signData, pubKey);
                        return verifyWithoutZ;
                    }
                    return verifyWithZ;
                }
                if (signData.length == 128) {
                    return LibUtils.verifySign(sm2PubKey, sourceData, signData, false);
                }
                throw new PKIException("the sm2 signature length must be 64 or 128 bytes!");
            }
            byte[] hashData = HashUtil.rsaHashMessageDER(sourceData, mechanism);
            byte[] hashValue = this.RSADecrypt((RSAPublicKey)pubKey, signData, mechanism);
            return RSAPackageUtil.isRSAHashEqual(hashValue, hashData);
        }
        catch (Exception e) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final boolean verifySign(Mechanism mechanism, PublicKey pubKey, String sourceFilePath, byte[] signData) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (pubKey == null) {
            throw new IllegalArgumentException("null not allowed for pubKey");
        }
        if (sourceFilePath == null) {
            throw new IllegalArgumentException("null not allowed for sourceFilePath");
        }
        if (signData == null) {
            throw new IllegalArgumentException("null not allowed for signData");
        }
        String mType = mechanism.getMechanismType();
        if (!BCSoftLib.hasSignatureAlgorithm(mType)) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if ("SM3withSM2".equals(mType)) {
                if (!(pubKey instanceof SM2PublicKey)) {
                    throw new PKIException("The public key type is not sm2 type!");
                }
                SM2PublicKey sm2PublicKey = (SM2PublicKey)pubKey;
                if (signData.length == 64) {
                    byte[] hash = HashUtil.sm2HashFile(sm2PublicKey, sourceFilePath, SecurityContext.getUseZValue());
                    return SM2PackageUtil.verifyByBC(hash, signData, pubKey);
                }
                byte[] hash = HashUtil.sm2HashFile(sm2PublicKey, sourceFilePath, true);
                return LibUtils.verifyByHash(sm2PublicKey, hash, signData, false);
            }
            byte[] hashData = HashUtil.rsaHashFileDER(sourceFilePath, mechanism);
            byte[] hashValue = this.RSADecrypt((RSAPublicKey)pubKey, signData, mechanism);
            return RSAPackageUtil.isRSAHashEqual(hashValue, hashData);
        }
        catch (Exception e) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final byte[] signByHash(Mechanism mechanism, PrivateKey priKey, byte[] digest) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (priKey == null) {
            throw new IllegalArgumentException("null not allowed for priKey");
        }
        if (digest == null) {
            throw new IllegalArgumentException("null not allowed for digest");
        }
        String mType = mechanism.getMechanismType();
        if (!BCSoftLib.hasSignatureAlgorithm(mType)) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if ("SM3withSM2".equals(mType)) {
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                SM2PrivateKey sm2priKey = (SM2PrivateKey)priKey;
                return SM2PackageUtil.encryptByBC(digest, sm2priKey);
            }
            byte[] hash = HashEncoderUtil.derEncoder(mType, digest);
            return this.RSAEncrypt((RSAPrivateKey)priKey, hash, mechanism);
        }
        catch (Exception e) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] digest, byte[] signData) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (pubKey == null) {
            throw new IllegalArgumentException("null not allowed for pubKey");
        }
        if (digest == null) {
            throw new IllegalArgumentException("null not allowed for digest");
        }
        if (signData == null) {
            throw new IllegalArgumentException("null not allowed for signData");
        }
        String mType = mechanism.getMechanismType();
        if (!BCSoftLib.hasSignatureAlgorithm(mType)) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if ("SM3withSM2".equals(mType)) {
                if (!(pubKey instanceof SM2PublicKey)) {
                    throw new PKIException("The public key type is not sm2 type!");
                }
                SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                if (signData.length == 64) {
                    return SM2PackageUtil.verifyByBC(digest, signData, sm2PubKey);
                }
                return LibUtils.verifyByHash(sm2PubKey, digest, signData, false);
            }
            byte[] hashData = HashEncoderUtil.derEncoder(mType, digest);
            byte[] hashValue = this.RSADecrypt((RSAPublicKey)pubKey, signData, mechanism);
            return RSAPackageUtil.isRSAHashEqual(hashValue, hashData);
        }
        catch (Exception e) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (key == null) {
            throw new IllegalArgumentException("null not allowed for key");
        }
        if (sourceData == null) {
            throw new IllegalArgumentException("null not allowed for sourceData");
        }
        try {
            String mType = mechanism.getMechanismType();
            Integer value = (Integer)hashEncryptedAlgorithms.get(mType);
            if (value == null) {
                throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mType);
            }
            byte[] encryptedData = null;
            switch (value) {
                case 1: {
                    encryptedData = this.SM2Encrypt((SM2PublicKey)key, sourceData);
                    break;
                }
                case 2: {
                    encryptedData = this.RSAEncrypt((RSAPublicKey)key, sourceData, mechanism);
                    break;
                }
                case 17: {
                    encryptedData = RSASymmetricCryptoUtil.encrypt(key.getEncoded(), sourceData, mechanism);
                    break;
                }
                case 18: {
                    encryptedData = SM2SymmetricCryptoUtil.cryptoUtil(true, key.getEncoded(), sourceData, mechanism);
                    break;
                }
                default: {
                    throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mType);
                }
            }
            return encryptedData;
        }
        catch (Exception e) {
            throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptedData) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (key == null) {
            throw new IllegalArgumentException("null not allowed for key");
        }
        if (encryptedData == null) {
            throw new IllegalArgumentException("null not allowed for encryptData");
        }
        try {
            String mType = mechanism.getMechanismType();
            Integer value = (Integer)hashEncryptedAlgorithms.get(mType);
            if (value == null) {
                throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mType);
            }
            byte[] decryptedData = null;
            switch (value) {
                case 1: {
                    decryptedData = this.SM2Decrypt((SM2PrivateKey)key, encryptedData);
                    break;
                }
                case 2: {
                    decryptedData = this.RSADecrypt((RSAPrivateKey)key, encryptedData, mechanism);
                    break;
                }
                case 17: {
                    decryptedData = RSASymmetricCryptoUtil.decrypt(key.getEncoded(), encryptedData, mechanism);
                    break;
                }
                case 18: {
                    decryptedData = SM2SymmetricCryptoUtil.cryptoUtil(false, key.getEncoded(), encryptedData, mechanism);
                    break;
                }
                default: {
                    throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mType);
                }
            }
            return decryptedData;
        }
        catch (Exception e) {
            throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final void encrypt(Mechanism mechanism, Key key, String sourceFilePath, String encryptFilePath) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (key == null) {
            throw new IllegalArgumentException("null not allowed for key");
        }
        if (sourceFilePath == null) {
            throw new IllegalArgumentException("null not allowed for sourceFilePath");
        }
        if (encryptFilePath == null) {
            throw new IllegalArgumentException("null not allowed for encryptFilePath");
        }
        try {
            BigFileCipherUtil.bigFileBlockCipher(true, mechanism, key.getEncoded(), new File(sourceFilePath), new File(encryptFilePath));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public final void decrypt(Mechanism mechanism, Key key, String encryptFilePath, String plainTextFilePath) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (key == null) {
            throw new IllegalArgumentException("null not allowed for key");
        }
        if (encryptFilePath == null) {
            throw new IllegalArgumentException("null not allowed for encryptFilePath");
        }
        if (plainTextFilePath == null) {
            throw new IllegalArgumentException("null not allowed for plainTextFilePath");
        }
        try {
            BigFileCipherUtil.bigFileBlockCipher(false, mechanism, key.getEncoded(), new File(encryptFilePath), new File(plainTextFilePath));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public final Key generateKey(Mechanism mechanism) throws PKIException {
        return RSASymmetricCryptoUtil.generateSecureKey(mechanism);
    }

    private final byte[] SM2Encrypt(SM2PublicKey publicKey, byte[] sourceData) throws Exception {
        return SM2SymmetricCryptoUtil.sm2Encrypt(true, publicKey, sourceData);
    }

    private final byte[] SM2Decrypt(SM2PrivateKey privateKey, byte[] encryptedData) throws Exception {
        return SM2SymmetricCryptoUtil.sm2Encrypt(false, privateKey, encryptedData);
    }

    private byte[] RSAEncrypt(RSAPublicKey publicKey, byte[] sourceData, Mechanism mechanism) throws Exception {
        RSAKeyParameters param = RSAPackageUtil.generatePublicKeyParameter(publicKey);
        PKCS1Encoding eng = new PKCS1Encoding(new RSAEngine());
        eng.init(true, param);
        return eng.processBlock(sourceData, 0, sourceData.length);
    }

    private byte[] RSADecrypt(RSAPrivateKey privateKey, byte[] encryptedData, Mechanism mechanism) throws Exception {
        RSAKeyParameters param = RSAPackageUtil.generatePrivateKeyParameter(privateKey);
        PKCS1Encoding eng = new PKCS1Encoding(new RSAEngine());
        eng.init(false, param);
        return eng.processBlock(encryptedData, 0, encryptedData.length);
    }

    private byte[] RSAEncrypt(RSAPrivateKey publicKey, byte[] sourceData, Mechanism mechanism) throws Exception {
        RSAKeyParameters param = RSAPackageUtil.generatePrivateKeyParameter(publicKey);
        PKCS1Encoding eng = new PKCS1Encoding(new RSABlindedEngine());
        eng.init(true, param);
        return eng.processBlock(sourceData, 0, sourceData.length);
    }

    private byte[] RSADecrypt(RSAPublicKey publicKey, byte[] encryptedData, Mechanism mechanism) throws Exception {
        RSAKeyParameters param = RSAPackageUtil.generatePublicKeyParameter(publicKey);
        PKCS1Encoding eng = new PKCS1Encoding(new RSABlindedEngine());
        eng.init(false, param);
        return eng.processBlock(encryptedData, 0, encryptedData.length);
    }

    static {
        hashSignatureAlgorithms.put("SM3withSM2", null);
        hashSignatureAlgorithms.put("SHA1withRSAEncryption", null);
        hashSignatureAlgorithms.put("SHA256withRSAEncryption", null);
        hashSignatureAlgorithms.put("SHA512withRSA", null);
        hashSignatureAlgorithms.put("MD5withRSAEncryption", null);
        hashEncryptedAlgorithms.put("SM2", 1);
        hashEncryptedAlgorithms.put("RSA/ECB/PKCS1PADDING", 2);
        hashEncryptedAlgorithms.put("DESede/CBC/PKCS7Padding", 17);
        hashEncryptedAlgorithms.put("DESede/ECB/PKCS7Padding", 17);
        hashEncryptedAlgorithms.put("RC4", 17);
        hashEncryptedAlgorithms.put("SM4/CBC/PKCS7Padding", 18);
        hashEncryptedAlgorithms.put("SM4/ECB/PKCS7Padding", 18);
    }
}

