/*
 * Decompiled with CFR 0.152.
 */
package cfca.util.cipher.lib;

import cfca.asn1.parser.BigFileCipherUtil;
import cfca.internal.tool.HashEncoderUtil;
import cfca.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.org.bouncycastle.math.ec.ECPoint;
import cfca.rsa.envelope.RSASymmetricCryptoUtil;
import cfca.rsa.signature.RSAPackageUtil;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.signature.sm2.SM2PackageUtil;
import cfca.sm2.envelope.SM2SymmetricCryptoUtil;
import cfca.sm2.signature.SM2PrivateKey;
import cfca.sm2.signature.SM2PublicKey;
import cfca.sm2rsa.common.Mechanism;
import cfca.sm2rsa.common.PKIException;
import cfca.system.SecurityContext;
import cfca.util.HashUtil;
import cfca.util.cipher.lib.BCSoftLib;
import cfca.util.cipher.lib.LibUtils;
import cfca.util.cipher.lib.Session;
import cryptokit.SMJNI.SM2JNI;
import cryptokit.SMJNI.SM3JNI;
import cryptokit.jni.JNISM2;
import java.io.File;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public final class JNISoftLib
implements Session {
    public final KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        KeyPair keypair;
        block10: {
            if (mechanism == null) {
                throw new IllegalArgumentException("null not allowed for mechanism");
            }
            keypair = null;
            try {
                if ("SM2".equals(mechanism.getMechanismType())) {
                    byte[] d = new byte[32];
                    byte[] pubx = new byte[32];
                    byte[] puby = new byte[32];
                    try {
                        SM2JNI.generateKeypair(d, pubx, puby);
                    }
                    catch (Exception e) {
                        throw new PKIException(e.getMessage());
                    }
                    ECDomainParameters spec = SM2Params.sm2DomainParameters;
                    ECPoint point = spec.getCurve().createPoint(new BigInteger(1, pubx), new BigInteger(1, puby));
                    ECPublicKeyParameters pub = new ECPublicKeyParameters(point, spec);
                    ECPrivateKeyParameters priv = new ECPrivateKeyParameters(new BigInteger(1, d), spec);
                    SM2PublicKey pubKey = new SM2PublicKey(pub);
                    SM2PrivateKey priKey = new SM2PrivateKey(priv);
                    keypair = new KeyPair(pubKey, priKey);
                    break block10;
                }
                if ("RSA".equals(mechanism.getMechanismType())) {
                    KeyPairGenerator keyPairGen = null;
                    try {
                        keyPairGen = KeyPairGenerator.getInstance("RSA");
                    }
                    catch (Exception e) {
                        return null;
                    }
                    if (keyLength <= 512 || keyLength > 4096) {
                        throw new PKIException("key length is illgal:" + keyLength);
                    }
                    keyPairGen.initialize(keyLength);
                    keypair = keyPairGen.generateKeyPair();
                    break block10;
                }
                throw new PKIException("850241", "\u4ea7\u751f\u975e\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mechanism.getMechanismType());
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
        return keypair;
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (priKey == null) {
            throw new IllegalArgumentException("null not allowed for priKey");
        }
        if (sourceData == null) {
            throw new IllegalArgumentException("null not allowed for sourceData");
        }
        String mType = mechanism.getMechanismType();
        if (!BCSoftLib.hasSignatureAlgorithm(mType)) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if ("SM3withSM2".equals(mType)) {
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                SM2PrivateKey sm2priKey = (SM2PrivateKey)priKey;
                byte[] hash = HashUtil.sm2HashMessage(sm2priKey.getSM2PublicKey(), sourceData, SecurityContext.getUseZValue());
                return SM2PackageUtil.encryptByJNI(hash, sm2priKey.getD_Bytes());
            }
            if (!(priKey instanceof RSAPrivateKey)) {
                throw new PKIException("The private key type is not rsa type!");
            }
            RSAPrivateKey privateKey = (RSAPrivateKey)priKey;
            byte[] hashEncodedDER = HashUtil.rsaHashMessageDER(sourceData, mechanism);
            return RSAPackageUtil.encryptByJNI(hashEncodedDER, privateKey);
        }
        catch (Exception e) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, String sourceFilePath) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (priKey == null) {
            throw new IllegalArgumentException("null not allowed for priKey");
        }
        if (sourceFilePath == null) {
            throw new IllegalArgumentException("null not allowed for sourceFilePath");
        }
        String mType = mechanism.getMechanismType();
        if (!BCSoftLib.hasSignatureAlgorithm(mType)) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if ("SM3withSM2".equals(mType)) {
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                SM2PrivateKey sm2priKey = (SM2PrivateKey)priKey;
                byte[] hash = HashUtil.sm2HashFile(sm2priKey.getSM2PublicKey(), sourceFilePath, SecurityContext.getUseZValue());
                return SM2PackageUtil.encryptByJNI(hash, sm2priKey.getD_Bytes());
            }
            if (!(priKey instanceof RSAPrivateKey)) {
                throw new PKIException("The private key type is not rsa type!");
            }
            RSAPrivateKey privateKey = (RSAPrivateKey)priKey;
            byte[] hashEncodedDER = HashUtil.rsaHashFileDER(sourceFilePath, mechanism);
            return RSAPackageUtil.encryptByJNI(hashEncodedDER, privateKey);
        }
        catch (Exception e) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final boolean verifySign(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (pubKey == null) {
            throw new IllegalArgumentException("null not allowed for pubKey");
        }
        if (sourceData == null) {
            throw new IllegalArgumentException("null not allowed for sourceData");
        }
        if (signData == null) {
            throw new IllegalArgumentException("null not allowed for signData");
        }
        String mType = mechanism.getMechanismType();
        if (!BCSoftLib.hasSignatureAlgorithm(mType)) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if ("SM3withSM2".equals(mType)) {
                if (!(pubKey instanceof SM2PublicKey)) {
                    throw new PKIException("The public key type is not sm2 type!");
                }
                SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                byte[] hashData = new byte[32];
                SM3JNI sm3_jni = new SM3JNI();
                sm3_jni.update(sm2PubKey.getDefaultZ());
                sm3_jni.doFinal(sourceData, hashData);
                if (64 == signData.length) {
                    return SM2PackageUtil.verifyByJNI(hashData, signData, sm2PubKey.getPubX(), sm2PubKey.getPubY());
                }
                if (128 == signData.length) {
                    return LibUtils.verifySign(sm2PubKey, sourceData, signData, true);
                }
                throw new PKIException("signature data length must be 64 or 128 bytes!");
            }
            if (!(pubKey instanceof RSAPublicKey)) {
                throw new PKIException("The public key type is not rsa type!");
            }
            byte[] hashEncodedDER = HashUtil.rsaHashMessageDER(sourceData, mechanism);
            byte[] signValue = RSAPackageUtil.decryptByJNI(signData, (RSAPublicKey)pubKey);
            return RSAPackageUtil.isRSAHashEqual(signValue, hashEncodedDER);
        }
        catch (Exception e) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final boolean verifySign(Mechanism mechanism, PublicKey pubKey, String sourceFilePath, byte[] signData) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (pubKey == null) {
            throw new IllegalArgumentException("null not allowed for pubKey");
        }
        if (sourceFilePath == null) {
            throw new IllegalArgumentException("null not allowed for sourceFilePath");
        }
        if (signData == null) {
            throw new IllegalArgumentException("null not allowed for signData");
        }
        String mType = mechanism.getMechanismType();
        if (!BCSoftLib.hasSignatureAlgorithm(mType)) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if ("SM3withSM2".equals(mType)) {
                if (!(pubKey instanceof SM2PublicKey)) {
                    throw new PKIException("The public key type is not sm2 type!");
                }
                SM2PublicKey sm2PublicKey = (SM2PublicKey)pubKey;
                if (signData.length == 64) {
                    byte[] hash = HashUtil.sm2HashFile(sm2PublicKey, sourceFilePath, SecurityContext.getUseZValue());
                    return SM2PackageUtil.verifyByJNI(hash, signData, sm2PublicKey.getPubX(), sm2PublicKey.getPubY());
                }
                byte[] hash = HashUtil.sm2HashFile(sm2PublicKey, sourceFilePath, true);
                return LibUtils.verifyByHash(sm2PublicKey, hash, signData, true);
            }
            if (!(pubKey instanceof RSAPublicKey)) {
                throw new PKIException("The public key type is not rsa type!");
            }
            byte[] hashEncodedDER = HashUtil.rsaHashFileDER(sourceFilePath, mechanism);
            byte[] signValue = RSAPackageUtil.decryptByJNI(signData, (RSAPublicKey)pubKey);
            return RSAPackageUtil.isRSAHashEqual(signValue, hashEncodedDER);
        }
        catch (Exception e) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final byte[] signByHash(Mechanism mechanism, PrivateKey priKey, byte[] digest) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (priKey == null) {
            throw new IllegalArgumentException("null not allowed for priKey");
        }
        if (digest == null) {
            throw new IllegalArgumentException("null not allowed for digest");
        }
        String mType = mechanism.getMechanismType();
        if (!BCSoftLib.hasSignatureAlgorithm(mType)) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if ("SM3withSM2".equals(mType)) {
                if (!(priKey instanceof SM2PrivateKey)) {
                    throw new PKIException("The private key type is not sm2 type!");
                }
                SM2PrivateKey sm2priKey = (SM2PrivateKey)priKey;
                return SM2PackageUtil.encryptByJNI(digest, sm2priKey.getD_Bytes());
            }
            if (!(priKey instanceof RSAPrivateKey)) {
                throw new PKIException("The private key type is not rsa type!");
            }
            RSAPrivateKey privateKey = (RSAPrivateKey)priKey;
            byte[] hashEncodedDER = HashEncoderUtil.derEncoder(mType, digest);
            return RSAPackageUtil.encryptByJNI(hashEncodedDER, privateKey);
        }
        catch (Exception e) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] digest, byte[] signData) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (pubKey == null) {
            throw new IllegalArgumentException("null not allowed for pubKey");
        }
        if (digest == null) {
            throw new IllegalArgumentException("null not allowed for digest");
        }
        if (signData == null) {
            throw new IllegalArgumentException("null not allowed for signData");
        }
        String mType = mechanism.getMechanismType();
        if (!BCSoftLib.hasSignatureAlgorithm(mType)) {
            throw new PKIException("850205", "\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b " + mType);
        }
        try {
            if ("SM3withSM2".equals(mType)) {
                if (!(pubKey instanceof SM2PublicKey)) {
                    throw new PKIException("The public key type is not sm2 type!");
                }
                SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                if (signData.length == 64) {
                    return SM2PackageUtil.verifyByJNI(digest, signData, sm2PubKey.getPubX(), sm2PubKey.getPubY());
                }
                return LibUtils.verifyByHash(sm2PubKey, digest, signData, true);
            }
            if (!(pubKey instanceof RSAPublicKey)) {
                throw new PKIException("The public key type is not rsa type!");
            }
            byte[] hashEncodedDER = HashEncoderUtil.derEncoder(mType, digest);
            byte[] signValue = RSAPackageUtil.decrypt(signData, pubKey);
            return RSAPackageUtil.isRSAHashEqual(signValue, hashEncodedDER);
        }
        catch (Exception e) {
            throw new PKIException("850206", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (key == null) {
            throw new IllegalArgumentException("null not allowed for key");
        }
        if (sourceData == null) {
            throw new IllegalArgumentException("null not allowed for sourceData");
        }
        try {
            String mType = mechanism.getMechanismType();
            Integer value = (Integer)BCSoftLib.hashEncryptedAlgorithms.get(mType);
            if (value == null) {
                throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mType);
            }
            byte[] decryptedData = null;
            switch (value) {
                case 1: {
                    decryptedData = this.SM2Encrypt(key, sourceData);
                    break;
                }
                case 2: {
                    decryptedData = this.RSAEncrypt((RSAPublicKey)key, sourceData, mechanism);
                    break;
                }
                case 17: {
                    decryptedData = RSASymmetricCryptoUtil.encrypt(key.getEncoded(), sourceData, mechanism);
                    break;
                }
                case 18: {
                    decryptedData = SM2SymmetricCryptoUtil.cryptoUtil(true, key.getEncoded(), sourceData, mechanism);
                    break;
                }
                default: {
                    throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mType);
                }
            }
            return decryptedData;
        }
        catch (Exception e) {
            throw new PKIException("850200", "\u52a0\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (key == null) {
            throw new IllegalArgumentException("null not allowed for key");
        }
        if (encryptData == null) {
            throw new IllegalArgumentException("null not allowed for encryptData");
        }
        try {
            String mType = mechanism.getMechanismType();
            Integer value = (Integer)BCSoftLib.hashEncryptedAlgorithms.get(mType);
            if (value == null) {
                throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mType);
            }
            byte[] decryptedData = null;
            switch (value) {
                case 1: {
                    decryptedData = this.SM2Decrypt(key, encryptData);
                    break;
                }
                case 2: {
                    decryptedData = this.RSADecrypt((RSAPrivateKey)key, encryptData, mechanism);
                    break;
                }
                case 17: {
                    decryptedData = RSASymmetricCryptoUtil.decrypt(key.getEncoded(), encryptData, mechanism);
                    break;
                }
                case 18: {
                    decryptedData = SM2SymmetricCryptoUtil.cryptoUtil(false, key.getEncoded(), encryptData, mechanism);
                    break;
                }
                default: {
                    throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25 \u672c\u64cd\u4f5c\u4e0d\u652f\u6301\u6b64\u79cd\u673a\u5236\u7c7b\u578b" + mType);
                }
            }
            return decryptedData;
        }
        catch (Exception e) {
            throw new PKIException("850201", "\u89e3\u5bc6\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    public final void encrypt(Mechanism mechanism, Key key, String sourceFilePath, String encryptFilePath) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (key == null) {
            throw new IllegalArgumentException("null not allowed for key");
        }
        if (sourceFilePath == null) {
            throw new IllegalArgumentException("null not allowed for sourceFilePath");
        }
        if (encryptFilePath == null) {
            throw new IllegalArgumentException("null not allowed for encryptFilePath");
        }
        try {
            BigFileCipherUtil.bigFileBlockCipher(true, mechanism, key.getEncoded(), new File(sourceFilePath), new File(encryptFilePath));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public final void decrypt(Mechanism mechanism, Key key, String encryptFilePath, String plainTextFilePath) throws PKIException {
        if (mechanism == null) {
            throw new IllegalArgumentException("null not allowed for mechanism");
        }
        if (key == null) {
            throw new IllegalArgumentException("null not allowed for key");
        }
        if (encryptFilePath == null) {
            throw new IllegalArgumentException("null not allowed for encryptFilePath");
        }
        if (plainTextFilePath == null) {
            throw new IllegalArgumentException("null not allowed for plainTextFilePath");
        }
        try {
            BigFileCipherUtil.bigFileBlockCipher(false, mechanism, key.getEncoded(), new File(encryptFilePath), new File(plainTextFilePath));
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public final Key generateKey(Mechanism mechanism) throws PKIException {
        return RSASymmetricCryptoUtil.generateSecureKey(mechanism);
    }

    private final byte[] SM2Encrypt(Key sm2Key, byte[] sourceData) throws Exception {
        if (sourceData == null) {
            throw new IllegalArgumentException("null not allowed for sourceData");
        }
        byte[] encryptedData = new byte[sourceData.length + 96];
        SM2PublicKey pubKey = (SM2PublicKey)sm2Key;
        boolean encryptedResult = JNISM2.encrypt((byte[])sourceData, (byte[])pubKey.getPubX(), (byte[])pubKey.getPubY(), (byte[])encryptedData);
        if (!encryptedResult) {
            throw new SecurityException("encrypted failure");
        }
        return encryptedData;
    }

    private final byte[] SM2Decrypt(Key sm2Key, byte[] encryptData) throws Exception {
        if (encryptData == null || encryptData.length < 96) {
            throw new IllegalArgumentException("null or length not allowed for encryptData");
        }
        SM2PrivateKey priKey = (SM2PrivateKey)sm2Key;
        byte[] decryptedData = new byte[encryptData.length - 96];
        boolean decryptedResult = JNISM2.decrypt((byte[])encryptData, (byte[])priKey.getD_Bytes(), (byte[])decryptedData);
        if (!decryptedResult) {
            throw new SecurityException("decrypted failure");
        }
        return decryptedData;
    }

    private byte[] RSAEncrypt(RSAPublicKey publicKey, byte[] sourceData, Mechanism mechanism) throws Exception {
        return RSAPackageUtil.encryptByJNI(sourceData, publicKey);
    }

    private byte[] RSADecrypt(RSAPrivateKey privateKey, byte[] encryptedData, Mechanism mechanism) throws Exception {
        return RSAPackageUtil.decryptByJNI(encryptedData, privateKey);
    }
}

