/*
 * Decompiled with CFR 0.152.
 */
package cfca.x509.certificate;

import cfca.internal.tool.ASN1Parser;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.DERBitString;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x500.X500NameStyle;
import cfca.org.bouncycastle.asn1.x509.CertificateList;
import cfca.org.bouncycastle.asn1.x509.TBSCertList;
import cfca.org.bouncycastle.asn1.x509.Time;
import cfca.rsa.signature.RSASignUtil;
import cfca.sm2.signature.SM2SignUtil;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cfca.sm2rsa.common.X9ObjectIdentifiers;
import cfca.x509.certificate.CFCAStyle;
import cfca.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Date;

public final class X509CRL {
    private CertificateList certList = null;
    private TBSCertList.CRLEntry[] crlEntries = null;

    public X509CRL(byte[] derCRL) throws PKIException {
        FilterInputStream dis = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(derCRL);
            dis = new ASN1InputStream(bis);
            ASN1Sequence seq = (ASN1Sequence)((ASN1InputStream)dis).readObject();
            this.certList = new CertificateList(seq);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
        }
        catch (Exception ex) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25");
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public X509CRL(CertificateList certList) {
        this.certList = certList;
        this.crlEntries = certList.getTBSCertList().getRevokedCertificates();
    }

    public X509CRL(InputStream is) throws PKIException {
        ASN1InputStream dis = null;
        try {
            dis = new ASN1InputStream(is);
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            this.certList = new CertificateList(seq);
            this.crlEntries = this.certList.getTBSCertList().getRevokedCertificates();
            is.close();
        }
        catch (Exception ex) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("850416", "\u89e3\u6790CRL\u65f6\u521d\u59cb\u5316CRL\u5931\u8d25");
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public CertificateList getCertificateList() {
        return this.certList;
    }

    public byte[] getEncoded() throws PKIException {
        byte[] encoded = null;
        try {
            encoded = ASN1Parser.writeDERObj2Bytes(this.certList);
        }
        catch (Exception ex) {
            throw new PKIException("850417", "\u83b7\u5f97CRL\u7f16\u7801\u5931\u8d25", ex);
        }
        return encoded;
    }

    public String getIssuer() {
        X500Name x500IssuerName = this.certList.getIssuer();
        X500Name cfca_issuer = new X500Name(CFCAStyle.INSTANCE, x500IssuerName);
        return cfca_issuer.toString();
    }

    public String getIssuer(X500NameStyle style) {
        X500Name x500IssuerName = this.certList.getIssuer();
        X500Name cfca_issuer = new X500Name(style, x500IssuerName);
        return cfca_issuer.toString();
    }

    public Date getThisUpdate() {
        Time thisUpdate = this.certList.getThisUpdate();
        return thisUpdate.getDate();
    }

    public Date getNextUpdate() {
        Time nextUpdate = this.certList.getNextUpdate();
        if (nextUpdate == null) {
            return null;
        }
        return nextUpdate.getDate();
    }

    public byte[] getSignature() {
        DERBitString derBit = this.certList.getSignature();
        return derBit.getBytes();
    }

    public boolean isRevoke(String certSerialNumber) {
        if (this.crlEntries == null) {
            return false;
        }
        BigInteger sn = new BigInteger(certSerialNumber, 16);
        for (int i = 0; i < this.crlEntries.length; ++i) {
            BigInteger tmpSN = this.crlEntries[i].getUserCertificate().getValue();
            if (!sn.equals(tmpSN)) continue;
            return true;
        }
        return false;
    }

    public boolean isRevoke(BigInteger certSerialNumber) {
        if (this.crlEntries == null) {
            return false;
        }
        for (int i = 0; i < this.crlEntries.length; ++i) {
            BigInteger tmpSN = this.crlEntries[i].getUserCertificate().getValue();
            if (!certSerialNumber.equals(tmpSN)) continue;
            return true;
        }
        return false;
    }

    public boolean verify(PublicKey pubKey) throws PKIException {
        String digestAlgorithm;
        ASN1ObjectIdentifier oid = this.certList.getSignatureAlgorithm().getAlgorithm();
        if (oid.equals(X9ObjectIdentifiers.sm3_with_SM2)) {
            if (!"SM2".equalsIgnoreCase(pubKey.getAlgorithm())) {
                return false;
            }
            return SM2SignUtil.verify(this.getTBSCertList(), null, this.getSignature(), pubKey);
        }
        if (oid.equals(PKCSObjectIdentifiers.md5WithRSAEncryption)) {
            digestAlgorithm = "MD5";
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption)) {
            digestAlgorithm = "SHA1";
        } else if (oid.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption)) {
            digestAlgorithm = "SHA256";
        } else if (oid.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption)) {
            digestAlgorithm = "SHA512";
        } else {
            throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5:" + oid.getId());
        }
        return RSASignUtil.verifySign(digestAlgorithm, pubKey, this.getTBSCertList(), this.getSignature());
    }

    public static boolean verify(String crlPath, String certPath) throws PKIException {
        if (crlPath != null && !"".equals(crlPath)) {
            FileInputStream fisCRL = null;
            FileInputStream fisCert = null;
            try {
                boolean result;
                fisCRL = new FileInputStream(crlPath);
                X509CRL crl = new X509CRL(fisCRL);
                fisCRL.close();
                fisCert = new FileInputStream(certPath);
                X509Cert cert = new X509Cert(fisCert);
                fisCert.close();
                boolean bl = result = crl.verify(cert.getPublicKey());
                return bl;
            }
            catch (FileNotFoundException e) {
                throw new PKIException("verify crl failure", e);
            }
            catch (IOException e) {
                throw new PKIException("verify crl failure", e);
            }
            catch (PKIException e) {
                throw e;
            }
            finally {
                if (fisCRL != null) {
                    try {
                        fisCRL.close();
                    }
                    catch (Exception e) {}
                }
                if (fisCert != null) {
                    try {
                        fisCert.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return false;
    }

    public byte[] getTBSCertList() throws PKIException {
        byte[] bTBSCertList = null;
        try {
            bTBSCertList = ASN1Parser.writeDERObj2Bytes(this.certList.getTBSCertList().toASN1Primitive());
        }
        catch (Exception e) {
            throw new PKIException("850415", "TBS CRL\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", e);
        }
        return bTBSCertList;
    }
}

