/*
 * Decompiled with CFR 0.152.
 */
package cfca.x509.certificate;

import cfca.internal.tool.ASN1Parser;
import cfca.org.bouncycastle.asn1.ASN1InputStream;
import cfca.org.bouncycastle.asn1.ASN1Integer;
import cfca.org.bouncycastle.asn1.ASN1Object;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.DERBitString;
import cfca.org.bouncycastle.asn1.x500.X500Name;
import cfca.org.bouncycastle.asn1.x500.X500NameStyle;
import cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.org.bouncycastle.asn1.x509.BasicConstraints;
import cfca.org.bouncycastle.asn1.x509.CRLDistPoint;
import cfca.org.bouncycastle.asn1.x509.Certificate;
import cfca.org.bouncycastle.asn1.x509.Extension;
import cfca.org.bouncycastle.asn1.x509.Extensions;
import cfca.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.org.bouncycastle.asn1.x509.TBSCertificate;
import cfca.org.bouncycastle.asn1.x509.Time;
import cfca.org.bouncycastle.asn1.x509.X509Extension;
import cfca.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.org.bouncycastle.crypto.util.PublicKeyFactory;
import cfca.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import cfca.rsa.signature.RSASignUtil;
import cfca.sm2.signature.SM2SignUtil;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIConstant;
import cfca.sm2rsa.common.PKIException;
import cfca.sm2rsa.common.X9ObjectIdentifiers;
import cfca.util.Base64;
import cfca.util.KeyUtil;
import cfca.x509.certificate.CFCAStyle;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Date;

public class X509Cert {
    private final String head = "-----BEGIN CERTIFICATE-----";
    private final String end = "-----END CERTIFICATE-----";
    protected Certificate cert;
    private Extensions extensions = null;
    private static String digits = "0123456789ABCDEF";

    public X509Cert(byte[] certData) throws PKIException {
        byte[] derData = this.parseCertData(certData);
        this.initCert(derData);
    }

    public X509Cert(InputStream inputStream) throws PKIException {
        byte[] certIS = null;
        try {
            int i;
            int length = inputStream.available();
            certIS = new byte[length];
            for (int readLen = inputStream.read(certIS); readLen < length; readLen += i) {
                byte[] temp = new byte[length - readLen];
                i = inputStream.read(temp);
                System.arraycopy(temp, 0, certIS, readLen, i);
            }
        }
        catch (IOException ex) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
        byte[] derData = this.parseCertData(certIS);
        this.initCert(derData);
    }

    public X509Cert(Certificate certStructure) {
        this.cert = certStructure;
    }

    private byte[] parseCertData(byte[] certData) throws PKIException {
        try {
            byte[] tempHead = new byte["-----BEGIN CERTIFICATE-----".length()];
            System.arraycopy(certData, 0, tempHead, 0, tempHead.length);
            if (ASN1Parser.isBase64Encode(certData)) {
                certData = ASN1Parser.convertBase64(certData);
                return Base64.decode(certData);
            }
            if (Arrays.equals(tempHead, "-----BEGIN CERTIFICATE-----".getBytes())) {
                int length = certData.length;
                byte[] withoutHead = new byte[length - "-----BEGIN CERTIFICATE-----".length()];
                System.arraycopy(certData, "-----BEGIN CERTIFICATE-----".length(), withoutHead, 0, withoutHead.length);
                byte[] withoutEnd = new byte[withoutHead.length - ("-----END CERTIFICATE-----".length() + 2)];
                System.arraycopy(withoutHead, 0, withoutEnd, 0, withoutEnd.length);
                byte[] withoutEnter = ASN1Parser.convertBase64(withoutEnd);
                return Base64.decode(withoutEnter);
            }
            return certData;
        }
        catch (Exception ex) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25");
        }
    }

    private void initCert(byte[] certData) throws PKIException {
        FilterInputStream asn1InputStream = null;
        try {
            asn1InputStream = new ASN1InputStream(new ByteArrayInputStream(certData));
            ASN1Sequence asn1Sequence = (ASN1Sequence)((ASN1InputStream)asn1InputStream).readObject();
            this.cert = Certificate.getInstance(asn1Sequence);
        }
        catch (Exception ex) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25");
        }
        finally {
            if (asn1InputStream != null) {
                try {
                    asn1InputStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public Certificate getCertStructure() {
        return this.cert;
    }

    public byte[] getEncoded() throws PKIException {
        byte[] encoded = null;
        try {
            encoded = ASN1Parser.writeDERObj2Bytes(this.cert);
        }
        catch (Exception ex) {
            throw new PKIException("850412", "\u83b7\u5f97\u8bc1\u4e66\u7f16\u7801\u5931\u8d25", ex);
        }
        return encoded;
    }

    public ASN1Integer getVersion() {
        return this.cert.getVersion();
    }

    public String getIssuer() {
        X500Name x500IssuerName = this.cert.getIssuer();
        X500Name cfca_issuer = new X500Name(CFCAStyle.INSTANCE, x500IssuerName);
        return cfca_issuer.toString();
    }

    public String getIssuer(X500NameStyle style) {
        X500Name x500IssuerName = this.cert.getIssuer();
        X500Name cfca_issuer = new X500Name(style, x500IssuerName);
        return cfca_issuer.toString();
    }

    public X500Name getIssuerX500Name() {
        X500Name x500IssuerName = this.cert.getIssuer();
        return x500IssuerName;
    }

    public String getSubject() {
        X500Name x500SubjectName = this.cert.getSubject();
        X500Name cfca_dn = new X500Name(CFCAStyle.INSTANCE, x500SubjectName);
        return cfca_dn.toString();
    }

    public String getSubject(X500NameStyle style) {
        X500Name x500SubjectName = this.cert.getSubject();
        X500Name cfca_dn = new X500Name(style, x500SubjectName);
        return cfca_dn.toString();
    }

    public X500Name getSubjectX500Name() {
        return this.cert.getSubject();
    }

    public Date getNotBefore() {
        Time startTime = this.cert.getStartDate();
        return startTime.getDate();
    }

    public Date getNotAfter() {
        Time endTime = this.cert.getEndDate();
        return endTime.getDate();
    }

    public BigInteger getSerialNumber() {
        ASN1Integer derSN = this.cert.getSerialNumber();
        return derSN.getPositiveValue();
    }

    public String getStringSerialNumber() {
        ASN1Integer derSN = this.cert.getSerialNumber();
        byte[] sn = derSN.getBytes();
        if (sn != null) {
            int length = sn.length;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i != length; ++i) {
                int v = sn[i] & 0xFF;
                buf.append(digits.charAt(v >>> 4));
                buf.append(digits.charAt(v & 0xF));
            }
            return buf.toString();
        }
        return "";
    }

    public String getSignatureAlgName() {
        AlgorithmIdentifier algID = this.cert.getSignatureAlgorithm();
        ASN1ObjectIdentifier oid = algID.getAlgorithm();
        boolean isContain = PKIConstant.oid2SigAlgName.containsKey(oid);
        if (!isContain) {
            return this.getSignatureAlgOID();
        }
        String sigAlgName = (String)PKIConstant.oid2SigAlgName.get(oid);
        return sigAlgName;
    }

    private String getSignatureAlgOID() {
        AlgorithmIdentifier algID = this.cert.getSignatureAlgorithm();
        ASN1ObjectIdentifier oid = algID.getAlgorithm();
        return oid.getId();
    }

    public PublicKey getPublicKey() throws PKIException {
        if (this.cert.getSignatureAlgorithm().getAlgorithm().equals(X9ObjectIdentifiers.sm3_with_SM2)) {
            return this.getSM2PublicKey();
        }
        SubjectPublicKeyInfo spki = this.cert.getSubjectPublicKeyInfo();
        try {
            if (spki.getAlgorithm().getAlgorithm().toString().equals(PKCSObjectIdentifiers.rsaEncryption.toString())) {
                RSAKeyParameters param = (RSAKeyParameters)PublicKeyFactory.createKey(spki);
                return new BCRSAPublicKey(param);
            }
            throw new PKIException("can not support this cert:" + spki.getAlgorithm().getAlgorithm().toString());
        }
        catch (Exception ex) {
            throw new PKIException("850305", "\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u8f6c\u6362\u4e3a\u516c\u94a5\u5931\u8d25", ex);
        }
    }

    public boolean verify(PublicKey pubKey) throws PKIException {
        String digestAlgorithm;
        ASN1ObjectIdentifier oid = this.cert.getSignatureAlgorithm().getAlgorithm();
        if (oid.equals(X9ObjectIdentifiers.sm3_with_SM2)) {
            return SM2SignUtil.verify(this.getTBSCertificate(), null, this.getSignature(), pubKey);
        }
        if (oid.equals(PKCSObjectIdentifiers.md5WithRSAEncryption)) {
            digestAlgorithm = "MD5";
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption)) {
            digestAlgorithm = "SHA1";
        } else if (oid.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption)) {
            digestAlgorithm = "SHA256";
        } else if (oid.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption)) {
            digestAlgorithm = "SHA512";
        } else {
            throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5:" + oid.getId());
        }
        return RSASignUtil.verifySign(digestAlgorithm, pubKey, this.getTBSCertificate(), this.getSignature());
    }

    public byte[] getPublicKeyData() throws PKIException {
        SubjectPublicKeyInfo spki = this.cert.getSubjectPublicKeyInfo();
        return spki.getPublicKeyData().getBytes();
    }

    public byte[] getTBSCertificate() throws PKIException {
        TBSCertificate tbsCert = this.cert.getTBSCertificate();
        byte[] tbsCertData = null;
        try {
            tbsCertData = ASN1Parser.writeDERObj2Bytes(tbsCert.toASN1Primitive());
        }
        catch (Exception ex) {
            throw new PKIException("850409", "TBS\u8bc1\u4e66\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", ex);
        }
        return tbsCertData;
    }

    public byte[] getSignature() {
        if (this.cert.getSignatureAlgorithm().getAlgorithm().equals(X9ObjectIdentifiers.sm3_with_SM2)) {
            return this.cert.getSignature().getBytes();
        }
        DERBitString signature = this.cert.getSignature();
        return signature.getBytes();
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() throws PKIException {
        ASN1Object derObj = null;
        try {
            derObj = this.getExtensionData(Extension.subjectKeyIdentifier);
            if (derObj == null) {
                return null;
            }
            SubjectKeyIdentifier subjectKeyId = SubjectKeyIdentifier.getInstance(derObj);
            return subjectKeyId;
        }
        catch (Exception e) {
            throw new PKIException("850514", "\u6784\u9020\u4e3b\u9898\u5bc6\u94a5\u6807\u8bc6\u7b26\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public ASN1Object getExtensionData(ASN1ObjectIdentifier oid) throws Exception {
        return ASN1Parser.writeBytes2DERObj(this.getExtensionByteData(oid));
    }

    public byte[] getExtensionByteData(ASN1ObjectIdentifier oid) throws Exception {
        TBSCertificate tbsCert = this.cert.getTBSCertificate();
        this.extensions = tbsCert.getExtensions();
        if (this.extensions == null) {
            return null;
        }
        Extension extension = this.extensions.getExtension(oid);
        if (extension == null) {
            return null;
        }
        return extension.getExtnValue().getOctets();
    }

    public CRLDistPoint getCRLDistributionPoints() throws PKIException {
        ASN1Object derObj = null;
        try {
            derObj = this.getExtensionData(X509Extension.cRLDistributionPoints);
            if (derObj == null) {
                return null;
            }
            ASN1Sequence asn1Sequence = (ASN1Sequence)derObj;
            CRLDistPoint crlDistributPoints = CRLDistPoint.getInstance(asn1Sequence);
            return crlDistributPoints;
        }
        catch (Exception e) {
            throw new PKIException("850521", "\u6784\u9020CRL\u5206\u5e03\u70b9\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    private PublicKey getSM2PublicKey() throws PKIException {
        SubjectPublicKeyInfo spki = this.cert.getSubjectPublicKeyInfo();
        byte[] pubData = spki.getPublicKeyData().getBytes();
        int len = pubData.length;
        if (len == 65) {
            byte[] pubX = new byte[32];
            byte[] pubY = new byte[32];
            System.arraycopy(pubData, 1, pubX, 0, 32);
            System.arraycopy(pubData, 33, pubY, 0, 32);
            return KeyUtil.getSM2PublicKey(pubX, pubY);
        }
        throw new PKIException("850305", "\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u8f6c\u6362\u4e3a\u516c\u94a5\u5931\u8d25");
    }

    public BasicConstraints getBasicConstraints() throws PKIException {
        ASN1Object derObj = null;
        try {
            derObj = this.getExtensionData(X509Extension.basicConstraints);
            if (derObj == null) {
                return null;
            }
            ASN1Sequence asn1Sequence = (ASN1Sequence)derObj;
            BasicConstraints basicConstraints = BasicConstraints.getInstance(asn1Sequence);
            return basicConstraints;
        }
        catch (Exception e) {
            throw new PKIException("850516", "\u6784\u9020\u57fa\u672c\u9650\u5236\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cert == null ? 0 : this.cert.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X509Cert other = (X509Cert)obj;
        return !(this.cert == null ? other.cert != null : !this.cert.equals(other.cert));
    }
}

