/*
 * Decompiled with CFR 0.152.
 */
package cfca.x509.certificate;

import cfca.sm2rsa.common.PKIException;
import cfca.x509.certificate.X509Cert;
import java.io.FileInputStream;
import java.io.IOException;

public class X509CertHelper {
    public static X509Cert parse(byte[] certData) throws PKIException {
        return new X509Cert(certData);
    }

    public static X509Cert parse(String filePath) throws IOException, PKIException {
        byte[] derData;
        FileInputStream bais = null;
        try {
            bais = new FileInputStream(filePath);
            derData = new byte[bais.available()];
            bais.read(derData);
            bais.close();
        }
        catch (Exception e) {
            throw new PKIException("\u8f6c\u6362\u8bc1\u4e66\u5230X509Certificate\u5931\u8d25", e);
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (Exception e) {}
            }
        }
        return X509CertHelper.parse(derData);
    }
}

