/*
 * Decompiled with CFR 0.152.
 */
package cfca.x509.certificate;

import cfca.org.bouncycastle.asn1.ASN1Object;
import cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import cfca.org.bouncycastle.asn1.x509.CRLDistPoint;
import cfca.org.bouncycastle.asn1.x509.DistributionPoint;
import cfca.org.bouncycastle.asn1.x509.Extension;
import cfca.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cfca.org.bouncycastle.util.encoders.Hex;
import cfca.sm2rsa.common.PKIException;
import cfca.x509.certificate.X509CRL;
import cfca.x509.certificate.X509Cert;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class X509CertValidator {
    public static final ASN1ObjectIdentifier SM3withSM2Encryption = new ASN1ObjectIdentifier("1.2.156.10197.1.501");
    private static HashMap trustCerts = new HashMap();
    private static final int BUFFSIZE = 65536;

    public static void updateTrustCertsMap(ArrayList trustCertPath) throws PKIException {
        if (trustCertPath != null) {
            Object certPath = null;
            int size = trustCertPath.size();
            for (int i = 0; i < size; ++i) {
                certPath = trustCertPath.get(i);
                if (!(certPath instanceof String)) continue;
                try {
                    X509CertValidator.updateTrustCertsMap(certPath);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void updateTrustCertsMap(String trustCerPath) throws PKIException {
        try {
            X509CertValidator.updateTrustCertsMap(new X509Cert(X509CertValidator.read(trustCerPath)));
        }
        catch (IOException e) {
            throw new PKIException("updateTrustCertsMap failure", e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateTrustCertsMap(X509Cert[] trustCerts) throws PKIException {
        if (trustCerts != null) {
            for (int i = 0; i < trustCerts.length; ++i) {
                try {
                    X509CertValidator.updateTrustCertsMap(trustCerts[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTrustCertsMap(X509Cert trustCert) throws PKIException {
        if (X509CertValidator.isValid(trustCert)) {
            try {
                PublicKey publicKey = trustCert.getPublicKey();
                HashMap hashMap = trustCerts;
                synchronized (hashMap) {
                    trustCerts.put(trustCert.getSubject(), publicKey);
                    String id = X509CertValidator.buildSubjectKeyIDTextFrom(trustCert);
                    if (id != null) {
                        trustCerts.put(id, publicKey);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isValid(X509Cert trustCert) {
        String signAlgorithmId = "1.2.156.10197.1.501";
        String keyTypeAlgorithmId = "1.2.840.113549.1.1.1";
        boolean isValid = false;
        if (trustCert != null) {
            isValid = "1.2.156.10197.1.501".equals(trustCert.getCertStructure().getSignatureAlgorithm().getAlgorithm().getId()) || "1.2.840.113549.1.1.1".equals(trustCert.cert.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId());
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearTrustCertsMap() {
        HashMap hashMap = trustCerts;
        synchronized (hashMap) {
            trustCerts.clear();
        }
    }

    public static boolean validateCertSign(X509Cert cert) throws PKIException {
        boolean verifyResult = false;
        if (cert != null) {
            PublicKey pubKey = null;
            try {
                String id = X509CertValidator.buildAuthorityKeyIDTextFrom(cert);
                if (id != null) {
                    pubKey = (PublicKey)trustCerts.get(id);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pubKey == null) {
                pubKey = (PublicKey)trustCerts.get(cert.getIssuer());
            }
            if (pubKey != null) {
                verifyResult = cert.verify(pubKey);
            }
        }
        return verifyResult;
    }

    private static final String buildAuthorityKeyIDTextFrom(X509Cert cert) throws PKIException {
        String id = null;
        try {
            ASN1Object extension = cert.getExtensionData(Extension.authorityKeyIdentifier);
            if (extension != null) {
                AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance(extension);
                id = X509CertValidator.buildKeyIDTextFrom(authorityKeyIdentifier.getKeyIdentifier());
            }
        }
        catch (Exception e) {
            id = null;
        }
        return id;
    }

    private static final String buildSubjectKeyIDTextFrom(X509Cert cert) throws PKIException {
        String id = null;
        try {
            ASN1Object extension = cert.getExtensionData(Extension.subjectKeyIdentifier);
            if (extension != null) {
                SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(extension);
                id = X509CertValidator.buildKeyIDTextFrom(subjectKeyIdentifier.getKeyIdentifier());
            }
        }
        catch (Exception e) {
            id = null;
        }
        return id;
    }

    private static String buildKeyIDTextFrom(byte[] keyIdentifier) {
        return new String(Hex.encode(keyIdentifier)).toLowerCase();
    }

    public static boolean verifyCertDate(X509Cert userCert) {
        if (userCert == null) {
            throw new IllegalArgumentException("null not allowed for userCert");
        }
        Date current = new Date();
        Date start = userCert.getNotBefore();
        Date end = userCert.getNotAfter();
        return !current.before(start) && !current.after(end);
    }

    public static boolean verifyCertByCRLOutLine(X509Cert userCert, String crlPath) throws PKIException {
        if (userCert == null || crlPath == null) {
            throw new PKIException("null not allowed for userCert/crlPath");
        }
        byte[] crlBytes = null;
        try {
            crlBytes = X509CertValidator.read(crlPath);
        }
        catch (IOException ex) {
            throw new PKIException("read crl file failure", ex);
        }
        X509CRL crl = new X509CRL(crlBytes);
        boolean passed = true;
        passed = !crl.isRevoke(userCert.getSerialNumber());
        return passed;
    }

    public static String getCRLPointName(X509Cert userCert) throws PKIException {
        if (userCert == null) {
            throw new PKIException("null not allowed for userCert");
        }
        CRLDistPoint crlDistExt = userCert.getCRLDistributionPoints();
        if (crlDistExt == null) {
            throw new PKIException("No any CRLDistPoint for userCert");
        }
        if (crlDistExt.getDistributionPoints() == null) {
            throw new PKIException("No any DistributionPoints for userCert");
        }
        int crlDistCount = crlDistExt.getDistributionPoints().length;
        String crl = null;
        DistributionPoint crlName = null;
        String crlPointName = null;
        for (int i = 0; i < crlDistCount; ++i) {
            crlName = crlDistExt.getDistributionPoints()[i];
            crlPointName = crlName.getDistributionPoint().toString();
            if (crlPointName.indexOf("ldap://") == -1) continue;
            crl = crlPointName;
        }
        if (crl == null) {
            throw new PKIException("CRLDistPoint not found with certificate ");
        }
        return crl;
    }

    public static boolean verifyCertByLDAP(X509Cert userCert) throws PKIException {
        if (userCert == null) {
            throw new PKIException("null not allowed for userCert");
        }
        String crl = X509CertValidator.getCRLPointName(userCert);
        if (crl == null) {
            throw new PKIException("No any CRLPointName for userCert");
        }
        int ldapIndex = crl.indexOf("ldap://");
        crl = crl.substring(ldapIndex + 7, crl.length());
        ldapIndex = crl.indexOf(":");
        String ip = crl.substring(0, ldapIndex);
        crl = crl.substring(ldapIndex + 1, crl.length());
        ldapIndex = crl.indexOf("/");
        String port = crl.substring(0, ldapIndex);
        crl = crl.substring(ldapIndex + 1, crl.length());
        ldapIndex = crl.indexOf("?");
        String dn = crl.substring(0, ldapIndex);
        String cn = crl.substring(crl.indexOf("=") + 1, crl.indexOf(","));
        boolean revoke = false;
        X509CRL x509Crl = null;
        try {
            x509Crl = X509CertValidator.getCRLFromLDAP(ip, port, dn, cn);
        }
        catch (Exception ex) {
            throw new PKIException("Download crl file failure from LDAP Server");
        }
        if (x509Crl != null) {
            revoke = x509Crl.isRevoke(userCert.getSerialNumber());
            return !revoke;
        }
        throw new PKIException("Download crl file failure from LDAP");
    }

    private static X509CRL getCRLFromLDAP(String ip, String port, String dn, String cn) throws Exception {
        InitialDirContext ctx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + ip + ":" + port);
        env.put("java.naming.ldap.attributes.binary", "certificateRevocationList");
        ctx = new InitialDirContext(env);
        SearchControls tConstraints = new SearchControls();
        tConstraints.setSearchScope(2);
        NamingEnumeration<SearchResult> tResults = null;
        String filter = "(&(objectclass=cRLDistributionPoint)(cn=" + cn + "))";
        Object[] attrs = new String[]{"certificateRevocationList;binary"};
        X509CRL crl = null;
        tResults = ctx.search(dn, filter, attrs, tConstraints);
        if (tResults != null && tResults.hasMore()) {
            SearchResult tSearchRel = null;
            Attributes allAttrs = null;
            Attribute attCRL = null;
            while (tResults.hasMore()) {
                tSearchRel = tResults.next();
                allAttrs = tSearchRel.getAttributes();
                attCRL = allAttrs.get("certificateRevocationList;binary");
                byte[] bCRL = (byte[])attCRL.get(0);
                crl = new X509CRL(bCRL);
            }
        }
        ctx.close();
        return crl;
    }

    private static final byte[] read(String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("Illegal Argument: filePath");
        }
        FileInputStream crls = null;
        try {
            int rLength;
            crls = new FileInputStream(filePath);
            byte[] out = new byte[crls.available()];
            byte[] buffer = new byte[65536];
            int offset = 0;
            while ((rLength = crls.read(buffer, 0, buffer.length)) != -1) {
                System.arraycopy(buffer, 0, out, offset, rLength);
                offset += rLength;
            }
            byte[] byArray = out;
            return byArray;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (crls != null) {
                try {
                    crls.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

