/*
 * Decompiled with CFR 0.152.
 */
package cryptokit.SMJNI;

import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sm.algorithm.SM3Digest;
import cryptokit.jni.JNISM2;
import java.math.BigInteger;

public final class SM2JNI {
    public static boolean generateKeypair(byte[] d, byte[] pubX, byte[] pubY) throws Exception {
        if (d == null || d.length != 32) {
            throw new SecurityException("null or length not allowed for d");
        }
        if (pubX == null || pubX.length != 32) {
            throw new SecurityException("null or length not allowed for pubX");
        }
        if (pubY == null || pubY.length != 32) {
            throw new SecurityException("null or length not allowed for pubY");
        }
        return JNISM2.generateKeypair((byte[])d, (byte[])pubX, (byte[])pubY);
    }

    public static boolean sign(byte[] hash, byte[] d, byte[] r, byte[] s) throws Exception {
        if (hash == null || hash.length != 32) {
            throw new SecurityException("null or length not allowed for hash");
        }
        if (d == null || d.length != 32) {
            throw new SecurityException("null or length not allowed for d");
        }
        if (r == null || r.length != 32) {
            throw new SecurityException("null or length not allowed for r");
        }
        if (s == null || s.length != 32) {
            throw new SecurityException("null or length not allowed for s");
        }
        return JNISM2.sign((byte[])hash, (byte[])d, (byte[])r, (byte[])s);
    }

    public static boolean verify(byte[] r, byte[] s, byte[] pubX, byte[] pubY, byte[] hash) throws Exception {
        if (hash == null || hash.length != 32) {
            throw new SecurityException("null or length not allowed for hash");
        }
        if (r == null || r.length != 32) {
            throw new SecurityException("null or length not allowed for r");
        }
        if (s == null || s.length != 32) {
            throw new SecurityException("null or length not allowed for s");
        }
        if (pubX == null || pubX.length != 32) {
            throw new SecurityException("null or length not allowed for pubX");
        }
        if (pubY == null || pubY.length != 32) {
            throw new SecurityException("null or length not allowed for pubY");
        }
        return JNISM2.verify((byte[])r, (byte[])s, (byte[])pubX, (byte[])pubY, (byte[])hash);
    }

    public static boolean calculateSM2ZValue(byte[] pubX, byte[] pubY, byte[] userID, byte[] Z) throws Exception {
        if (pubX == null || pubX.length != 32) {
            throw new SecurityException("null or length not allowed for pubX");
        }
        if (pubY == null || pubY.length != 32) {
            throw new SecurityException("null or length not allowed for pubY");
        }
        if (Z == null || Z.length != 32) {
            throw new SecurityException("null or length not allowed for  Z");
        }
        if (userID == null) {
            userID = SM2Params.getDefaultuserid();
        }
        return JNISM2.calculateZValue((byte[])pubX, (byte[])pubY, (byte[])userID, (byte[])Z);
    }

    public boolean quickVerify(byte[] r, byte[] s, byte[] pubX, byte[] pubY, byte[] sourceData, boolean bWithZValue) throws Exception {
        if (r == null || r.length != 32) {
            throw new SecurityException("null or length not allowed for r");
        }
        if (s == null || s.length != 32) {
            throw new SecurityException("null or length not allowed for s");
        }
        if (pubX == null || pubX.length != 32) {
            throw new SecurityException("null or length not allowed for pubX");
        }
        if (pubY == null || pubY.length != 32) {
            throw new SecurityException("null or length not allowed for pubY");
        }
        if (sourceData == null) {
            throw new SecurityException("null or length not allowed for sourceData");
        }
        byte[] hash = new byte[32];
        SM3Digest digest = new SM3Digest();
        if (bWithZValue) {
            byte[] z = SM2Params.calcZ(new BigInteger(1, pubX), new BigInteger(1, pubY));
            digest.update(z, 0, z.length);
        }
        digest.update(sourceData, 0, sourceData.length);
        digest.doFinal(hash, 0);
        return JNISM2.verify((byte[])r, (byte[])s, (byte[])pubX, (byte[])pubY, (byte[])hash);
    }
}

