/*
 * Decompiled with CFR 0.152.
 */
package lajp;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import lajp.MethodNotFoundException;
import lajp.MsgQ;
import lajp.PointGC;
import lajp.ReflectUtil;
import lajp.SingleThread;

public class PhpJava {
    static int IPC_KEY = 537006640;
    static final int HANDSHAKE_TYPE = 1;
    static final int MSG_MAX = 4096;
    static int msqid;
    static int pointProcessId;
    static long pointTime;

    static {
        pointProcessId = -1;
        pointTime = System.currentTimeMillis();
        System.loadLibrary("lajpmsgq");
    }

    public static void main(String[] args) {
        System.out.println("-------------------------------------------");
        System.out.println("- LAJP-JAVA (Message Queue) Service");
        System.out.println("- Time: " + new Date());
        System.out.println("-------------------------------------------");
        PhpJava.initIPC();
        PhpJava.charset();
        PhpJava.autoRun();
        msqid = MsgQ.msgget(IPC_KEY);
        byte[] buffer = new byte[1024];
        int bufLen = 1024;
        System.out.println("Server startup...");
        while (true) {
            int processId = -1;
            byte type = 0;
            try {
                bufLen = MsgQ.msgrcv(msqid, buffer, 1024, 1);
            }
            catch (Throwable e) {
                System.out.println("[LAJP Exception(warn)]");
                e.printStackTrace();
                continue;
            }
            if (bufLen != 35) {
                System.out.println("[LAJP Error(warn)]:HandShake Message length != 35");
                continue;
            }
            type = buffer[14];
            processId = Integer.parseInt(new String(buffer, 23, 10));
            if (type == 115) {
                try {
                    new SingleThread(processId).start();
                }
                catch (Throwable e) {
                    System.out.println("[LAJP Exception(warn)] SingleThread Exception: ");
                    e.printStackTrace();
                    continue;
                }
            }
            if (System.currentTimeMillis() - pointTime <= 300000L || processId % 1000 != 0) continue;
            if (pointProcessId < processId) {
                new PointGC(pointProcessId).start();
            }
            pointTime = System.currentTimeMillis();
            pointProcessId = processId;
        }
    }

    public static void initIPC() {
        int msgid;
        int semid = MsgQ.semget(IPC_KEY);
        if (semid == -1) {
            System.out.printf("semget(0x%x) error, can't start LAJP-JAVA.\n", IPC_KEY);
            System.exit(-1);
        }
        if (MsgQ.semclose(semid) == -1) {
            System.out.printf("semclose(0x%x) error, can't start LAJP-JAVA.\n", IPC_KEY);
            System.exit(-1);
        }
        if ((msgid = MsgQ.msgget(IPC_KEY)) == -1) {
            System.out.printf("msgget(0x%x) error, can't start LAJP-JAVA.\n", IPC_KEY);
            System.exit(-1);
        }
        if (MsgQ.msgclose(msgid) == -1) {
            System.out.printf("msgclose(0x%x) error, can't start LAJP-JAVA.\n", IPC_KEY);
            System.exit(-1);
        }
        if (MsgQ.msgget(IPC_KEY) == -1) {
            System.out.printf("msgget(0x%x) error, can't start LAJP-JAVA.\n", IPC_KEY);
            System.exit(-1);
        }
        System.out.println("init [IPC] Message Queue OK...");
        int shmid = MsgQ.shmget(IPC_KEY, 10);
        if (shmid == -1) {
            System.out.printf("shmget(0x%x) error, can't start LAJP-JAVA.\n", IPC_KEY);
            System.exit(-1);
        }
        if (MsgQ.shmclose(shmid) == -1) {
            System.out.printf("shmclose(0x%x) error, can't start LAJP-JAVA.\n", IPC_KEY);
            System.exit(-1);
        }
        if (MsgQ.shmget(IPC_KEY, 10) == -1) {
            System.out.printf("shmctl(0x%x) error, can't start LAJP-JAVA.\n", IPC_KEY);
            System.exit(-1);
        }
        System.out.println("init [IPC] Shared Memory OK...");
        if (MsgQ.semget(IPC_KEY) == -1) {
            System.out.printf("semget(0x%x) error, can't start LAJP-JAVA.\n", IPC_KEY);
            System.exit(-1);
        }
        System.out.println("init [IPC] Semaphore OK...");
    }

    private static void charset() {
        String charset = System.getenv("CHARSET");
        if (charset != null && !charset.trim().equals("")) {
            try {
                "\u4e2d\u6587".getBytes(SingleThread.PHP_CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            System.out.println("set charser: " + charset);
            SingleThread.PHP_CHARSET = charset;
        } else {
            System.out.println("set charser: UTF-8");
        }
    }

    public static void autoRun() {
        String autoRunClassName = System.getenv("AUTORUN_CLASS");
        String autoRunMethodName = System.getenv("AUTORUN_METHOD");
        if (autoRunClassName != null && !autoRunClassName.trim().equals("") && autoRunMethodName != null && !autoRunMethodName.trim().equals("")) {
            Method method = null;
            try {
                method = ReflectUtil.matchingMethod(autoRunClassName, autoRunMethodName, new Class[0]);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Can't find Class: " + autoRunClassName);
                e.printStackTrace();
                System.exit(-1);
            }
            catch (MethodNotFoundException e) {
                System.err.println("Can't find method: " + autoRunMethodName);
                e.printStackTrace();
                System.exit(-1);
            }
            try {
                method.invoke(null, null);
            }
            catch (IllegalArgumentException e) {
                System.err.println("IllegalArgumentException for call method " + autoRunClassName + "." + method.getName());
                e.printStackTrace();
                System.exit(-1);
            }
            catch (IllegalAccessException e) {
                System.err.println("IllegalAccessException for call method " + autoRunClassName + "." + method.getName());
                e.printStackTrace();
                System.exit(-1);
            }
            catch (InvocationTargetException e) {
                System.err.println("InvocationTargetException for call method " + autoRunClassName + "." + method.getName());
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

